/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.comm;

import java.io.IOException;
import jeus.transaction.GTID;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.TxStatus;
import jeus.transaction.comm.TMLinkManager;
import jeus.transaction.sub.SubCoordinator;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM0;

public final class RootCoordinatorProxy {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private final TMLinkManager manager;

    public RootCoordinatorProxy(TMLinkManager manager) {
        if (logger.isLoggable(JeusMessage_TM0._2801_LEVEL)) {
            logger.logp(JeusMessage_TM0._2801_LEVEL, "RootCoordinatorProxy", "<init>", JeusMessage_TM0._2801);
        }
        this.manager = manager;
    }

    public void beforeCompletion(GTID gtid, TMInfo tmServer, long ltid) {
        block7: {
            byte response;
            SubCoordinator coord;
            if (logger.isLoggable(JeusMessage_TM0._2802_LEVEL)) {
                logger.logp(JeusMessage_TM0._2802_LEVEL, "RootCoordinatorProxy", "beforeCompletion", JeusMessage_TM0._2802, (Object)tmServer.getGTID(ltid));
            }
            if ((coord = TMServer.getSubCoordinator(gtid)) != null) {
                coord.beforeCompletion();
                response = coord.isRollbackOnly() ? (byte)1 : 0;
            } else {
                if (logger.isLoggable(JeusMessage_TM0._2803_LEVEL)) {
                    logger.logp(JeusMessage_TM0._2803_LEVEL, "RootCoordinatorProxy", "beforeCompletion", JeusMessage_TM0._2803, (Object)gtid);
                }
                response = 1;
            }
            if (logger.isLoggable(JeusMessage_TM0._2804_LEVEL)) {
                logger.logp(JeusMessage_TM0._2804_LEVEL, "RootCoordinatorProxy", "beforeCompletion", JeusMessage_TM0._2804, (Object)TxStatus.getState(response));
            }
            try {
                this.manager.getLink(tmServer).beforeCompletionResponse(ltid, response);
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_TM0._2805_LEVEL)) break block7;
                logger.logp(JeusMessage_TM0._2805_LEVEL, "RootCoordinatorProxy", "beforeCompletion", JeusMessage_TM0._2805, (Object)tmServer, (Throwable)ex);
            }
        }
    }

    public void prepare(GTID gtid, TMInfo tmServer, long ltid) {
        byte response;
        SubCoordinator coord;
        block13: {
            if (logger.isLoggable(JeusMessage_TM0._2806_LEVEL)) {
                logger.logp(JeusMessage_TM0._2806_LEVEL, "RootCoordinatorProxy", "prepare", JeusMessage_TM0._2806, (Object)tmServer.getGTID(ltid));
            }
            if ((coord = TMServer.getSubCoordinator(gtid)) != null) {
                if (!coord.disableActiveTO()) {
                    if (logger.isLoggable(JeusMessage_TM0._2807_LEVEL)) {
                        logger.logp(JeusMessage_TM0._2807_LEVEL, "RootCoordinatorProxy", "prepare", JeusMessage_TM0._2807, (Object)gtid);
                    }
                    response = 4;
                } else {
                    response = coord.prepare();
                }
            } else {
                if (logger.isLoggable(JeusMessage_TM0._2808_LEVEL)) {
                    logger.logp(JeusMessage_TM0._2808_LEVEL, "RootCoordinatorProxy", "prepare", JeusMessage_TM0._2808, (Object)gtid);
                }
                response = 4;
            }
            if (logger.isLoggable(JeusMessage_TM0._2809_LEVEL)) {
                logger.logp(JeusMessage_TM0._2809_LEVEL, "RootCoordinatorProxy", "prepare", JeusMessage_TM0._2809, (Object)TxStatus.getState(response));
            }
            try {
                this.manager.getLink(tmServer).prepareResponse(ltid, response);
            }
            catch (Exception ex) {
                if (logger.isLoggable(JeusMessage_TM0._2810_LEVEL)) {
                    logger.logp(JeusMessage_TM0._2810_LEVEL, "RootCoordinatorProxy", "prepare", JeusMessage_TM0._2810, (Object)tmServer, (Throwable)ex);
                }
                if (response == 2 || response == 4) break block13;
                coord.rollback();
                coord.destroy();
                return;
            }
        }
        if (coord != null && response == 2) {
            if (logger.isLoggable(JeusMessage_TM0._2811_LEVEL)) {
                logger.logp(JeusMessage_TM0._2811_LEVEL, "RootCoordinatorProxy", "prepare", JeusMessage_TM0._2811);
            }
            coord.removeIncompletedSubTx();
            coord.afterCompletion(3);
            coord.destroy();
        }
    }

    public void commit(GTID gtid, TMInfo tmServer, long ltid) {
        block4: {
            byte response;
            if (logger.isLoggable(JeusMessage_TM0._2817_LEVEL)) {
                logger.logp(JeusMessage_TM0._2817_LEVEL, "RootCoordinatorProxy", "commit", JeusMessage_TM0._2817, (Object)tmServer.getGTID(ltid));
            }
            if ((response = RootCoordinatorProxy.commitSubCoordinator(gtid)) != -2) {
                try {
                    this.manager.getLink(tmServer).commitResponse(ltid, response == 3);
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(JeusMessage_TM0._2822_LEVEL)) break block4;
                    logger.logp(JeusMessage_TM0._2822_LEVEL, "RootCoordinatorProxy", "commit", JeusMessage_TM0._2822, (Object)tmServer, (Throwable)ex);
                }
            }
        }
    }

    public static byte commitSubCoordinator(GTID gtid) {
        byte response;
        SubCoordinator coord = TMServer.getSubCoordinator(gtid);
        if (coord != null) {
            if (coord.disablePreparedTO(8)) {
                response = coord.commit();
                coord.destroy();
            } else {
                if (logger.isLoggable(JeusMessage_TM0._2818_LEVEL)) {
                    logger.logp(JeusMessage_TM0._2818_LEVEL, "RootCoordinatorProxy", "commit", JeusMessage_TM0._2818, (Object)gtid);
                }
                response = 3;
            }
        } else {
            if (logger.isLoggable(JeusMessage_TM0._2820_LEVEL)) {
                logger.logp(JeusMessage_TM0._2820_LEVEL, "RootCoordinatorProxy", "commit", JeusMessage_TM0._2820, (Object)gtid);
            }
            try {
                response = TMServer.completeRecoveredSubCoordinator(gtid, true) ? (byte)3 : 4;
            }
            catch (TMException e) {
                e.printStackTrace();
                response = 4;
            }
        }
        if (logger.isLoggable(JeusMessage_TM0._2821_LEVEL)) {
            logger.logp(JeusMessage_TM0._2821_LEVEL, "RootCoordinatorProxy", "commit", JeusMessage_TM0._2821, (Object)TxStatus.getState(response));
        }
        return response;
    }

    public static void rollback(GTID gtid) {
        SubCoordinator coord;
        if (logger.isLoggable(JeusMessage_TM0._2823_LEVEL)) {
            logger.logp(JeusMessage_TM0._2823_LEVEL, "RootCoordinatorProxy", "rollback", JeusMessage_TM0._2823, (Object)gtid);
        }
        if ((coord = TMServer.getSubCoordinator(gtid)) == null) {
            if (logger.isLoggable(JeusMessage_TM0._2824_LEVEL)) {
                logger.logp(JeusMessage_TM0._2824_LEVEL, "RootCoordinatorProxy", "rollback", JeusMessage_TM0._2824, (Object)gtid);
            }
            try {
                TMServer.completeRecoveredSubCoordinator(gtid, false);
            }
            catch (TMException e) {
                e.printStackTrace();
            }
            return;
        }
        if (!coord.isPreparedCalled()) {
            if (!coord.disableActiveTO()) {
                if (logger.isLoggable(JeusMessage_TM0._2825_LEVEL)) {
                    logger.logp(JeusMessage_TM0._2825_LEVEL, "RootCoordinatorProxy", "rollback", JeusMessage_TM0._2825);
                }
                return;
            }
        } else if (!coord.disablePreparedTO(9)) {
            if (logger.isLoggable(JeusMessage_TM0._2826_LEVEL)) {
                logger.logp(JeusMessage_TM0._2826_LEVEL, "RootCoordinatorProxy", "rollback", JeusMessage_TM0._2826, (Object)gtid);
            }
            return;
        }
        coord.rollback();
        coord.destroy();
    }

    public void onePhaseCommit(GTID gtid, TMInfo tmServer, long ltid) {
        boolean timeouted;
        SubCoordinator coord;
        block8: {
            byte response;
            if (logger.isLoggable(JeusMessage_TM0._2827_LEVEL)) {
                logger.logp(JeusMessage_TM0._2827_LEVEL, "RootCoordinatorProxy", "onePhaseCommit", JeusMessage_TM0._2827, (Object)tmServer.getGTID(ltid));
            }
            coord = TMServer.getSubCoordinator(gtid);
            timeouted = false;
            if (coord != null) {
                response = coord.onePhaseCommit();
            } else {
                if (logger.isLoggable(JeusMessage_TM0._2828_LEVEL)) {
                    logger.logp(JeusMessage_TM0._2828_LEVEL, "RootCoordinatorProxy", "onePhaseCommit", JeusMessage_TM0._2828, (Object)gtid);
                }
                response = 4;
                timeouted = true;
            }
            if (logger.isLoggable(JeusMessage_TM0._2829_LEVEL)) {
                logger.logp(JeusMessage_TM0._2829_LEVEL, "RootCoordinatorProxy", "onePhaseCommit", JeusMessage_TM0._2829, (Object)TxStatus.getState(response));
            }
            try {
                this.manager.getLink(tmServer).onePhaseCommitResponse(ltid, response);
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_TM0._2830_LEVEL)) break block8;
                logger.logp(JeusMessage_TM0._2830_LEVEL, "RootCoordinatorProxy", "onePhaseCommit", JeusMessage_TM0._2830, (Object)tmServer, (Throwable)ex);
            }
        }
        if (!timeouted) {
            coord.destroy();
        }
    }

    public static void registered(GTID gtid, boolean isSuccessful) {
        SubCoordinator coord;
        if (logger.isLoggable(JeusMessage_TM0._2831_LEVEL)) {
            logger.logp(JeusMessage_TM0._2831_LEVEL, "RootCoordinatorProxy", "registered", JeusMessage_TM0._2831, (Object)gtid);
        }
        if ((coord = TMServer.getSubCoordinator(gtid)) == null) {
            if (logger.isLoggable(JeusMessage_TM0._2832_LEVEL)) {
                logger.logp(JeusMessage_TM0._2832_LEVEL, "RootCoordinatorProxy", "registered", JeusMessage_TM0._2832, (Object)gtid);
            }
            return;
        }
        coord.registered(isSuccessful);
    }

    public void commitLocalXAResource(GTID gtid, TMInfo tmServer, long ltid) {
        byte response;
        SubCoordinator coord;
        block11: {
            if (logger.isLoggable(JeusMessage_TM0._2833_LEVEL)) {
                logger.logp(JeusMessage_TM0._2833_LEVEL, "RootCoordinatorProxy", "commitLocalXAResource", JeusMessage_TM0._2833, (Object)gtid);
            }
            if ((coord = TMServer.getSubCoordinator(gtid)) != null) {
                response = coord.commitLocalXAResource();
            } else {
                if (logger.isLoggable(JeusMessage_TM0._2834_LEVEL)) {
                    logger.logp(JeusMessage_TM0._2834_LEVEL, "RootCoordinatorProxy", "commitLocalXAResource", JeusMessage_TM0._2834, (Object)gtid);
                }
                response = 1;
            }
            if (logger.isLoggable(JeusMessage_TM0._2835_LEVEL)) {
                logger.logp(JeusMessage_TM0._2835_LEVEL, "RootCoordinatorProxy", "commitLocalXAResource", JeusMessage_TM0._2835, (Object)TxStatus.getState(response));
            }
            try {
                boolean isCommitted = response == 9 || response == 0;
                this.manager.getLink(tmServer).commitLocalXAResourceResponse(ltid, isCommitted);
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_TM0._2836_LEVEL)) break block11;
                logger.logp(JeusMessage_TM0._2836_LEVEL, "RootCoordinatorProxy", "commitLocalXAResource", JeusMessage_TM0._2836, (Object)tmServer, (Throwable)ex);
            }
        }
        if (coord != null) {
            if (response == 1) {
                coord.rollback();
                coord.destroy();
            } else if (response == 9) {
                coord.destroy();
            }
        }
    }

    public void flush(GTID gtid, TMInfo tmServer, long ltid) {
        block10: {
            byte response;
            if (logger.isLoggable(JeusMessage_TM0._2837_LEVEL)) {
                logger.logp(JeusMessage_TM0._2837_LEVEL, "RootCoordinatorProxy", "flush", JeusMessage_TM0._2837, (Object)gtid);
            }
            SubCoordinator coord = TMServer.getSubCoordinator(gtid);
            try {
                if (coord != null) {
                    coord.flush_subcoordinator();
                    response = 0;
                } else {
                    if (logger.isLoggable(JeusMessage_TM0._2838_LEVEL)) {
                        logger.logp(JeusMessage_TM0._2838_LEVEL, "RootCoordinatorProxy", "flush", JeusMessage_TM0._2838, (Object)gtid);
                    }
                    response = 1;
                }
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_TM0._2839_LEVEL)) {
                    logger.logp(JeusMessage_TM0._2839_LEVEL, "RootCoordinatorProxy", "flush", JeusMessage_TM0._2839, (Object)gtid);
                }
                response = 1;
            }
            if (logger.isLoggable(JeusMessage_TM0._2840_LEVEL)) {
                logger.logp(JeusMessage_TM0._2840_LEVEL, "RootCoordinatorProxy", "flush", JeusMessage_TM0._2840, (Object)TxStatus.getState(response));
            }
            try {
                this.manager.getLink(tmServer).flushResponse(ltid, response);
            }
            catch (Exception ex) {
                if (!logger.isLoggable(JeusMessage_TM0._2841_LEVEL)) break block10;
                logger.logp(JeusMessage_TM0._2841_LEVEL, "RootCoordinatorProxy", "flush", JeusMessage_TM0._2841, (Object)tmServer, (Throwable)ex);
            }
        }
    }

    public static void requestFlushResponse(GTID gtid, byte response) {
        block5: {
            if (logger.isLoggable(JeusMessage_TM0._2842_LEVEL)) {
                logger.logp(JeusMessage_TM0._2842_LEVEL, "RootCoordinatorProxy", "requestFlushResponse", JeusMessage_TM0._2842, new Object[]{gtid, TxStatus.getState(response)});
            }
            SubCoordinator coord = TMServer.getSubCoordinator(gtid);
            try {
                if (coord != null) {
                    coord.requestFlushResponse(response);
                    return;
                }
                if (logger.isLoggable(JeusMessage_TM0._2843_LEVEL)) {
                    logger.logp(JeusMessage_TM0._2843_LEVEL, "RootCoordinatorProxy", "requestFlushResponse", JeusMessage_TM0._2843, (Object)gtid);
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM0._2844_LEVEL)) break block5;
                logger.logp(JeusMessage_TM0._2844_LEVEL, "RootCoordinatorProxy", "requestFlushResponse", JeusMessage_TM0._2844, t);
            }
        }
    }

    public void writeReply(TMInfo socketID, Object msg) {
        block2: {
            try {
                this.manager.getLink(socketID).writeReply(msg);
            }
            catch (IOException ex) {
                if (!logger.isLoggable(JeusMessage_TM0._2841_LEVEL)) break block2;
                logger.logp(JeusMessage_TM0._2841_LEVEL, "RootCoordinatorProxy", "flush", JeusMessage_TM0._2841, (Object)socketID, (Throwable)ex);
            }
        }
    }
}

