/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.comm;

import java.io.IOException;
import java.net.Socket;
import javax.management.ObjectName;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.io.protocol.message.ContentHandlerCreator;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.ConnectorException;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.net.impl.SocketStream14;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.comm.RootCoordinatorProxy;
import jeus.transaction.comm.SubCoordinatorProxy;
import jeus.transaction.comm.TMLink;
import jeus.util.JeusPort;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.ThreadPoolExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM1;

public final class TMLinkManager
implements ConnectionListenerFactory {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private static final String CLIENT_WORKER_POOL_NAME = "TMLink.Client";
    private static final String SERVER_WORKER_POOL_NAME = "TMLink.Server";
    protected static final int backlog = 1000;
    private int port;
    private final boolean isNonBlocking;
    protected ObjectName parentName;
    private TMInfo myInfo;
    ThreadPoolExecutor pooledExecutorServer;
    ThreadPoolExecutor pooledExecutorClient;
    RootCoordinatorProxy rootProxy;
    SubCoordinatorProxy subProxy;
    private Endpoint endPoint;
    public static final int TM_PROTOCOL_VERSION = 1;

    public TMLinkManager(boolean isNonBlocking, boolean isServerVM) {
        this.isNonBlocking = isNonBlocking;
    }

    public final int init(byte[] ipaddr, int port, int starttime, int conId, int size, int max, long resizingPeriod) throws IOException {
        if (logger.isLoggable(JeusMessage_TM1._3203_LEVEL)) {
            logger.logp(JeusMessage_TM1._3203_LEVEL, "TMLinkManager", "init", JeusMessage_TM1._3203, new Object[]{String.valueOf(port), String.valueOf(size), String.valueOf(max), String.valueOf(resizingPeriod)});
        }
        this.rootProxy = new RootCoordinatorProxy(this);
        this.subProxy = new SubCoordinatorProxy(this);
        this.pooledExecutorServer = (ThreadPoolExecutor)PooledExecutorFactory.createPooledExecutor((String)SERVER_WORKER_POOL_NAME, (int)max, (int)size, (long)resizingPeriod);
        this.pooledExecutorClient = (ThreadPoolExecutor)PooledExecutorFactory.createPooledExecutor((String)CLIENT_WORKER_POOL_NAME, (int)max, (int)size, (long)resizingPeriod);
        if (port == 0) {
            port = this.getAvailablePort(ipaddr, starttime);
        } else {
            this.myInfo = new TMInfo(ipaddr, port, starttime, conId);
            String name = "TMLinkManager";
            this.endPoint = new Endpoint(name, this.isNonBlocking ? JeusIOComponentCreator.DEFAULT_CREATOR : JeusIOComponentCreator.createBlockingCreator((String)("IO-" + name), (int)0), (SocketID)this.myInfo, (StreamContentHandlerCreator)new ContentHandlerCreator(), (ConnectionListenerFactory)this, null);
            this.endPoint.export();
        }
        this.port = port;
        if (logger.isLoggable(JeusMessage_TM1._3209_LEVEL)) {
            logger.logp(JeusMessage_TM1._3209_LEVEL, "TMLinkManager", "export", JeusMessage_TM1._3209);
        }
        return port;
    }

    private int getAvailablePort(byte[] ipaddr, int starttime) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3205_LEVEL)) {
            logger.logp(JeusMessage_TM1._3205_LEVEL, "TMLinkManager", "getAvailablePort", JeusMessage_TM1._3205, (Object)String.valueOf(JeusPort.TMBase));
        }
        this.myInfo = new TMInfo(ipaddr, 0, starttime, -1);
        String name = "TMLinkManager";
        Endpoint point = new Endpoint(name, this.isNonBlocking ? JeusIOComponentCreator.DEFAULT_CREATOR : JeusIOComponentCreator.createBlockingCreator((String)("IO-" + name), (int)0), (SocketID)this.myInfo, (StreamContentHandlerCreator)new ContentHandlerCreator(), (ConnectionListenerFactory)this, null);
        for (int i = 30; i < 256; ++i) {
            try {
                int port = JeusPort.TMBase + i;
                this.myInfo.setPort(port);
                point.setPort((SocketID)this.myInfo);
                point.export();
                if (logger.isLoggable(JeusMessage_TM1._3208_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3208_LEVEL, "TMLinkManager", "getAvailablePort", JeusMessage_TM1._3208, (Object)String.valueOf(JeusPort.TMBase + i));
                }
                this.endPoint = point;
                return port;
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM1._3206_LEVEL)) continue;
                logger.logp(JeusMessage_TM1._3206_LEVEL, "TMLinkManager", "getAvailablePort", JeusMessage_TM1._3206, (Object)String.valueOf(JeusPort.TMBase + i));
                continue;
            }
        }
        throw new TMException(JeusMessage_TM1._3207, new String[]{String.valueOf(JeusPort.TMBase), String.valueOf(JeusPort.TMBase + 255)});
    }

    public final void unexport() {
        if (logger.isLoggable(JeusMessage_TM1._3210_LEVEL)) {
            logger.logp(JeusMessage_TM1._3210_LEVEL, "TMLinkManager", "unexport", JeusMessage_TM1._3210);
        }
        this.pooledExecutorServer.shutdownNow();
        this.pooledExecutorClient.shutdownNow();
        this.endPoint.unexport();
        if (this.myInfo.getVirtualID() == null && !this.isNonBlocking) {
            try {
                Socket s = new Socket("localhost", this.port);
                s.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public final TMLink getLink(SocketID tmServer) throws ConnectorException {
        SocketStream14 sockStream14 = (SocketStream14)this.endPoint.getSocketStream(tmServer, 1, (Object)new Integer(1), 0, 0);
        return (TMLink)sockStream14.getListener();
    }

    public final String getGTID(long ltid) {
        return this.myInfo.getGTID(ltid);
    }

    public final String toString() {
        return this.myInfo.toString();
    }

    public final ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return new TMLink(this);
    }

    public final TMInfo getMyInfo() {
        return this.myInfo;
    }
}

