/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.comm;

import java.util.logging.Level;
import javax.transaction.xa.Xid;
import jeus.transaction.GTID;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.client.TMClient;
import jeus.transaction.comm.RootCoordinatorProxy;
import jeus.transaction.comm.SubCoordinatorProxy;
import jeus.transaction.comm.TMClientProxy;
import jeus.transaction.comm.TMLink;
import jeus.transaction.comm.TxControlMessage;
import jeus.util.ByteUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM1;

final class Worker {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private byte[] request;
    private final RootCoordinatorProxy rootProxy;
    private final SubCoordinatorProxy subProxy;
    static final byte REQ_REGISTER_RESOURCE = 1;
    static final byte REQ_REGISTERED_ACK = 17;
    static final byte REQ_PREPARE = 5;
    static final byte REQ_PREPARE_ACK = 6;
    static final byte REQ_REPLAY_COMPLETION = 7;
    static final byte REQ_COMMIT = 9;
    static final byte REQ_COMMIT_ACK = 10;
    static final byte REQ_ROLLBACK = 11;
    static final byte REQ_ONE_PHASE_COMMIT = 12;
    static final byte REQ_ONE_PHASE_COMMIT_ACK = 14;
    static final byte REQ_DISCONNECT = 13;
    static final byte REQ_REMOTE_COMMIT = 15;
    static final byte REQ_REMOTE_COMMIT_ACK = 16;
    static final byte REQ_COMMIT_LOCAL_XA_RESOURCE = 18;
    static final byte REQ_COMMIT_LOCAL_XA_RESOURCE_ACK = 19;
    static final byte REQ_BEFORE_COMPLETION = 20;
    static final byte REQ_BEFORE_COMPLETION_ACK = 21;
    static final byte REQ_FLUSH = 22;
    static final byte REQ_FLUSH_ACK = 23;
    static final byte REQ_REQUST_FLUSH = 24;
    static final byte REQ_REQUEST_FLUSH_ACK = 25;
    static final byte REQ_REMOTE_XA_PREPARE = 26;
    static final byte REQ_REMOTE_XA_COMMIT = 27;
    static final byte REQ_XA_RESOURCE_RECOVER = 28;
    static final byte REQ_XA_RESOURCE_COMPLETION = 29;
    static final byte REQ_XA_RESOURCE_FORGET = 30;
    private static final byte REPLY_TYPE = -1;
    private TMInfo socketID;

    private static String getState(byte code) {
        switch (code) {
            case 1: {
                return "REQ_REGISTER_RESOURCE";
            }
            case 17: {
                return "REQ_REGISTERED_ACK";
            }
            case 5: {
                return "REQ_PREPARE";
            }
            case 6: {
                return "REQ_PREPARE_ACK";
            }
            case 7: {
                return "REQ_REPLAY_COMPLETION";
            }
            case 9: {
                return "REQ_COMMIT";
            }
            case 10: {
                return "REQ_COMMIT_ACK";
            }
            case 11: {
                return "REQ_ROLLBACK";
            }
            case 12: {
                return "REQ_ONE_PHASE_COMMIT";
            }
            case 14: {
                return "REQ_ONE_PHASE_COMMIT_ACK";
            }
            case 15: {
                return "REQ_REMOTE_COMMIT";
            }
            case 16: {
                return "REQ_REMOTE_COMMIT_ACK";
            }
            case 18: {
                return "REQ_COMMIT_LOCAL_XA_RESOURCE";
            }
            case 19: {
                return "REQ_COMMIT_LOCAL_XA_RESOURCE_ACK";
            }
            case 20: {
                return "REQ_BEFORE_COMPLETION";
            }
            case 21: {
                return "REQ_BEFORE_COMPLETION_ACK";
            }
            case 22: {
                return "REQ_FLUSH";
            }
            case 23: {
                return "REQ_FLUSH_ACK";
            }
            case 24: {
                return "REQ_REQUST_FLUSH";
            }
            case 25: {
                return "REQ_REQUEST_FLUSH_ACK";
            }
            case 26: {
                return "REQ_REMOTE_XA_PREPARE";
            }
            case 27: {
                return "REQ_REMOTE_XA_COMMIT";
            }
            case 28: {
                return "REQ_XA_RESOURCE_RECOVER";
            }
            case 30: {
                return "REQ_XA_RESOURCE_FORGET";
            }
        }
        return "invalid code : " + code;
    }

    public Worker(RootCoordinatorProxy rootProxy, SubCoordinatorProxy subProxy) {
        this.rootProxy = rootProxy;
        this.subProxy = subProxy;
        if (logger.isLoggable(JeusMessage_TM1._3301_LEVEL)) {
            logger.logp(JeusMessage_TM1._3301_LEVEL, "Worker", "<init>", JeusMessage_TM1._3301);
        }
    }

    public void handleRequest(TMLink link, byte[] request) {
        block3: {
            if (logger.isLoggable(JeusMessage_TM1._3307_LEVEL)) {
                logger.logp(JeusMessage_TM1._3307_LEVEL, "Worker", "handleRequest", JeusMessage_TM1._3307, (Object)link.socketID);
            }
            this.socketID = link.socketID;
            this.request = request;
            try {
                this.acceptRequests();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM1._3304_LEVEL)) break block3;
                logger.logp(JeusMessage_TM1._3304_LEVEL, "Worker", "run", JeusMessage_TM1._3304, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(TMLink link, Object request) {
        if (logger.isLoggable(JeusMessage_TM1._3307_LEVEL)) {
            logger.logp(JeusMessage_TM1._3307_LEVEL, "Worker", "handleRequest", JeusMessage_TM1._3307, (Object)link.socketID);
        }
        this.socketID = link.socketID;
        try {
            TxControlMessage msg = (TxControlMessage)request;
            byte type = msg.getType();
            switch (type) {
                case 7: {
                    this.socketID = (TMInfo)msg.getData()[0];
                    link.closeLink();
                    SubCoordinatorProxy.replayCompletion(this.socketID);
                    return;
                }
                case 29: {
                    Object[] data = msg.getData();
                    Xid xid = (Xid)data[0];
                    boolean isCommit = (Boolean)data[1];
                    try {
                        TMServer.setGlobalDecisionForSubXids(xid, isCommit);
                        this.rootProxy.writeReply(this.socketID, new Integer(0));
                        return;
                    }
                    catch (Throwable t) {
                        if (logger.isLoggable(JeusMessage_TM1._3313_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3313_LEVEL, "Worker", "run", JeusMessage_TM1._3313, t);
                        }
                        this.rootProxy.writeReply(this.socketID, new Integer(-7));
                    }
                    return;
                }
                case 30: {
                    Object[] data2 = msg.getData();
                    Xid xid2 = (Xid)data2[0];
                    TxControlMessage replyMsg = new TxControlMessage(-1);
                    try {
                        TMServer.forgetIncompleteTxForSubXids(xid2);
                        replyMsg.setData(null);
                        return;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        msg.setData(new Object[]{t});
                        return;
                    }
                    finally {
                        this.rootProxy.writeReply(this.socketID, replyMsg);
                    }
                }
                default: {
                    if (!logger.isLoggable(Level.FINE)) return;
                    logger.log(Level.FINE, "unknown tx control message type : " + type);
                }
            }
            return;
        }
        catch (Throwable t) {
            if (!logger.isLoggable(JeusMessage_TM1._3304_LEVEL)) return;
            logger.logp(JeusMessage_TM1._3304_LEVEL, "Worker", "run", JeusMessage_TM1._3304, t);
        }
    }

    private void acceptRequests() {
        if (logger.isLoggable(JeusMessage_TM1._3309_LEVEL)) {
            logger.logp(JeusMessage_TM1._3309_LEVEL, "Worker", "acceptRequests", JeusMessage_TM1._3309, new Object[]{Worker.getState(this.request[0]), this.socketID});
        }
        long ltid = 0L;
        if (this.request.length > 1) {
            ltid = ByteUtil.convertToLong((byte[])this.request, (int)1);
        }
        switch (this.request[0]) {
            case 1: {
                this.subProxy.registerResource(ltid, this.socketID, this.request[9] != 0);
                break;
            }
            case 5: {
                this.rootProxy.prepare(new GTID(this.socketID, ltid), this.socketID, ltid);
                break;
            }
            case 6: {
                this.subProxy.prepareResponse(ltid, this.socketID, this.request[9]);
                break;
            }
            case 9: {
                this.rootProxy.commit(new GTID(this.socketID, ltid), this.socketID, ltid);
                break;
            }
            case 10: {
                this.subProxy.commitResponse(ltid, this.request[9] != 0);
                break;
            }
            case 11: {
                RootCoordinatorProxy.rollback(new GTID(this.socketID, ltid));
                break;
            }
            case 12: {
                this.rootProxy.onePhaseCommit(new GTID(this.socketID, ltid), this.socketID, ltid);
                break;
            }
            case 14: {
                this.subProxy.onePhaseCommitResponse(ltid, this.request[9]);
                break;
            }
            case 15: {
                TMClientProxy.remoteCommit(ltid, this.request[9] == 0, this.socketID);
                break;
            }
            case 16: {
                TMClient.remoteCommitResponse(new GTID(this.socketID, ltid), this.request[9]);
                break;
            }
            case 17: {
                RootCoordinatorProxy.registered(new GTID(this.socketID, ltid), this.request[9] == 1);
                break;
            }
            case 18: {
                this.rootProxy.commitLocalXAResource(new GTID(this.socketID, ltid), this.socketID, ltid);
                break;
            }
            case 19: {
                this.subProxy.commitLocalXAResourceResponse(ltid, this.request[9] == 0);
                break;
            }
            case 20: {
                this.rootProxy.beforeCompletion(new GTID(this.socketID, ltid), this.socketID, ltid);
                break;
            }
            case 21: {
                this.subProxy.beforeCompletionResponse(ltid, this.request[9]);
                break;
            }
            case 22: {
                this.rootProxy.flush(new GTID(this.socketID, ltid), this.socketID, ltid);
                break;
            }
            case 23: {
                this.subProxy.flushResponse(ltid, this.request[9]);
                break;
            }
            case 24: {
                this.subProxy.requestFlush(ltid, this.socketID);
                break;
            }
            case 25: {
                RootCoordinatorProxy.requestFlushResponse(new GTID(this.socketID, ltid), this.request[9]);
                break;
            }
            case 26: {
                TMClientProxy.remoteXAPrepare(ltid, this.socketID);
                break;
            }
            case 27: {
                TMClientProxy.remoteXACommit(ltid, this.request[9] == 0, this.socketID);
                break;
            }
            case 28: {
                TxControlMessage msg = new TxControlMessage(-1);
                try {
                    Object[] subXids = TMServer.getSubXids(this.socketID);
                    msg.setData(subXids);
                }
                catch (TMException e) {
                    e.printStackTrace();
                    msg.setData(new Object[]{e});
                }
                this.rootProxy.writeReply(this.socketID, msg);
                break;
            }
        }
    }
}

