/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.transaction.xa.Xid;
import jeus.management.j2ee.transaction.ReferenceInfo;
import jeus.transaction.GTID;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxStatus;
import jeus.transaction.XAResourceFactory;
import jeus.transaction.XidImpl;
import jeus.transaction.external.OTSXid;
import jeus.transaction.logging.AbstractXAResourceFactory;
import jeus.transaction.logging.IncompletedTx;
import jeus.transaction.logging.LogManager;
import jeus.transaction.logging.SubCoordinatorXidContainer;
import jeus.transaction.logging.TxRecoveryDelegator;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.sub.SubCoordinator;
import jeus.transaction.util.XidToString;
import jeus.util.ByteUtil;
import jeus.util.Serializer;
import jeus.util.VirtualDNS;
import jeus.util.logging.ErrorHandlerFactory;
import jeus.util.logging.JeusFormatter;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.JeusLoggerConfiguration;
import jeus.util.logging.SimpleFormatter;
import jeus.util.message.JeusMessage_TMRecovery0;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.xml.binding.jeusDD.FileHandlerType;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.ReplayListener;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;
import org.objectweb.howl.log.xa.XALogger;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions._RecoveryCoordinatorStub;

public final class HowlLogManager
extends LogManager {
    private static final byte XA_RESOURCE_LOG = 0;
    private static final byte COMMIT_LOG = 1;
    private static final byte EXTERNAL_PREPARE_LOG = 2;
    private static final byte OTS_PREPARE_LOG = 3;
    private static final byte[] XA_RESOURCE_LOG_ARRAY = new byte[]{0};
    private static final byte[] COMMIT_LOG_ARRAY = new byte[]{1};
    private static final byte[] EXTERNAL_PREPARE_LOG_ARRAY = new byte[]{2};
    private static final byte[] OTS_PREPARE_LOG_ARRAY = new byte[]{3};
    private static final int COMMIT_LOG_LENGTH = 3;
    private static final int EXTERNAL_PREPARE_LENGTH = 6;
    private static final int OTS_PREPARE_LENGTH = 7;
    private XALogger xaLog;
    private byte[] startTimeBytes;
    private final Hashtable committingTxMap = new Hashtable();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction.recovery");
    private static final Serializer serializer = new Serializer();
    private final SubCoordinatorXidContainer subXidContainer = new SubCoordinatorXidContainer();
    private final TxRecoveryDelegator txRecoveryDelegator = new TxRecoveryDelegator();
    private long serverStartTime;
    private XALogger resourceLog;
    private boolean isClosed;
    private static final byte[] DUMMY_BYTES = new byte[0];
    private static final String CONTAINER_NAME_SEPARATOR = "_LOCATION_";

    public HowlLogManager(FileHandlerType desc) {
        if (desc == null) {
            return;
        }
        String logDir = VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName;
        SimpleFormatter formatter = new SimpleFormatter();
        formatter.setProperty(Collections.EMPTY_MAP);
        try {
            JeusLoggerConfiguration.addFileHandler(logger, desc, logDir, "tm.log", (JeusFormatter)formatter, ErrorHandlerFactory.handlerFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void start(TMInfo tmServer, long startTime) throws TMException {
        this.startTimeBytes = ByteUtil.convertToByte((int)tmServer.getTime());
        this.serverStartTime = startTime;
        String location = tmServer.getLocationString();
        IncompletedTx.setTMInfo(tmServer);
        this.xaLog = HowlLogManager.openXALogger("jeustx", 4, JeusManagerPropertyValues.containerName, this.txRecoveryDelegator, logDir, location);
        this.resourceLog = HowlLogManager.openXALogger("jeusres", 16, JeusManagerPropertyValues.containerName, this.txRecoveryDelegator, logDir, location);
        this.txRecoveryDelegator.start(this, tmServer);
    }

    public static TxRecoveryDelegator getTxRecoveryDelegator(String logDir, String containerName, String location) throws TMException {
        TxRecoveryDelegator txRecoveryDelegator = new TxRecoveryDelegator();
        HowlLogManager.openXALogger("jeustx", 4, containerName, txRecoveryDelegator, logDir, location);
        HowlLogManager.openXALogger("jeusres", 16, containerName, txRecoveryDelegator, logDir, location);
        return txRecoveryDelegator;
    }

    private static XALogger openXALogger(String fileName, int blockSize, String containerName, TxRecoveryDelegator txRecoveryDelegator, String logDir, String location) throws TMException {
        Properties howlprop = new Properties();
        String myhowlprop = System.getProperty("howl.log.ListConfiguration", "false");
        howlprop.put("listConfig", myhowlprop);
        myhowlprop = System.getProperty("howl.log.BufferSize", String.valueOf(blockSize));
        howlprop.put("bufferSize", myhowlprop);
        myhowlprop = System.getProperty("howl.log.flushPartialBuffers", "true");
        howlprop.put("flushPartialBuffers", myhowlprop);
        myhowlprop = System.getProperty("howl.log.MinimumBuffers", "16");
        howlprop.put("minBuffers", myhowlprop);
        myhowlprop = System.getProperty("howl.log.MaximumBuffers", "16");
        howlprop.put("maxBuffers", myhowlprop);
        myhowlprop = System.getProperty("howl.log.MaximumBlocksPerFile", "500");
        howlprop.put("maxBlocksPerFile", myhowlprop);
        String def = logDir + File.separator + "_" + containerName + CONTAINER_NAME_SEPARATOR + location;
        myhowlprop = System.getProperty("howl.log.FileDirectory", def);
        howlprop.put("logFileDir", myhowlprop);
        myhowlprop = System.getProperty("howl.log.FileName", fileName);
        howlprop.put("logFileName", myhowlprop);
        myhowlprop = System.getProperty("howl.log.MaximumFiles", "2");
        howlprop.put("maxLogFiles", myhowlprop);
        myhowlprop = System.getProperty("howl.log.checksumEnabled", "false");
        howlprop.put("checksumEnabled", myhowlprop);
        if (logger.isLoggable(JeusMessage_TMRecovery0._1001_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1001_LEVEL, "HowlLogManager", "<init>", JeusMessage_TMRecovery0._1001, (java.lang.Object)fileName);
        }
        return HowlLogManager.howlOpenLog(howlprop, txRecoveryDelegator);
    }

    private static synchronized XALogger howlOpenLog(Properties phowlprop, TxRecoveryDelegator txRecoveryDelegator) throws TMException {
        XALogger xaLog;
        try {
            Configuration cfg = new Configuration(phowlprop);
            xaLog = new XALogger(cfg);
        }
        catch (LogConfigurationException e) {
            throw new TMException("LogConfigurationException occured in XALogger() " + e.getMessage());
        }
        catch (IOException e) {
            throw new TMException("IOException occured in XALogger() " + e.getMessage());
        }
        catch (Exception e) {
            throw new TMException("Exception occurred in XALogger() " + e.getMessage());
        }
        resourceAcquirer myxarl = new resourceAcquirer(txRecoveryDelegator);
        try {
            xaLog.open(null);
        }
        catch (LogException e) {
            throw new TMException("LogException occured in xaLog.open()", (Throwable)e);
        }
        catch (IOException e) {
            throw new TMException("IOException occured in xaLog.open()", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TMException("InterruptedException occured in xaLog.open()", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new TMException("ClassNotFoundException occured in xaLog.open()", (Throwable)e);
        }
        catch (Exception e) {
            throw new TMException("Exception occurred in xaLog.open()", (Throwable)e);
        }
        xaLog.replayActiveTx((ReplayListener)myxarl);
        return xaLog;
    }

    public final synchronized void close() throws TMException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (!(this.txRecoveryDelegator.hasIncompletedTx() || this.subXidContainer.hasIncompleteSubTx() || ThreadContexts.hasActiveCoordinator())) {
            this.txRecoveryDelegator.removeAllCurrentResourceReferences();
        }
        try {
            this.xaLog.close();
        }
        catch (Exception e) {
            throw new TMException("Exception occured in xaLog.close() ", (Throwable)e);
        }
        try {
            this.resourceLog.close();
        }
        catch (Exception e) {
            throw new TMException("Exception occured in resourceLog.close() ", (Throwable)e);
        }
        this.txRecoveryDelegator.destroy();
    }

    public final void logXAResourceReference(String exportName, XAResourceFactory xaResourceFactory) throws TMException {
        if (logger.isLoggable(JeusMessage_TMRecovery0._1005_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1005_LEVEL, "HowlLogManager", "logXAResourceReference", JeusMessage_TMRecovery0._1005, (java.lang.Object)xaResourceFactory);
        }
        try {
            byte[] nameByte = serializer.serialize((java.lang.Object)exportName);
            byte[] b = serializer.serialize((java.lang.Object)xaResourceFactory);
            XACommittingTx tx = this.resourceLog.putCommit((byte[][])new byte[][]{XA_RESOURCE_LOG_ARRAY, nameByte, b});
            ReferenceInfo value = new ReferenceInfo(xaResourceFactory, exportName, tx, this.serverStartTime);
            this.txRecoveryDelegator.addCurrentResourceRef(value, value);
        }
        catch (Throwable ex) {
            throw new TMException(JeusMessage_TMRecovery0._1006, ex);
        }
    }

    public final void logCommit(long ltid, Xid externalXid, ResourceImpl otsResource) throws TMException {
        byte[][] log;
        if (externalXid == null) {
            log = new byte[3][];
            log[0] = COMMIT_LOG_ARRAY;
        } else {
            if (externalXid instanceof OTSXid) {
                log = new byte[7][];
                log[0] = OTS_PREPARE_LOG_ARRAY;
                if (otsResource != null) {
                    RecoveryCoordinator recoveryCoordinator = otsResource.getRecoveryCoordinator();
                    log[6] = this.makeCorbaObjectToString(recoveryCoordinator);
                } else {
                    log[6] = DUMMY_BYTES;
                }
            } else {
                log = new byte[6][];
                log[0] = EXTERNAL_PREPARE_LOG_ARRAY;
            }
            log[3] = externalXid.getGlobalTransactionId();
            log[4] = externalXid.getBranchQualifier();
            log[5] = ByteUtil.convertToByte((int)externalXid.getFormatId());
        }
        log[1] = this.startTimeBytes;
        log[2] = ByteUtil.convertToByte((long)ltid);
        if (logger.isLoggable(JeusMessage_TMRecovery0._1007_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1007_LEVEL, "HowlLogManager", "logCommit", JeusMessage_TMRecovery0._1007, new java.lang.Object[]{new Long(ltid), XidToString.getXidString(externalXid)});
        }
        try {
            XACommittingTx tx = this.xaLog.putCommit((byte[][])log);
            this.committingTxMap.put(new Long(ltid), tx);
        }
        catch (Exception e) {
            throw new TMException(e);
        }
    }

    private byte[] makeCorbaObjectToString(Object recoveryCoordinator) {
        String objString = jeus.transaction.ots.Configuration.getORB().object_to_string(recoveryCoordinator);
        return objString.getBytes();
    }

    public final void logDone(long ltid) throws TMException {
        XACommittingTx tx = (XACommittingTx)this.committingTxMap.remove(new Long(ltid));
        if (tx == null) {
            throw new TMException("CommittingTx is null");
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1008_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1008_LEVEL, "HowlLogManager", "longDone", JeusMessage_TMRecovery0._1008, (java.lang.Object)new Long(ltid));
        }
        this.logXaDone(tx);
    }

    public final synchronized void addIncompletedTX(long ltid, int time, long createtime, Xid xid, ResourceImpl otsResource) throws TMException {
        XACommittingTx committingTx = (XACommittingTx)this.committingTxMap.remove(new Long(ltid));
        if (committingTx == null) {
            throw new TMException("CommittingTx is null");
        }
        byte decision = xid == null || xid instanceof OTSXid && otsResource == null ? (byte)0 : -1;
        IncompletedTx tx = new IncompletedTx(ltid, time, createtime, xid, committingTx, otsResource, false, decision, 8);
        this.txRecoveryDelegator.addIncompletedTx(tx, tx, xid, otsResource);
    }

    public void logXaDone(XACommittingTx tx) {
        if (tx == null) {
            return;
        }
        try {
            this.xaLog.putDone((byte[][])null, tx);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "failed to put tx done log", (Throwable)e);
        }
    }

    public void logResourceDone(XACommittingTx tx) {
        if (tx == null) {
            return;
        }
        try {
            this.resourceLog.putDone((byte[][])null, tx);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "failed to put resource done log", (Throwable)e);
        }
    }

    public final byte getDecisionForIncompletedTx(long ltid, int time) {
        this.waitForRecovery();
        IncompletedTx tx = this.txRecoveryDelegator.getIncompletedTx(ltid, time);
        return TxRecoveryDelegator.getDecision(tx);
    }

    private IncompletedTx getMatchingIncompletedTx(Xid xid) {
        if (xid == null) {
            return null;
        }
        IncompletedTx tx = this.txRecoveryDelegator.getTxFromXidList(xid);
        if (tx == null && xid != null && xid.getFormatId() == 256077) {
            byte[] gtidBytes = xid.getGlobalTransactionId();
            if (gtidBytes == null) {
                return null;
            }
            GTID jeusGtid = new GTID(gtidBytes);
            tx = this.txRecoveryDelegator.getIncompletedTx(jeusGtid.getLTID(), jeusGtid.getTime());
        }
        return tx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setGlobalDecisionForIncompletedTransaction(Xid xid, boolean commit) throws TMException {
        this.waitForRecovery();
        IncompletedTx tx = this.getMatchingIncompletedTx(xid);
        if (tx == null) {
            throw new TMException("This xid is not known to JEUS, maybe this xid is already recovered or recover() is not called before calling commit or rollback : " + XidToString.getXidString(xid));
        }
        if (logger.isLoggable(JeusMessage_TMRecovery0._1004_LEVEL)) {
            logger.logp(JeusMessage_TMRecovery0._1004_LEVEL, "HowlLogManager", "setGlobalDecisionForIncompletedExternalTransaction", JeusMessage_TMRecovery0._1004, new java.lang.Object[]{XidToString.getXidString(xid), commit ? "commit" : "rollback"});
        }
        Map currentFailedRef = null;
        byte decision = commit ? (byte)0 : 1;
        tx.setGlobalDecision(decision);
        if (!tx.isRecovered()) {
            currentFailedRef = this.txRecoveryDelegator.resyncCurrentXAResources();
            if (this.txRecoveryDelegator.isCompletedTx(tx)) {
                return;
            }
            if (currentFailedRef.size() != 0) throw new TMException("failed to recover the xid(" + xid + ") and the incompleted tx(" + tx + ")");
            ArrayList childs = tx.getChildXids();
            if (childs == null || childs.size() != 0) throw new TMException("failed to recover the xid(" + xid + ") and the incompleted tx(" + tx + ")");
            this.logXaDone((XACommittingTx)tx.getHandback());
            this.removeIncompletedTx(tx);
            return;
        }
        if (this.txRecoveryDelegator.resyncChildTx(tx, xid)) throw new TMException("failed to recover the xid(" + xid + ") and the incompleted tx(" + tx + ")");
        throw new TMException("failed to recover the xid(" + xid + ") and the incompleted tx(" + tx + ")");
    }

    public IncompletedTx getIncompletedExternalTx(Xid xid) {
        this.waitForRecovery();
        return this.txRecoveryDelegator.getTxFromXidList(xid);
    }

    public IncompletedTx getIncompletedTx(GTID gtid) {
        if (gtid == null) {
            return null;
        }
        return this.txRecoveryDelegator.getIncompletedTx(gtid.getLTID(), gtid.getTime());
    }

    public ResourceImpl[] getIncompletedOtsResources() {
        this.waitForRecovery();
        return this.txRecoveryDelegator.getIncompletedOtsResources();
    }

    public IncompletedTx getIncompletedOtsTx(ResourceImpl rsc) {
        this.waitForRecovery();
        return this.txRecoveryDelegator.getIncompletedOtsTx(rsc);
    }

    public final void removeRecoveredReferenceInfo(ReferenceInfo ref) {
        ReferenceInfo storedRef = this.txRecoveryDelegator.removeRecoveredResourceRef(ref);
        if (storedRef != null) {
            this.logResourceDone((XACommittingTx)storedRef.getHandback());
        }
    }

    public final void addIncompletedSubTX(SubCoordinator coord) {
        this.subXidContainer.putRecoverXidMap(coord);
    }

    public final Xid[] getSubXids(TMInfo socketID) throws TMException {
        this.waitForRecovery();
        if (this.txRecoveryDelegator.failedRsrcRemains()) {
            throw new TMException("Due to failed resources, cannot recover");
        }
        return this.subXidContainer.getXids(socketID);
    }

    public final void setGlobalDecisionForSubXids(Xid xid, boolean commit) throws TMException {
        this.subXidContainer.setGlobalDecision(xid, commit);
    }

    public final void removeIncompleteSubTx(SubCoordinator coord) {
        this.subXidContainer.removeIncompleteSubTx(coord);
    }

    public void removeIncompletedTx(IncompletedTx tx) {
        if (tx == null) {
            return;
        }
        IncompletedTx removed = this.txRecoveryDelegator.removeTxFromIncompletedTxList(tx);
        if (removed == null) {
            return;
        }
        Xid externalXid = removed.getExternalXid();
        if (externalXid == null) {
            return;
        }
        this.txRecoveryDelegator.removeTxFromXidList(externalXid, tx.getResource());
    }

    public boolean completeRecoveredSubCoordinator(GTID gtid, boolean commit) throws TMException {
        return this.subXidContainer.setGlobalDecision(gtid, commit);
    }

    public void waitForRecovery() {
        this.txRecoveryDelegator.waitForRecovery();
    }

    public final void doRecover() {
        this.txRecoveryDelegator.doTxRecovery();
    }

    public final synchronized Map resyncXAResources(Map recoveredResourceMap) {
        return this.txRecoveryDelegator.resyncXAResources(recoveredResourceMap, true);
    }

    public final boolean hasIncompletedTx() {
        this.waitForRecovery();
        return this.txRecoveryDelegator.hasIncompletedTx();
    }

    public final Xid[] getIncompleteExternalXids() {
        this.waitForRecovery();
        return this.txRecoveryDelegator.getIncompletedExternalXids();
    }

    public final void forgetIncompleteTx(Xid xid) throws TMException {
        this.waitForRecovery();
        IncompletedTx tx = this.getMatchingIncompletedTx(xid);
        if (tx == null) {
            return;
        }
        boolean completionDone = this.txRecoveryDelegator.forgetChildTx(tx.getChildXids(), xid);
        if (!completionDone) {
            throw new TMException("forget() is not completed: " + completionDone + ", failedResources : " + this.txRecoveryDelegator.failedResourceSize());
        }
        this.logXaDone((XACommittingTx)tx.getHandback());
        this.removeIncompletedTx(tx);
    }

    public final void forgetIncompleteTxForSubXids(Xid xid) throws TMException {
        this.subXidContainer.forgetIncompletedTx(xid);
    }

    public final ReferenceInfo[] getRecoveredXAResourceInfo() {
        return this.txRecoveryDelegator.getRecoveredXAResourceInfo();
    }

    public final ReferenceInfo[] getCurrentXAResourceInfo() {
        return this.txRecoveryDelegator.getCurrentXAResourceInfo();
    }

    public boolean inRecovery() {
        return this.txRecoveryDelegator.inRecovery();
    }

    public final IncompletedTx[] getAllIncompletedTx() {
        this.waitForRecovery();
        return this.txRecoveryDelegator.getAllIncompletedTx();
    }

    void addToSubXidContainer(TMInfo tmInfo, Xid xid, ReferenceInfo info) {
        this.subXidContainer.putRecoverXidMap(tmInfo, xid, info);
    }

    boolean moreIncompletedSubTx() {
        return this.subXidContainer.hasIncompleteSubTx();
    }

    void replayCompletionForSubTx() {
        this.subXidContainer.sendReplayCompletion();
    }

    public SubCoordinatorXidContainer getSubXidContainer() {
        return this.subXidContainer;
    }

    public synchronized boolean isRunningTx(long tx) {
        return this.committingTxMap.get(new Long(tx)) != null;
    }

    public TxRecoveryDelegator getDelegator() {
        return this.txRecoveryDelegator;
    }

    public static void main(String[] args) {
        try {
            String logDir = args[0];
            String containerName = args[1];
            String nodeName = containerName.substring(0, containerName.lastIndexOf(95));
            logDir = logDir + File.separator + nodeName;
            File dirFile = new File(logDir);
            String[] containerLogs = dirFile.list();
            if (containerLogs == null) {
                throw new RuntimeException("Invalid log directory");
            }
            String prefix = '_' + containerName;
            String containerLog = null;
            for (int i = 0; i < containerLogs.length && !(containerLog = containerLogs[i]).startsWith(prefix); ++i) {
            }
            if (containerLog == null) {
                throw new RuntimeException("No log for the container " + containerName);
            }
            String location = containerLog.substring(containerLog.indexOf(CONTAINER_NAME_SEPARATOR) + CONTAINER_NAME_SEPARATOR.length());
            TMInfo tmServer = new TMInfo(location);
            IncompletedTx.setTMInfo(tmServer);
            TxRecoveryDelegator txRecoveryDelegator = HowlLogManager.getTxRecoveryDelegator(logDir, containerName, location);
            System.out.println("Jeus tx log for the container " + containerName + " in the log directory " + logDir);
            System.out.println();
            ReferenceInfo[] referenceInfos = txRecoveryDelegator.getRecoveredXAResourceInfo();
            System.out.println("Recovered Resource References, length : " + referenceInfos.length);
            for (int i = 0; i < referenceInfos.length; ++i) {
                ReferenceInfo referenceInfo = referenceInfos[i];
                System.out.println("\tReference[" + i + "] : " + referenceInfo.getExportName());
                XAResourceFactory ref = referenceInfo.getResourceReference();
                if (!(ref instanceof AbstractXAResourceFactory)) continue;
                System.out.println("\t\treference data : " + ((AbstractXAResourceFactory)ref).getReference());
            }
            System.out.println();
            IncompletedTx[] incompletedTxs = txRecoveryDelegator.getAllIncompletedTx();
            System.out.println("Incomplete transaction, length : " + incompletedTxs.length);
            for (int i = 0; i < incompletedTxs.length; ++i) {
                IncompletedTx incompletedTx = incompletedTxs[i];
                System.out.println("\tIncomplete tx[" + i + "] : " + incompletedTx.getGTID());
                System.out.println("\t\texternalXid from foreign TM : " + incompletedTx.getExternalXid());
                System.out.println("\t\tdecision for the tx : " + TxStatus.getState(incompletedTx.getDecision()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final class resourceAcquirer
    implements ReplayListener {
        private TxRecoveryDelegator txRecoveryDelegator;

        public resourceAcquirer(TxRecoveryDelegator txRecoveryDelegator) {
            this.txRecoveryDelegator = txRecoveryDelegator;
        }

        public final void onRecord(LogRecord lr) {
            block1 : switch (lr.type) {
                case 16512: {
                    byte[][] data = lr.getFields();
                    byte type = data[0][0];
                    switch (type) {
                        case 0: {
                            try {
                                String exportName = (String)serializer.deserialize(data[1]);
                                XAResourceFactory resourceRef = (XAResourceFactory)serializer.deserialize(data[2]);
                                if (logger.isLoggable(JeusMessage_TMRecovery0._1101_LEVEL)) {
                                    logger.logp(JeusMessage_TMRecovery0._1101_LEVEL, "HowlLogManager$resourceAcquirer", "onRecord", JeusMessage_TMRecovery0._1101, (java.lang.Object)resourceRef);
                                }
                                ReferenceInfo value = new ReferenceInfo(resourceRef, exportName, ((XALogRecord)lr).getTx(), lr.tod);
                                this.txRecoveryDelegator.addRecorveredResourceRef(value, value);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break block1;
                        }
                        case 1: {
                            int startTime = ByteUtil.convertToInt((byte[])data[1]);
                            long ltid = ByteUtil.convertToLong((byte[])data[2]);
                            IncompletedTx tx = new IncompletedTx(ltid, startTime, lr.tod, null, ((XALogRecord)lr).getTx(), null, true, 0, 2);
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1102_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1102_LEVEL, "HowlLogManager$resourceAcquirer", "onRecord", JeusMessage_TMRecovery0._1102, (java.lang.Object)new Long(ltid));
                            }
                            this.txRecoveryDelegator.addIncompletedTx(tx, tx, null, null);
                            break block1;
                        }
                        case 2: {
                            int startTime = ByteUtil.convertToInt((byte[])data[1]);
                            long ltid = ByteUtil.convertToLong((byte[])data[2]);
                            XidImpl xid = new XidImpl(data[3], data[4], ByteUtil.convertToInt((byte[])data[5]));
                            IncompletedTx tx = new IncompletedTx(ltid, startTime, lr.tod, xid, ((XALogRecord)lr).getTx(), null, true, -1, 2);
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1103_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1103_LEVEL, "HowlLogManager$resourceAcquirer", "onRecord", JeusMessage_TMRecovery0._1103, new java.lang.Object[]{new Long(ltid), XidToString.getXidString(xid)});
                            }
                            this.txRecoveryDelegator.addIncompletedTx(tx, tx, xid, null);
                            break block1;
                        }
                        case 3: {
                            int decision;
                            ResourceImpl rsc;
                            int startTime = ByteUtil.convertToInt((byte[])data[1]);
                            long ltid = ByteUtil.convertToLong((byte[])data[2]);
                            OTSXid otsXid = new OTSXid(data[3], data[4], ByteUtil.convertToInt((byte[])data[5]));
                            if (data[6].length > 0) {
                                rsc = new ResourceImpl(otsXid);
                                _RecoveryCoordinatorStub recoveryCoord = new _RecoveryCoordinatorStub();
                                this.makeCorbaObjectFromString(data[6], recoveryCoord);
                                rsc.setRecoveryCoordinator(recoveryCoord);
                                decision = -1;
                            } else {
                                rsc = null;
                                decision = 0;
                            }
                            IncompletedTx tx = new IncompletedTx(ltid, startTime, lr.tod, otsXid, ((XALogRecord)lr).getTx(), rsc, true, (byte)decision, 2);
                            if (logger.isLoggable(JeusMessage_TMRecovery0._1103_LEVEL)) {
                                logger.logp(JeusMessage_TMRecovery0._1103_LEVEL, "HowlLogManager$resourceAcquirer", "onRecord", JeusMessage_TMRecovery0._1103, new java.lang.Object[]{new Long(ltid), XidToString.getXidString(otsXid)});
                            }
                            this.txRecoveryDelegator.addIncompletedTx(tx, tx, otsXid, rsc);
                            break block1;
                        }
                    }
                    throw new RuntimeException("Unknown log data : " + data.length);
                }
            }
        }

        private void makeCorbaObjectFromString(byte[] data, _RecoveryCoordinatorStub recoveryCoord) {
            String str = new String(data);
            Object obj = jeus.transaction.ots.Configuration.getORB().string_to_object(str);
            Delegate delegate = ((ObjectImpl)obj)._get_delegate();
            recoveryCoord._set_delegate(delegate);
        }

        public final void onError(LogException exception) {
            exception.printStackTrace();
        }

        public final LogRecord getLogRecord() {
            return new XALogRecord(120);
        }
    }
}

