/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.logging;

import java.io.Serializable;
import java.util.ArrayList;
import javax.transaction.xa.Xid;
import jeus.management.j2ee.transaction.ReferenceInfo;
import jeus.transaction.GTID;
import jeus.transaction.TMInfo;
import jeus.transaction.XidImpl;
import jeus.transaction.logging.XidInfo;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.util.XidToString;

public final class IncompletedTx
implements Serializable {
    private final long ltid;
    private final int time;
    private Xid externalXid;
    private byte decision;
    private long createTime;
    private transient Object handback;
    private final ArrayList childXids = new ArrayList();
    private boolean isRecovered;
    private final GTID gtid;
    private ResourceImpl otsResource;
    private int lastStatus;
    private static TMInfo TM_INFO;

    public IncompletedTx() {
        this(0L, 0, 0L, null, null, null, false, -1, 2);
    }

    public IncompletedTx(long ltid, int time) {
        this(ltid, time, 0L, null, null, null, false, -1, 5);
    }

    public IncompletedTx(long ltid, int time, long createTime, Xid xid, Object handback, ResourceImpl rsc, boolean isRecovered, byte decision, int lastStatus) {
        this.ltid = ltid;
        this.time = time;
        this.createTime = createTime;
        if (xid != null) {
            this.externalXid = new XidImpl(xid);
        }
        this.gtid = new GTID(TM_INFO, ltid, this.externalXid, time);
        this.handback = handback;
        this.otsResource = rsc;
        this.isRecovered = isRecovered;
        this.decision = decision;
        this.lastStatus = lastStatus;
    }

    public GTID getGTID() {
        return this.gtid;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IncompletedTx) {
            IncompletedTx tx = (IncompletedTx)obj;
            return tx.ltid == this.ltid && tx.time == this.time;
        }
        if (obj instanceof Long) {
            return this.ltid == (Long)obj;
        }
        if (obj instanceof Xid) {
            return this.externalXid != null && IncompletedTx.isTheSameXid(this.externalXid, (Xid)obj);
        }
        return false;
    }

    private static boolean isTheSameXid(Xid externalXid, Xid xid) {
        return IncompletedTx.isTheSameByteArray(externalXid.getGlobalTransactionId(), xid.getGlobalTransactionId()) && IncompletedTx.isTheSameByteArray(externalXid.getBranchQualifier(), xid.getBranchQualifier()) && externalXid.getFormatId() == xid.getFormatId();
    }

    private static boolean isTheSameByteArray(byte[] gtid, byte[] targetGtid) {
        if (gtid.length != targetGtid.length) {
            return false;
        }
        for (int i = 0; i < targetGtid.length; ++i) {
            if (gtid[i] == targetGtid[i]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        return (int)this.ltid;
    }

    public final Xid getExternalXid() {
        return this.externalXid;
    }

    public final void setGlobalDecision(byte decision) {
        this.decision = decision;
    }

    public final byte getDecision() {
        return this.decision;
    }

    public int getLastStatus() {
        return this.lastStatus;
    }

    public final String toString() {
        if (this.externalXid == null) {
            return String.valueOf(this.ltid) + ":" + this.time + ":" + this.createTime;
        }
        return String.valueOf(this.ltid) + ":" + XidToString.getXidString(this.externalXid) + ":" + this.time + ":" + this.createTime;
    }

    public final long getLTID() {
        return this.ltid;
    }

    public final Object getHandback() {
        return this.handback;
    }

    public final boolean isSameLTID(GTID gtid) {
        return this.ltid == gtid.getLTID() && this.time == gtid.getTime();
    }

    public final void addChildXid(Xid xid, ReferenceInfo info) {
        this.childXids.add(new XidInfo(xid, info));
    }

    public final int getTime() {
        return this.time;
    }

    public final ArrayList getChildXids() {
        return this.childXids;
    }

    public final boolean isRecovered() {
        return this.isRecovered;
    }

    public void setHandback(Object handback) {
        this.handback = handback;
    }

    public static void setTMInfo(TMInfo tmServer) {
        TM_INFO = tmServer;
    }

    public ResourceImpl getResource() {
        return this.otsResource;
    }
}

