/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.ots.impl;

import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxStatus;
import jeus.transaction.ots.Configuration;
import jeus.util.ByteUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_OTS0;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.RecoveryCoordinatorPOA;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class RecoveryCoordinatorImpl
extends RecoveryCoordinatorPOA {
    private int seqNum;
    private GTID gtid;
    private RecoveryCoordinator thisRef;
    private POA poa;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction.ots");
    private boolean incarnated;

    public RecoveryCoordinatorImpl(byte[] oid) {
        byte[] gtidBytes = new byte[oid.length - 4];
        System.arraycopy(oid, 0, gtidBytes, 0, gtidBytes.length);
        this.gtid = new GTID(gtidBytes);
        this.gtid.setLocal();
        this.seqNum = ByteUtil.convertToInt((byte[])oid, (int)(oid.length - 4));
        this.incarnated = true;
    }

    public RecoveryCoordinatorImpl(GTID gtid, int seqNum) {
        this.gtid = gtid;
        this.seqNum = seqNum;
    }

    public RecoveryCoordinatorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status replay_completion(final Resource r) throws NotPrepared {
        try {
            if (logger.isLoggable(JeusMessage_OTS0._1201_LEVEL)) {
                logger.logp(JeusMessage_OTS0._1201_LEVEL, "RecoveryCoordinatorImpl", "replay_completion", JeusMessage_OTS0._1201, new java.lang.Object[]{this.gtid, r});
            }
            Status result = Status.StatusRolledBack;
            Coordinator coord = ThreadContexts.getCoordinator(this.gtid);
            if (coord != null) {
                int status = coord.getStatus();
                if (logger.isLoggable(JeusMessage_OTS0._1202_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1202_LEVEL, "RecoveryCoordinatorImpl", "replay_completion", JeusMessage_OTS0._1202, new java.lang.Object[]{this.gtid, TxStatus.getState(status)});
                }
                switch (status) {
                    case 0: 
                    case 1: {
                        try {
                            coord.setRollbackOnly();
                        }
                        catch (Throwable exc) {
                            // empty catch block
                        }
                        throw new NotPrepared();
                    }
                    case 2: {
                        result = Status.StatusUnknown;
                        break;
                    }
                    case 8: {
                        result = Status.StatusUnknown;
                        break;
                    }
                    case 3: {
                        result = Status.StatusCommitted;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        result = Status.StatusRolledBack;
                        break;
                    }
                }
            } else {
                byte decision = TMServer.getDecisionForUncompletedTx(this.gtid.getLTID(), this.gtid.getTime());
                if (logger.isLoggable(JeusMessage_OTS0._1203_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1203_LEVEL, "RecoveryCoordinatorImpl", "replay_completion", JeusMessage_OTS0._1203, new java.lang.Object[]{this.gtid, decision == 0 ? "COMMIT" : (decision == 1 ? "ROLLBACK" : "Unknown : " + decision)});
                }
                switch (decision) {
                    case 0: {
                        result = Status.StatusCommitted;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        result = Status.StatusUnknown;
                    }
                }
            }
            final Status finalStatus = result;
            Thread t = new Thread(new Runnable(){

                public void run() {
                    switch (finalStatus.value()) {
                        case 3: {
                            if (logger.isLoggable(JeusMessage_OTS0._1206_LEVEL)) {
                                logger.logp(JeusMessage_OTS0._1206_LEVEL, "RecoveryCoordinatorImpl", "replay_completion", JeusMessage_OTS0._1206, new java.lang.Object[]{"commit", RecoveryCoordinatorImpl.this.gtid});
                            }
                            try {
                                r.commit();
                                if (!logger.isLoggable(JeusMessage_OTS0._1207_LEVEL)) break;
                                logger.logp(JeusMessage_OTS0._1207_LEVEL, "RecoveryCoordinatorImpl", "replay_completion", JeusMessage_OTS0._1207, (java.lang.Object)"commit");
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            break;
                        }
                        case 4: {
                            if (logger.isLoggable(JeusMessage_OTS0._1206_LEVEL)) {
                                logger.logp(JeusMessage_OTS0._1206_LEVEL, "RecoveryCoordinatorImpl", "replay_completion", JeusMessage_OTS0._1206, new java.lang.Object[]{"rollback", RecoveryCoordinatorImpl.this.gtid});
                            }
                            try {
                                r.rollback();
                                if (!logger.isLoggable(JeusMessage_OTS0._1207_LEVEL)) break;
                                logger.logp(JeusMessage_OTS0._1207_LEVEL, "RecoveryCoordinatorImpl", "replay_completion", JeusMessage_OTS0._1207, (java.lang.Object)"rollback");
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            break;
                        }
                        default: {
                            if (!logger.isLoggable(JeusMessage_OTS0._1208_LEVEL)) break;
                            logger.logp(JeusMessage_OTS0._1208_LEVEL, "RecoveryCoordinatorImpl", "replay_completion", JeusMessage_OTS0._1208, (java.lang.Object)new Integer(finalStatus.value()));
                        }
                    }
                }
            });
            t.start();
            Status status = result;
            return status;
        }
        finally {
            if (this.incarnated) {
                this.destroy();
            }
        }
    }

    public final synchronized RecoveryCoordinator object() {
        if (this.thisRef == null) {
            if (this.poa == null) {
                this.poa = Configuration.getPOA("OTSrecoveryPOA");
            }
            try {
                if (this.gtid != null) {
                    byte[] tidBytes = this.gtid.toBytes();
                    byte[] idBytes = new byte[tidBytes.length + 4];
                    System.arraycopy(tidBytes, 0, idBytes, 0, tidBytes.length);
                    ByteUtil.putInt((byte[])idBytes, (int)tidBytes.length, (int)this.seqNum);
                    this.poa.activate_object_with_id(idBytes, (Servant)this);
                    Object obj = this.poa.create_reference_with_id(idBytes, RecoveryCoordinatorHelper.id());
                    this.thisRef = RecoveryCoordinatorHelper.narrow(obj);
                } else {
                    this.poa.activate_object((Servant)this);
                    Object obj = this.poa.servant_to_reference((Servant)this);
                    this.thisRef = RecoveryCoordinatorHelper.narrow(obj);
                }
            }
            catch (Exception exc) {
                if (logger.isLoggable(JeusMessage_OTS0._1204_LEVEL)) {
                    logger.logp(JeusMessage_OTS0._1204_LEVEL, "RecoveryCoordinatorImpl", "object", JeusMessage_OTS0._1204);
                }
                throw new INTERNAL("jts.create_recoverycoordinator_error");
            }
        }
        return this.thisRef;
    }

    final synchronized void destroy() {
        block6: {
            try {
                if (this.poa != null && this.thisRef != null) {
                    this.poa.deactivate_object(this.poa.reference_to_id((Object)this.thisRef));
                    this.thisRef = null;
                } else {
                    POA rcPoa = this.poa == null ? Configuration.getPOA("OTSrecoveryPOA") : this.poa;
                    if (this.thisRef == null) {
                        rcPoa.deactivate_object(rcPoa.servant_to_id((Servant)this));
                    } else {
                        rcPoa.deactivate_object(rcPoa.reference_to_id((Object)this.thisRef));
                        this.thisRef = null;
                    }
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(JeusMessage_OTS0._1205_LEVEL)) break block6;
                logger.logp(JeusMessage_OTS0._1205_LEVEL, "RecoveryCoordinatorImpl", "destroy", JeusMessage_OTS0._1205, (Throwable)exc);
            }
        }
    }
}

