/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.root;

import java.util.Vector;
import javax.transaction.xa.Xid;
import jeus.transaction.Coordinator;
import jeus.transaction.GTID;
import jeus.transaction.JTAStatisticsProvider;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TxStatus;
import jeus.transaction.collector.BeforeCompletionResponseCollector;
import jeus.transaction.collector.CommitResponseCollector;
import jeus.transaction.collector.FlushResponseCollector;
import jeus.transaction.collector.LocalXACommitResponseCollector;
import jeus.transaction.collector.PrepareResponseCollector;
import jeus.transaction.logging.LogManager;
import jeus.transaction.ots.OtsDecisionWaitingTimer;
import jeus.transaction.ots.impl.CoordinatorImpl;
import jeus.transaction.ots.impl.ResourceImpl;
import jeus.transaction.ots.jta.JTAResource;
import jeus.transaction.resources.LocalResource;
import jeus.transaction.root.CoordinatorResource;
import jeus.util.message.JeusMessage_TM1;
import org.omg.CosTransactions.Resource;

public final class RootCoordinator
extends Coordinator {
    private final long commitTO = TMConfig.commitTO;
    private final long ltid;
    private Vector coordResources = new Vector(5);
    private final BeforeCompletionResponseCollector bCollector = new BeforeCompletionResponseCollector();
    private final PrepareResponseCollector pCollector = new PrepareResponseCollector();
    private final LocalXACommitResponseCollector localXACollector = new LocalXACommitResponseCollector();
    private final CommitResponseCollector cCollector = new CommitResponseCollector();
    private final FlushResponseCollector fCollector = new FlushResponseCollector();
    private Xid externalXid;
    private Vector remotePrepared;
    private byte globalDecision = (byte)-1;
    private final CoordinatorImpl coorImpl;
    private boolean doesLogCommit;
    private final LogManager logManager;
    private ResourceImpl otsResource;
    private OtsDecisionWaitingTimer otsDecisionTimer;

    public RootCoordinator(GTID gtid, LogManager logManager, long timeout) {
        super(gtid, timeout);
        if (logger.isLoggable(JeusMessage_TM1._3601_LEVEL)) {
            logger.logp(JeusMessage_TM1._3601_LEVEL, "Coordinator", "<init>", JeusMessage_TM1._3601, new Object[]{"root", gtid, String.valueOf(timeout)});
        }
        this.ltid = gtid.getLTID();
        this.externalXid = gtid.getExternalXid();
        this.logManager = logManager;
        this.coorImpl = new CoordinatorImpl(gtid, timeout, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerSubCoordinatorResource(CoordinatorResource resource, boolean needAck) {
        if (logger.isLoggable(JeusMessage_TM1._3607_LEVEL)) {
            logger.logp(JeusMessage_TM1._3607_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3607, new Object[]{resource, this.gtid});
        }
        Object object = this.statusSync;
        synchronized (object) {
            if (this.isNotRunningTransaction() && !this.isInBeforeCompletion) {
                if (logger.isLoggable(JeusMessage_TM1._3608_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3608_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3608, new Object[]{this.gtid, TxStatus.getState(this.status)});
                }
                return false;
            }
            this.coordResources.add(resource);
        }
        if (logger.isLoggable(JeusMessage_TM1._3611_LEVEL)) {
            logger.logp(JeusMessage_TM1._3611_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3611, new Object[]{resource, this.gtid});
        }
        return true;
    }

    protected void preBeforeCompletion() {
        int len_remoteResources;
        if (logger.isLoggable(JeusMessage_TM1._3634_LEVEL)) {
            logger.logp(JeusMessage_TM1._3634_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3634, (Object)this.gtid);
        }
        if ((len_remoteResources = this.coordResources.size()) == 0) {
            return;
        }
        this.bCollector.setTotalNum(len_remoteResources);
        for (int i = 0; i < len_remoteResources; ++i) {
            CoordinatorResource rsc = (CoordinatorResource)this.coordResources.elementAt(i);
            try {
                if (logger.isLoggable(JeusMessage_TM1._3635_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3635_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3635, new Object[]{rsc, this.gtid});
                }
                rsc.beforeCompletion(this.ltid);
                continue;
            }
            catch (TMException ex) {
                if (logger.isLoggable(JeusMessage_TM1._3636_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3636_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3636, new Object[]{rsc, this.gtid}, (Throwable)((Object)ex));
                }
                this.bCollector.reduceTotal(1);
                this.setRollbackOnly();
            }
        }
    }

    protected void postBeforeCompletion() {
        int len_remoteResources = this.coordResources.size();
        if (len_remoteResources == 0) {
            return;
        }
        try {
            boolean rollback;
            if (logger.isLoggable(JeusMessage_TM1._3641_LEVEL)) {
                logger.logp(JeusMessage_TM1._3641_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3641, new Object[]{String.valueOf(this.prepareTO), this.gtid});
            }
            if (rollback = this.bCollector.waiting(this.prepareTO)) {
                if (logger.isLoggable(JeusMessage_TM1._3642_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3642_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3642, (Object)this.gtid);
                }
                this.setRollbackOnly();
            }
        }
        catch (TMException ex) {
            if (logger.isLoggable(JeusMessage_TM1._3643_LEVEL)) {
                logger.logp(JeusMessage_TM1._3643_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3643, (Object)this.gtid, (Throwable)((Object)ex));
            }
            JTAStatisticsProvider.incrementPrepareTimeOutCount();
            this.handleCommonTimeOut();
            this.setRollbackOnly();
        }
    }

    protected boolean prePrepare() {
        if (logger.isLoggable(JeusMessage_TM1._3646_LEVEL)) {
            logger.logp(JeusMessage_TM1._3646_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3646, (Object)this.gtid);
        }
        boolean rollback = false;
        int len_remoteResources = this.coordResources.size();
        this.pCollector.setTotalNum(len_remoteResources);
        if (len_remoteResources == 0) {
            return rollback;
        }
        for (int i = 0; i < len_remoteResources; ++i) {
            CoordinatorResource rsc = (CoordinatorResource)this.coordResources.elementAt(i);
            try {
                if (logger.isLoggable(JeusMessage_TM1._3647_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3647_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3647, new Object[]{rsc, this.gtid});
                }
                rsc.prepare(this.ltid);
                continue;
            }
            catch (TMException ex) {
                if (logger.isLoggable(JeusMessage_TM1._3648_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3648_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3648, new Object[]{rsc, this.gtid}, (Throwable)((Object)ex));
                }
                this.pCollector.reduceTotal(1);
                rollback = true;
            }
        }
        return rollback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean postPrepare(boolean rollback) {
        try {
            boolean bl;
            int len_remoteResources;
            if (logger.isLoggable(JeusMessage_TM1._3656_LEVEL)) {
                logger.logp(JeusMessage_TM1._3656_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3656, new Object[]{String.valueOf(this.prepareTO), this.gtid});
            }
            if ((len_remoteResources = this.coordResources.size()) != 0) {
                try {
                    boolean isSubCoordinatorNotPrepared = !this.pCollector.waiting(this.prepareTO);
                    boolean bl2 = rollback = isSubCoordinatorNotPrepared || rollback;
                    if (isSubCoordinatorNotPrepared && logger.isLoggable(JeusMessage_TM1._3657_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3657_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3657, (Object)this.gtid);
                    }
                }
                catch (TMException ex) {
                    if (logger.isLoggable(JeusMessage_TM1._3658_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3658_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3658, (Object)this.gtid, (Throwable)((Object)ex));
                    }
                    JTAStatisticsProvider.incrementPrepareTimeOutCount();
                    this.handleCommonTimeOut();
                    rollback = true;
                }
                this.remotePrepared = this.pCollector.getPreparedList(this.ltid);
            } else {
                this.remotePrepared = new Vector();
            }
            if (!rollback) {
                bl = this.handleLocalResourceOptimization();
                return bl;
            }
            bl = rollback;
            return bl;
        }
        finally {
            this.isPrepareCalled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleLocalResourceOptimization() {
        boolean rollback;
        block26: {
            block27: {
                block30: {
                    CoordinatorResource crsc;
                    block25: {
                        Vector localXArscs;
                        block29: {
                            block28: {
                                rollback = false;
                                if (logger.isLoggable(JeusMessage_TM1._3659_LEVEL)) {
                                    logger.logp(JeusMessage_TM1._3659_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3659, (Object)this.gtid);
                                }
                                if ((localXArscs = this.pCollector.getLocalXAList()).size() <= 0 && this.localXAResource == null) break block26;
                                if (localXArscs.size() <= 1 && (localXArscs.size() != 1 || this.localXAResource == null)) break block28;
                                if (logger.isLoggable(JeusMessage_TM1._3660_LEVEL)) {
                                    logger.logp(JeusMessage_TM1._3660_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3660, new Object[]{this.gtid, this.localXAResource != null ? new Integer(1) : new Integer(0), new Integer(localXArscs.size())});
                                }
                                rollback = true;
                                break block26;
                            }
                            if (this.externalXid == null) break block29;
                            if (logger.isLoggable(JeusMessage_TM1._3793_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3793_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3793, (Object)this.gtid);
                            }
                            rollback = true;
                            break block26;
                        }
                        if (localXArscs.size() != 1) break block30;
                        crsc = null;
                        if (logger.isLoggable(JeusMessage_TM1._3661_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3661_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3661, (Object)this.gtid);
                        }
                        try {
                            crsc = this.getCoordinatorResource((TMInfo)localXArscs.elementAt(0));
                            if (logger.isLoggable(JeusMessage_TM1._3662_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3662_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3662, new Object[]{crsc, this.gtid});
                            }
                            crsc.commitLocalXAResource(this.ltid);
                            if (this.localXACollector.waiting(this.prepareTO) == 0) break block25;
                            if (logger.isLoggable(JeusMessage_TM1._3663_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3663_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3663, new Object[]{crsc, this.gtid});
                            }
                            rollback = true;
                        }
                        catch (Throwable t) {
                            try {
                                if (logger.isLoggable(JeusMessage_TM1._3664_LEVEL)) {
                                    logger.logp(JeusMessage_TM1._3664_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3664, new Object[]{crsc, this.gtid}, t);
                                }
                                JTAStatisticsProvider.incrementPrepareTimeOutCount();
                                this.handleCommonTimeOut();
                                rollback = true;
                            }
                            catch (Throwable throwable) {
                                if (logger.isLoggable(JeusMessage_TM1._3665_LEVEL)) {
                                    logger.logp(JeusMessage_TM1._3665_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3665, new Object[]{this.gtid, TxStatus.getState(rollback ? (byte)1 : 0), crsc});
                                }
                                throw throwable;
                            }
                            if (logger.isLoggable(JeusMessage_TM1._3665_LEVEL)) {
                                logger.logp(JeusMessage_TM1._3665_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3665, new Object[]{this.gtid, TxStatus.getState(rollback ? (byte)1 : 0), crsc});
                            }
                            break block26;
                        }
                    }
                    if (logger.isLoggable(JeusMessage_TM1._3665_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3665_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3665, new Object[]{this.gtid, TxStatus.getState(rollback ? (byte)1 : 0), crsc});
                    }
                    break block26;
                }
                if (logger.isLoggable(JeusMessage_TM1._3666_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3666_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3666, (Object)this.gtid);
                }
                try {
                    if (logger.isLoggable(JeusMessage_TM1._3667_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3667_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3667, new Object[]{this.localXAResource, this.gtid});
                    }
                    if (this.localXAResource.onePhaseCommit() == 0) break block27;
                    if (logger.isLoggable(JeusMessage_TM1._3668_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3668_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3668, new Object[]{this.localXAResource, this.gtid});
                    }
                    rollback = true;
                }
                catch (Throwable ex) {
                    try {
                        if (logger.isLoggable(JeusMessage_TM1._3669_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3669_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3669, new Object[]{this.localXAResource, this.gtid}, ex);
                        }
                        rollback = true;
                    }
                    catch (Throwable throwable) {
                        if (logger.isLoggable(JeusMessage_TM1._3670_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3670_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3670, new Object[]{this.localXAResource, this.gtid, TxStatus.getState(rollback ? (byte)1 : 0)});
                        }
                        this.localXAResource = null;
                        throw throwable;
                    }
                    if (logger.isLoggable(JeusMessage_TM1._3670_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3670_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3670, new Object[]{this.localXAResource, this.gtid, TxStatus.getState(rollback ? (byte)1 : 0)});
                    }
                    this.localXAResource = null;
                }
            }
            if (logger.isLoggable(JeusMessage_TM1._3670_LEVEL)) {
                logger.logp(JeusMessage_TM1._3670_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3670, new Object[]{this.localXAResource, this.gtid, TxStatus.getState(rollback ? (byte)1 : 0)});
            }
            this.localXAResource = null;
        }
        return rollback;
    }

    protected byte preCommit(byte response) throws TMException {
        int len_remotePrepared;
        if (logger.isLoggable(JeusMessage_TM1._3697_LEVEL)) {
            logger.logp(JeusMessage_TM1._3697_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3697, (Object)this.gtid);
        }
        if (this.otsDecisionTimer != null) {
            this.otsDecisionTimer.cancelOtsDecisionWaitingTimer();
        }
        if ((len_remotePrepared = this.remotePrepared.size()) == 0) {
            return response;
        }
        this.cCollector.setTotalNum(len_remotePrepared);
        for (int i = 0; i < len_remotePrepared; ++i) {
            CoordinatorResource rsc = this.getCoordinatorResource((TMInfo)this.remotePrepared.elementAt(i));
            try {
                if (logger.isLoggable(JeusMessage_TM1._3698_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3698_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3698, new Object[]{rsc, this.gtid});
                }
                rsc.commit(this.ltid);
                continue;
            }
            catch (TMException ex) {
                if (logger.isLoggable(JeusMessage_TM1._3699_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3699_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3699, new Object[]{rsc, this.gtid}, (Throwable)((Object)ex));
                }
                response = (byte)4;
                this.cCollector.reduceTotal(1);
            }
        }
        return response;
    }

    protected byte postCommit(byte response) {
        block14: {
            int len_remotePrepared = this.remotePrepared.size();
            if (len_remotePrepared > 0) {
                if (logger.isLoggable(JeusMessage_TM1._3704_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3704_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3704, new Object[]{String.valueOf(this.commitTO), this.gtid});
                }
                try {
                    boolean result = this.cCollector.waiting(this.commitTO);
                    if (response == 3 && !result) {
                        if (logger.isLoggable(JeusMessage_TM1._3705_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3705_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3705, (Object)this.gtid);
                        }
                        response = (byte)4;
                    }
                }
                catch (TMException ex) {
                    if (logger.isLoggable(JeusMessage_TM1._3706_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3706_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3706, (Object)this.gtid, (Throwable)((Object)ex));
                    }
                    JTAStatisticsProvider.incrementCommitTimeOutCount();
                    JTAStatisticsProvider.incrementTimeOutCount();
                    response = (byte)4;
                }
            }
            if (logger.isLoggable(JeusMessage_TM1._3707_LEVEL)) {
                logger.logp(JeusMessage_TM1._3707_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3707, (Object)this.gtid);
            }
            if (response != 4) {
                if (logger.isLoggable(JeusMessage_TM1._3708_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3708_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3708, (Object)this.gtid);
                }
                this.setDone();
            } else {
                if (logger.isLoggable(JeusMessage_TM1._3709_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3709_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3709, (Object)this.gtid);
                }
                try {
                    this.logManager.addIncompletedTX(this.ltid, TMServer.getTMInfo() != null ? TMServer.getTMInfo().getTime() : 0, System.currentTimeMillis(), this.externalXid, this.otsResource);
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_TM1._3756_LEVEL)) break block14;
                    logger.logp(JeusMessage_TM1._3756_LEVEL, "Coordinator", "setGlobalDecision", JeusMessage_TM1._3756, ex);
                }
            }
        }
        return response;
    }

    private void setDone() {
        block3: {
            try {
                if (logger.isLoggable(JeusMessage_TM1._3754_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3754_LEVEL, "Coordinator", "setGlobalDecision", JeusMessage_TM1._3754, (Object)this.gtid);
                }
                this.logManager.logDone(this.ltid);
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_TM1._3756_LEVEL)) break block3;
                logger.logp(JeusMessage_TM1._3756_LEVEL, "Coordinator", "setGlobalDecision", JeusMessage_TM1._3756, ex);
            }
        }
        this.globalDecision = (byte)3;
    }

    protected byte preRollback() throws TMException {
        if (this.otsDecisionTimer != null) {
            this.otsDecisionTimer.cancelOtsDecisionWaitingTimer();
        }
        int response = 1;
        if (this.externalXid != null && this.doesLogCommit) {
            this.setDone();
        }
        if (logger.isLoggable(JeusMessage_TM1._3716_LEVEL)) {
            logger.logp(JeusMessage_TM1._3716_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3716, new Object[]{this.isPrepareCalled ? "requiring" : "all", this.gtid});
        }
        int len_remotePrepared = this.isPrepareCalled ? this.remotePrepared.size() : this.coordResources.size();
        for (int i = 0; i < len_remotePrepared; ++i) {
            CoordinatorResource rsc = this.isPrepareCalled ? this.getCoordinatorResource((TMInfo)this.remotePrepared.elementAt(i)) : (CoordinatorResource)this.coordResources.elementAt(i);
            if (logger.isLoggable(JeusMessage_TM1._3717_LEVEL)) {
                logger.logp(JeusMessage_TM1._3717_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3717, new Object[]{rsc, this.gtid});
            }
            try {
                rsc.rollback(this.ltid);
                continue;
            }
            catch (TMException ex) {
                if (logger.isLoggable(JeusMessage_TM1._3718_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3718_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3718, new Object[]{rsc, this.gtid}, (Throwable)((Object)ex));
                }
                response = 4;
            }
        }
        return (byte)response;
    }

    private CoordinatorResource getCoordinatorResource(TMInfo tmInfo) throws TMException {
        for (int i = 0; i < this.coordResources.size(); ++i) {
            CoordinatorResource coordinatorResource = (CoordinatorResource)this.coordResources.get(i);
            if (!coordinatorResource.getTMServer().equals(tmInfo)) continue;
            return coordinatorResource;
        }
        throw new TMException("the coordinator resource does not exist : " + tmInfo);
    }

    protected void innerDestroy() {
        ThreadContexts.removeCoordinator(this.ltid);
        TMServer.disconnectContext();
        this.coordResources = null;
        this.remotePrepared = null;
        this.coorImpl.destroy();
    }

    protected void innerFlush() throws TMException {
        boolean result;
        int len_remoteResources;
        if (logger.isLoggable(JeusMessage_TM1._3774_LEVEL)) {
            logger.logp(JeusMessage_TM1._3774_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3774, (Object)this.gtid);
        }
        if ((len_remoteResources = this.coordResources.size()) == 0) {
            return;
        }
        this.fCollector.setTotalNum(len_remoteResources);
        for (int i = 0; i < len_remoteResources; ++i) {
            CoordinatorResource rsc = (CoordinatorResource)this.coordResources.elementAt(i);
            if (logger.isLoggable(JeusMessage_TM1._3775_LEVEL)) {
                logger.logp(JeusMessage_TM1._3775_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3775, new Object[]{rsc, this.gtid});
            }
            try {
                rsc.flush(this.ltid);
                continue;
            }
            catch (TMException ex) {
                if (logger.isLoggable(JeusMessage_TM1._3776_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3776_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3776, new Object[]{rsc, this.gtid}, (Throwable)((Object)ex));
                }
                throw ex;
            }
        }
        this.flush_subcoordinator();
        try {
            if (logger.isLoggable(JeusMessage_TM1._3777_LEVEL)) {
                logger.logp(JeusMessage_TM1._3777_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3777, new Object[]{String.valueOf(this.prepareTO), this.gtid});
            }
            result = this.fCollector.waiting(this.prepareTO);
        }
        catch (TMException ex) {
            throw new TMException(JeusMessage_TM1._3778, this.gtid.toString(), (Throwable)((Object)ex));
        }
        if (result) {
            throw new TMException(JeusMessage_TM1._3779, this.gtid.toString());
        }
    }

    protected boolean isNoResource() {
        return this.remotePrepared.size() == 0 && super.isNoResource();
    }

    protected byte setReadOnlyStatus() {
        return 2;
    }

    protected byte setCommitStatus() {
        if (logger.isLoggable(JeusMessage_TM1._3674_LEVEL)) {
            logger.logp(JeusMessage_TM1._3674_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3674, new Object[]{"root", this.gtid});
        }
        return 0;
    }

    public void prepareResponse(TMInfo subCoord, byte response) {
        if (logger.isLoggable(JeusMessage_TM1._3679_LEVEL)) {
            logger.logp(JeusMessage_TM1._3679_LEVEL, "Coordinator", "prepareResponse", JeusMessage_TM1._3679, new Object[]{subCoord, TxStatus.getState(response)});
        }
        this.pCollector.received(subCoord, response);
    }

    public void setExternalXid(Xid xid) {
        if (logger.isLoggable(JeusMessage_TM1._3790_LEVEL)) {
            logger.logp(JeusMessage_TM1._3790_LEVEL, "Coordinator", "setExternalXid", JeusMessage_TM1._3790, new Object[]{this.gtid, xid});
        }
        this.externalXid = xid;
    }

    public byte replayCompletion() {
        if (logger.isLoggable(JeusMessage_TM1._3695_LEVEL)) {
            logger.logp(JeusMessage_TM1._3695_LEVEL, "Coordinator", "replayCompletion", JeusMessage_TM1._3695, new Object[]{this.gtid, TxStatus.getState(this.globalDecision)});
        }
        return this.globalDecision;
    }

    public void commitResponse(boolean done) {
        if (logger.isLoggable(JeusMessage_TM1._3713_LEVEL)) {
            logger.logp(JeusMessage_TM1._3713_LEVEL, "Coordinator", "commitResponse", JeusMessage_TM1._3713, new Object[]{done ? "done" : "fail", this.gtid});
        }
        this.cCollector.received(done);
    }

    public void beforeCompletionResponse(byte done) {
        if (logger.isLoggable(JeusMessage_TM1._3714_LEVEL)) {
            logger.logp(JeusMessage_TM1._3714_LEVEL, "Coordinator", "beforeCompletionResponse", JeusMessage_TM1._3714, new Object[]{TxStatus.getState(done), this.gtid});
        }
        this.bCollector.received(done);
    }

    public void commitLocalXAResourceResponse(boolean commit) {
        if (logger.isLoggable(JeusMessage_TM1._3746_LEVEL)) {
            logger.logp(JeusMessage_TM1._3746_LEVEL, "Coordinator", "commitLocalXAResourceResponse", JeusMessage_TM1._3746, new Object[]{commit ? "commit" : "rollback", this.gtid});
        }
        this.localXACollector.received(commit);
    }

    public int getNumResources() {
        if (this.coordResources.size() != 0) {
            if (logger.isLoggable(JeusMessage_TM1._3747_LEVEL)) {
                logger.logp(JeusMessage_TM1._3747_LEVEL, "Coordinator", "getNumResources", JeusMessage_TM1._3747, (Object)this.gtid);
            }
            return 2;
        }
        int size = this.localResources.size();
        if (logger.isLoggable(JeusMessage_TM1._3748_LEVEL)) {
            logger.logp(JeusMessage_TM1._3748_LEVEL, "Coordinator", "getNumResources", JeusMessage_TM1._3748, new Object[]{String.valueOf(size), this.gtid});
        }
        return size;
    }

    public long getLTID() {
        if (logger.isLoggable(JeusMessage_TM1._3762_LEVEL)) {
            logger.logp(JeusMessage_TM1._3762_LEVEL, "Coordinator", "getLTID", JeusMessage_TM1._3762, new Object[]{String.valueOf(this.ltid), this.gtid});
        }
        return this.ltid;
    }

    public void flushResponse(byte b) {
        if (logger.isLoggable(JeusMessage_TM1._3788_LEVEL)) {
            logger.logp(JeusMessage_TM1._3788_LEVEL, "Coordinator", "flushResponse", JeusMessage_TM1._3788, (Object)TxStatus.getState(b));
        }
        this.fCollector.received(b);
    }

    public Xid getExternalXid() {
        if (logger.isLoggable(JeusMessage_TM1._3791_LEVEL)) {
            logger.logp(JeusMessage_TM1._3791_LEVEL, "Coordinator", "getExternalXid", JeusMessage_TM1._3791, (Object)this.externalXid);
        }
        return this.externalXid;
    }

    public org.omg.CosTransactions.Coordinator getOTSCoordinator() {
        return this.coorImpl.object();
    }

    public byte getGlobalDecision() {
        if (logger.isLoggable(JeusMessage_TM1._3757_LEVEL)) {
            logger.logp(JeusMessage_TM1._3757_LEVEL, "Coordinator", "getGlobalDecision", JeusMessage_TM1._3757, new Object[]{this.gtid, TxStatus.getState(this.globalDecision)});
        }
        return this.globalDecision;
    }

    public void setGlobalDecision(byte decision) throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3749_LEVEL)) {
            logger.logp(JeusMessage_TM1._3749_LEVEL, "Coordinator", "setGlobalDecision", JeusMessage_TM1._3749, new Object[]{"global ", this.gtid, TxStatus.getState(decision)});
        }
        this.globalDecision = decision;
        if (decision == 0) {
            try {
                if (logger.isLoggable(JeusMessage_TM1._3750_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3750_LEVEL, "Coordinator", "setGlobalDecision", JeusMessage_TM1._3750, (Object)this.gtid);
                }
                this.logManager.logCommit(this.ltid, this.externalXid, this.otsResource);
                this.doesLogCommit = true;
            }
            catch (Throwable ex) {
                throw new TMException(JeusMessage_TM1._3752, ex);
            }
        }
        if (this.otsResource != null) {
            this.otsDecisionTimer = new OtsDecisionWaitingTimer();
            this.otsDecisionTimer.startOtsDecisionWaitingTimer(this.otsResource);
        }
    }

    public void setOTSResource(ResourceImpl rsc) {
        this.otsResource = rsc;
    }

    public ResourceImpl getOTSResource() {
        return this.otsResource;
    }

    public final void registerResource(Resource rs) {
        this.registerResource(new LocalResource(new JTAResource(rs), this.createXID(), false));
    }
}

