/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.util;

import java.util.StringTokenizer;
import javax.transaction.xa.Xid;
import jeus.transaction.XidImpl;
import jeus.util.logging.Utility;

public class XidToString {
    private static final int TMAX_SINGLE_GTID_LENGTH = 4;
    private static final String ZERO = "0";

    public static String getGtidStringFromXid(Xid xid) {
        if (xid == null) {
            return "";
        }
        return Utility.getDump((byte[])xid.getGlobalTransactionId());
    }

    public static String getXidString(Xid xid) {
        if (xid == null) {
            return "";
        }
        if (xid.getGlobalTransactionId().length == 8) {
            return XidToString.getTmaxXidString(xid);
        }
        String gtidString = Utility.getDump((byte[])xid.getGlobalTransactionId());
        String bqString = Utility.getDump((byte[])xid.getBranchQualifier());
        int formatId = xid.getFormatId();
        StringBuffer xidBuf = new StringBuffer();
        xidBuf.append('(');
        xidBuf.append(gtidString);
        xidBuf.append(": ");
        xidBuf.append(bqString);
        xidBuf.append(": ");
        xidBuf.append(formatId);
        xidBuf.append(')');
        return xidBuf.toString();
    }

    public static String getXidHexString(Xid xid) {
        if (xid == null) {
            return "";
        }
        String temp = null;
        int formatId = xid.getFormatId();
        String formatIdString = Integer.toHexString(formatId);
        if (formatIdString.length() % 2 != 0) {
            formatIdString = ZERO + formatIdString;
        }
        byte[] gtid = xid.getGlobalTransactionId();
        String gtidString = "00";
        if (gtid != null && (temp = Utility.getDump((byte[])gtid, (int)0, (int)gtid.length, (String)"", (String)"")).length() > 0) {
            gtidString = temp;
        }
        byte[] bq = xid.getBranchQualifier();
        String bqString = "00";
        if (bq != null && (temp = Utility.getDump((byte[])bq, (int)0, (int)bq.length, (String)"", (String)"")).length() > 0) {
            bqString = temp;
        }
        StringBuffer xidBuf = new StringBuffer(128);
        xidBuf.append(formatIdString).append('.').append(gtidString).append('.').append(bqString);
        return xidBuf.toString();
    }

    public static Xid getXidFromXidHexString(String xidHex) {
        byte[] bq;
        byte[] gtid;
        int formatId;
        if (xidHex == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(xidHex, ".");
        if (tokenizer.hasMoreTokens()) {
            try {
                formatId = Integer.parseInt(tokenizer.nextToken(), 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            return null;
        }
        if (tokenizer.hasMoreTokens()) {
            gtid = Utility.getBytes((String)tokenizer.nextToken());
            if (gtid == null) {
                return null;
            }
        } else {
            return null;
        }
        if (tokenizer.hasMoreTokens()) {
            bq = Utility.getBytes((String)tokenizer.nextToken());
            if (bq == null) {
                return null;
            }
        } else {
            return null;
        }
        return new XidImpl(gtid, bq, formatId);
    }

    private static String getTmaxXidString(Xid xid) {
        String gtidString = XidToString.removeFrontPaddingFromHex(Utility.getDumpWoSpace((byte[])xid.getGlobalTransactionId(), (int)0, (int)4));
        String gtid2String = XidToString.removeFrontPaddingFromHex(Utility.getDumpWoSpace((byte[])xid.getGlobalTransactionId(), (int)4, (int)4));
        String bqString = XidToString.removeFrontPaddingFromHex(Utility.getDumpWoSpace((byte[])xid.getBranchQualifier()));
        int formatId = xid.getFormatId();
        StringBuffer xidBuf = new StringBuffer();
        xidBuf.append(gtidString);
        xidBuf.append('-');
        xidBuf.append(gtid2String);
        xidBuf.append('-');
        xidBuf.append(bqString);
        xidBuf.append(':');
        xidBuf.append(formatId);
        return xidBuf.toString();
    }

    public static String removeFrontPaddingFromHex(String string) {
        int fIndex;
        for (fIndex = 0; fIndex < string.length() && string.charAt(fIndex) == '0'; ++fIndex) {
        }
        if (fIndex == string.length()) {
            return ZERO;
        }
        if (fIndex > 0) {
            return string.substring(fIndex);
        }
        return string;
    }

    public static Xid[] convertXids(Xid[] xids) {
        Xid[] xidImpls = new XidImpl[xids.length];
        for (int i = 0; i < xids.length; ++i) {
            Xid xid = xids[i];
            xidImpls[i] = new XidImpl(xid);
        }
        return xidImpls;
    }

    public static String getXAErrorCode(int i) {
        switch (i) {
            case 100: {
                return "error code : " + i + ", XA_RBROLLBACK, Indicates that the rollback was caused by an unspecified reason.";
            }
            case 101: {
                return "error code : " + i + ", XA_RBCOMMFAIL, Indicates that the rollback was caused by a communication failure.";
            }
            case 102: {
                return "error code : " + i + ", XA_RBDEADLOCK, A deadlock was detected.";
            }
            case 103: {
                return "error code : " + i + ", XA_RBINTEGRITY, A condition that violates the integrity of the resource was detected.";
            }
            case 104: {
                return "error code : " + i + ", XA_RBOTHER, The resource manager rolled back the transaction branch for a reason not on this list.";
            }
            case 105: {
                return "error code : " + i + ", XA_RBPROTO, A protocol error occurred in the resource manager.";
            }
            case 106: {
                return "error code : " + i + ", XA_RBTIMEOUT, A transaction branch took too long.";
            }
            case 107: {
                return "error code : " + i + ", XA_RBTRANSIENT, May retry the transaction branch. or XA_RBEND, The inclusive upper bound of the rollback error code.";
            }
            case 9: {
                return "error code : " + i + ", XA_NOMIGRATE, Resumption must occur where the suspension occurred.";
            }
            case 8: {
                return "error code : " + i + ", XA_HEURHAZ, The transaction branch may have been heuristically completed.";
            }
            case 7: {
                return "error code : " + i + ", XA_HEURCOM, The transaction branch has been heuristically committed.";
            }
            case 6: {
                return "error code : " + i + ", XA_HEURRB, The transaction branch has been heuristically rolled back.";
            }
            case 5: {
                return "error code : " + i + ", XA_HEURMIX, The transaction branch has been heuristically committed and rolled back.";
            }
            case 4: {
                return "error code : " + i + ", XA_RETRY, Routine returned with no effect and may be reissued.";
            }
            case 3: {
                return "error code : " + i + ", XA_RDONLY, The transaction branch was read-only and has been committed.";
            }
            case -2: {
                return "error code : " + i + ", XAER_ASYNC, There is an asynchronous operation already outstanding.";
            }
            case -3: {
                return "error code : " + i + ", XAER_RMERR, A resource manager error has occurred in the transaction branch.";
            }
            case -4: {
                return "error code : " + i + ", XAER_NOTA, The XID is not valid.";
            }
            case -5: {
                return "error code : " + i + ", XAER_INVAL, Invalid arguments were given.";
            }
            case -6: {
                return "error code : " + i + ", XAER_PROTO, Routine was invoked in an improper context.";
            }
            case -7: {
                return "error code : " + i + ", XAER_RMFAIL, Resource manager is unavailable.";
            }
            case -8: {
                return "error code : " + i + ", XAER_DUPID, The XID already exists.";
            }
            case -9: {
                return "error code : " + i + ", XAER_OUTSIDE, The resource manager is doing work outside a global transaction.";
            }
        }
        return "error code : " + i + ", Unknown XAException error code";
    }
}

