/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    private static Map<Class, Class> primitive2Wrapper = new HashMap<Class, Class>();

    public static Field[] getAllDeclaredFields(Class cls, Class stopSuperClass) {
        ArrayList<Field> list = new ArrayList<Field>();
        ClassUtil.getAllDeclaredFields(cls, stopSuperClass, false, list);
        return list.toArray(new Field[list.size()]);
    }

    public static Field[] getAllStaticFields(Class cls, Class stopSuperClass) {
        ArrayList<Field> list = new ArrayList<Field>();
        ClassUtil.getAllDeclaredFields(cls, stopSuperClass, true, list);
        return list.toArray(new Field[list.size()]);
    }

    public static List<Method> getAllMethods(Class cls, Class stopSuperClass) {
        ArrayList<Method> list;
        Method[] methods = cls.getDeclaredMethods();
        ArrayList<Method> inheritedMethods = null;
        Class superCls = cls.getSuperclass();
        if (superCls != null && superCls != stopSuperClass) {
            List<Method> supers = ClassUtil.getAllMethods(superCls, stopSuperClass);
            inheritedMethods = new ArrayList<Method>(supers.size());
            block0: for (Method superMethod : supers) {
                int mod = superMethod.getModifiers();
                if (!(Modifier.isStatic(mod) || Modifier.isFinal(mod) || Modifier.isPrivate(mod))) {
                    for (Method method : methods) {
                        if (ClassUtil.isSameSignature(superMethod, method)) continue block0;
                    }
                }
                inheritedMethods.add(superMethod);
            }
        }
        if (inheritedMethods != null) {
            list = new ArrayList(methods.length + inheritedMethods.size());
            for (Method m : inheritedMethods) {
                list.add(m);
            }
        } else {
            list = new ArrayList<Method>(methods.length);
        }
        for (Method m : methods) {
            list.add(m);
        }
        return list;
    }

    public static List<Method> getAllDeclaredMethods(Class cls, Class stopSuperClass) {
        ArrayList<Method> list = new ArrayList<Method>();
        ClassUtil.getAllDeclaredMethods(cls, stopSuperClass, false, list);
        return list;
    }

    public static List<Method> getAllStaticMethods(Class cls, Class stopSuperClass) {
        ArrayList<Method> list = new ArrayList<Method>();
        ClassUtil.getAllDeclaredMethods(cls, stopSuperClass, true, list);
        return list;
    }

    public static <T extends Annotation> List<T> getAllAnnotations(Class cls, Class<T> annotation, Class stopSuperClass) {
        T t;
        List<Object> list = null;
        Class superCls = cls.getSuperclass();
        if (superCls != null && superCls != stopSuperClass) {
            list = ClassUtil.getAllAnnotations(superCls, annotation, stopSuperClass);
        }
        if (list == null) {
            list = new ArrayList();
        }
        if ((t = cls.getAnnotation(annotation)) != null) {
            list.add(t);
        }
        return list;
    }

    private static void getAllDeclaredFields(Class cls, Class stopSuperClass, boolean staticOnly, List<Field> list) {
        Field[] fields;
        Class superCls = cls.getSuperclass();
        if (superCls != null && superCls != stopSuperClass) {
            ClassUtil.getAllDeclaredFields(superCls, stopSuperClass, staticOnly, list);
        }
        for (Field f : fields = cls.getDeclaredFields()) {
            if (staticOnly && !Modifier.isStatic(f.getModifiers())) continue;
            list.add(f);
        }
    }

    private static void getAllDeclaredMethods(Class cls, Class stopSuperClass, boolean staticOnly, List<Method> list) {
        Method[] methods;
        Class superCls = cls.getSuperclass();
        if (superCls != null && superCls != stopSuperClass) {
            ClassUtil.getAllDeclaredMethods(superCls, stopSuperClass, staticOnly, list);
        }
        for (Method m : methods = cls.getDeclaredMethods()) {
            if (staticOnly && !Modifier.isStatic(m.getModifiers())) continue;
            list.add(m);
        }
    }

    private static boolean isSameSignature(Method method1, Method method2) {
        return method1.getName().equals(method2.getName()) && Arrays.equals(method1.getParameterTypes(), method2.getParameterTypes());
    }

    public static Class getArrayClass(Class component, int dimensionSize) {
        int[] dim = new int[dimensionSize];
        return Array.newInstance(component, dim).getClass();
    }

    public static Class getWrapperClass(Class cls) {
        return primitive2Wrapper.get(cls);
    }

    static {
        primitive2Wrapper.put(Byte.TYPE, Byte.class);
        primitive2Wrapper.put(Boolean.TYPE, Boolean.class);
        primitive2Wrapper.put(Character.TYPE, Character.class);
        primitive2Wrapper.put(Double.TYPE, Double.class);
        primitive2Wrapper.put(Float.TYPE, Float.class);
        primitive2Wrapper.put(Integer.TYPE, Integer.class);
        primitive2Wrapper.put(Short.TYPE, Short.class);
    }
}

