/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jeus.descriptor.jeusserver.EmailDescriptor;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusException;
import jeus.util.message.JeusMessage_Util;

public class EmailSender {
    private MimeMessage message;
    private Session session;
    private String subject;

    public EmailSender(String name, EmailDescriptor desc) throws JeusException {
        try {
            Properties prop = System.getProperties();
            prop.put("mail.smtp.host", desc.getSMTPHostAddress());
            this.session = Session.getInstance((Properties)prop, null);
            this.message = new MimeMessage(this.session);
            InternetAddress fromAddr = new InternetAddress(desc.getFromEmailAddress());
            this.message.setFrom((Address)fromAddr);
            String tos = desc.getToRecipients();
            String ccs = desc.getCcRecipients();
            String bccs = desc.getBccRecipients();
            this.message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)tos));
            if (!ccs.equals("")) {
                this.message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccs));
            }
            if (!bccs.equals("")) {
                this.message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bccs));
            }
            this.subject = new String(ErrorMsgManager.getLocalizedString((int)JeusMessage_Util._1, (Object)name));
            this.message.setSubject(this.subject);
        }
        catch (Throwable ex) {
            throw new JeusException(JeusMessage_Util._2, ex);
        }
    }

    public synchronized void sendEmailNotification(String msg) throws JeusException {
        try {
            this.message.setText(msg);
            Transport.send((Message)this.message);
        }
        catch (Throwable ex) {
            throw new JeusException(JeusMessage_Util._3, (Object[])new String[]{this.subject, msg}, ex);
        }
    }
}

