/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import jeus.util.FIFOLockEnable;
import jeus.util.Queue;

public class FIFOLock {
    private FIFOLockEnable condition;
    private Queue threadQueue;
    private Object frontObject = null;
    private boolean isWaiting;

    public FIFOLock() {
        this.threadQueue = new Queue();
    }

    public FIFOLock(int initSizeThreads) {
        this.threadQueue = new Queue(initSizeThreads);
    }

    public FIFOLock(FIFOLockEnable condition) {
        this.condition = condition;
        this.threadQueue = new Queue();
    }

    public FIFOLock(FIFOLockEnable condition, int initSizeThreads) {
        this.condition = condition;
        this.threadQueue = new Queue(initSizeThreads);
    }

    public void waitLockWithCondition() throws InterruptedException {
        this.isWaiting = true;
        this.threadQueue.add((Object)Thread.currentThread());
        do {
            this.wait();
        } while (!Thread.currentThread().equals(this.frontObject) || !this.condition.isRunnable());
        if (this.threadQueue.isEmpty()) {
            this.isWaiting = false;
        }
    }

    public void waitLockWithCondition(Object lockObj) throws InterruptedException {
        this.isWaiting = true;
        this.threadQueue.add((Object)Thread.currentThread());
        do {
            lockObj.wait();
        } while (!Thread.currentThread().equals(this.frontObject) || !this.condition.isRunnable());
        if (this.threadQueue.isEmpty()) {
            this.isWaiting = false;
        }
    }

    public void waitLock() throws InterruptedException {
        this.isWaiting = true;
        this.threadQueue.add((Object)Thread.currentThread());
        do {
            this.wait();
        } while (!Thread.currentThread().equals(this.frontObject));
        if (this.threadQueue.isEmpty()) {
            this.isWaiting = false;
        }
    }

    public void waitLock(Object lockObj) throws InterruptedException {
        this.isWaiting = true;
        this.threadQueue.add((Object)Thread.currentThread());
        do {
            lockObj.wait();
        } while (!Thread.currentThread().equals(this.frontObject));
        if (this.threadQueue.isEmpty()) {
            this.isWaiting = false;
        }
    }

    public boolean isWaiting() {
        return this.isWaiting;
    }

    public void notifyLock() {
        this.frontObject = this.threadQueue.getFront();
        if (this.frontObject != null) {
            this.notifyAll();
        }
    }

    public void notifyLock(Object lockObj) {
        this.frontObject = this.threadQueue.getFront();
        if (this.frontObject != null) {
            lockObj.notifyAll();
        }
    }
}

