/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import jeus.util.Queue;

public class FIFOLock3 {
    private Queue threadQueue;

    public FIFOLock3() {
        this.threadQueue = new Queue();
    }

    public FIFOLock3(int initSize) {
        this.threadQueue = new Queue(initSize);
    }

    public void lock(Object lock) {
        ThreadInfo cur = this.enqueueNotifiable(lock);
        cur.lock();
    }

    public void unlock() {
        ThreadInfo next = this.checkNotifiable();
        if (next != null) {
            next.unlock();
        }
    }

    private synchronized ThreadInfo enqueueNotifiable(Object lock) {
        ThreadInfo cur = new ThreadInfo(lock);
        ThreadInfo rear = (ThreadInfo)this.threadQueue.peekRear();
        if (rear != null) {
            rear.next = cur;
            cur.block = true;
        }
        this.threadQueue.add((Object)cur);
        return cur;
    }

    private synchronized ThreadInfo checkNotifiable() {
        ThreadInfo cur = (ThreadInfo)this.threadQueue.getFront();
        return cur == null ? null : cur.next;
    }

    private class ThreadInfo {
        private boolean block;
        private ThreadInfo next;
        private final Object lock;

        public ThreadInfo(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lock() {
            Object object = this.lock;
            synchronized (object) {
                if (this.block) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlock() {
            Object object = this.lock;
            synchronized (object) {
                this.block = false;
                this.lock.notify();
            }
        }
    }
}

