/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jeus.util.JarExtractorException;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Util;

public class JarExtractor {
    private static final int cBlock = 4096;
    private static final String fs = System.getProperty("file.separator");
    private static final char fsc = fs.charAt(0);
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.util");

    private void strcopy(InputStream instr, OutputStream outstr) throws JarExtractorException {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = instr.read(buf)) > 0) {
                outstr.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new JarExtractorException(JeusMessage_Util._5, (Throwable)e);
        }
    }

    public void unJar(String srcJarName, String dstPath, boolean keepalive) throws JarExtractorException {
        this.innerUnJar(srcJarName, dstPath, new String(""), true);
    }

    public void unJar(String srcJarName, String dstPath) throws JarExtractorException {
        this.innerUnJar(srcJarName, dstPath, new String(""), false);
    }

    public void unJarEJB(String srcJarName, String dstPath, String clientJar) throws JarExtractorException {
        this.innerUnJar(srcJarName, dstPath, clientJar, false);
    }

    private void innerUnJar(String srcJarName, String dstPath, String clientJar, boolean keepalive) throws JarExtractorException {
        ZipFile srcJar = null;
        ZipEntry entry = null;
        String entryName = null;
        String dstFileName = null;
        File dstFile = null;
        String moduleName = null;
        if (!clientJar.equals("")) {
            moduleName = clientJar.substring(0, clientJar.indexOf(","));
            clientJar = clientJar.substring(clientJar.indexOf(",") + 1);
        }
        try {
            srcJar = new ZipFile(srcJarName);
            Enumeration<? extends ZipEntry> enum1 = srcJar.entries();
            while (enum1.hasMoreElements()) {
                entry = enum1.nextElement();
                entryName = entry.getName();
                dstFileName = dstPath + fs + entryName.replace('/', fsc);
                int idx = entryName.indexOf(47);
                if (idx != -1 && entryName.substring(0, idx).equals("META-INF") && !clientJar.equals("")) continue;
                if (entryName.equals(clientJar)) {
                    dstFileName = dstPath + fs + "client_jar" + fs + moduleName + "_" + clientJar;
                }
                if (FileUtils.isDirectory((ZipEntry)entry)) {
                    dstFile = new File(dstFileName);
                    dstFile.mkdirs();
                } else {
                    FileOutputStream outstr = this.makeFileOf(dstFileName);
                    InputStream instr = srcJar.getInputStream(entry);
                    this.strcopy(instr, outstr);
                    instr.close();
                    outstr.close();
                }
                if (!entryName.equals(clientJar)) continue;
                this.innerUnJar(dstFileName, dstPath + fs + "client_jar", new String(""), true);
            }
            srcJar.close();
            if (!keepalive) {
                new File(srcJarName).delete();
            }
        }
        catch (IOException ex) {
            throw new JarExtractorException(JeusMessage_Util._7, srcJarName, (Throwable)ex);
        }
    }

    private FileOutputStream makeFileOf(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.getParent() != null) {
            new File(file.getParent()).mkdirs();
        }
        return new FileOutputStream(file);
    }

    public void makeJar2(String sourceDir, String targetJar) throws JarExtractorException {
        try {
            File[] list = new File(sourceDir).listFiles();
            if (list != null && list.length != 0) {
                JarOutputStream jos = new JarOutputStream(this.makeFileOf(targetJar));
                int index = sourceDir.length() + 1;
                for (int i = 0; i < list.length; ++i) {
                    if (list[i].isFile()) {
                        jos.putNextEntry(new JarEntry(list[i].getPath().substring(index).replace(fsc, '/')));
                        FileInputStream is = new FileInputStream(list[i]);
                        this.strcopy(is, jos);
                        ((InputStream)is).close();
                        jos.closeEntry();
                        continue;
                    }
                    this.innerJar(jos, list[i].getPath(), index);
                }
                jos.close();
            }
        }
        catch (Throwable ex) {
            throw new JarExtractorException(JeusMessage_Util._8, targetJar, ex);
        }
    }

    public void makeJar(String fullSourceDir, String targetJar) throws JarExtractorException {
        try {
            JarOutputStream jos = new JarOutputStream(this.makeFileOf(targetJar));
            this.innerJar(jos, fullSourceDir, fullSourceDir.lastIndexOf(fsc) + 1);
            jos.close();
        }
        catch (Throwable ex) {
            throw new JarExtractorException(JeusMessage_Util._9, targetJar, ex);
        }
    }

    private void innerJar(JarOutputStream jos, String dir, int index) throws IOException {
        jos.putNextEntry(new JarEntry((dir + fs).substring(index).replace(fsc, '/')));
        jos.closeEntry();
        File[] list = new File(dir).listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isFile()) {
                    jos.putNextEntry(new JarEntry(list[i].getPath().substring(index).replace(fsc, '/')));
                    FileInputStream is = new FileInputStream(list[i]);
                    this.strcopy(is, jos);
                    ((InputStream)is).close();
                    jos.closeEntry();
                    continue;
                }
                this.innerJar(jos, list[i].getPath(), index);
            }
        }
    }
}

