/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusLocalizedException;

public class JeusLocalException
extends Exception
implements JeusLocalizedException {
    private static final long serialVersionUID = -600460765753706606L;
    private transient int msgID = -1;
    private transient Object[] args;
    private Throwable t;

    public JeusLocalException(String s) {
        this(s, null);
    }

    public JeusLocalException(Throwable t) {
        this(null, t);
    }

    public JeusLocalException(int msgID) {
        this(msgID, null, null);
    }

    public JeusLocalException(int msgID, Throwable t) {
        this(msgID, null, t);
    }

    public JeusLocalException(int msgID, Object arg) {
        this(msgID, arg, null);
    }

    public JeusLocalException(int msgID, Object[] args) {
        this(msgID, args, (Throwable)null);
    }

    public JeusLocalException(int msgID, Object arg, Throwable t) {
        this(ErrorMsgManager.getErrorStringMessage((int)msgID, (Object)arg), t);
        this.msgID = msgID;
        if (arg != null) {
            this.args = new Object[]{arg};
        }
    }

    public JeusLocalException(int msgID, Object[] args, Throwable t) {
        this(ErrorMsgManager.getErrorStringMessage((int)msgID, (Object[])args), t);
        this.msgID = msgID;
        this.args = args;
    }

    public JeusLocalException(String s, Throwable t) {
        super(s);
        this.t = t;
    }

    public int getMessageNumber() {
        return this.msgID;
    }

    public Object getParameter() {
        if (this.args != null && this.args.length == 1) {
            return this.args[0].toString();
        }
        return null;
    }

    public Object[] getParameters() {
        return this.args;
    }

    public Throwable getCause() {
        return this.t;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.msgID == 0) {
            this.msgID = -1;
        }
    }
}

