/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import jeus.util.ErrorMsgManager;
import jeus.util.ObjectInputStreamWithLoader;
import jeus.util.RemoteClassLoaderRepository;
import jeus.util.cnet.classftp.ClassFTPClassLoader;
import jeus.util.message.JeusMessage_Util;

public class RMIDeserializer
extends ObjectInputStream {
    private ClassLoader loader;

    public RMIDeserializer(InputStream in) throws IOException {
        this(in, null);
    }

    public RMIDeserializer(InputStream in, ClassLoader loader) throws IOException {
        super(in);
        this.enableResolveObject(true);
        this.loader = loader;
    }

    public RMIDeserializer(InputStream in, boolean notUseContextLoader) throws IOException {
        super(in);
        this.enableResolveObject(true);
        if (notUseContextLoader) {
            this.loader = RMIDeserializer.class.getClassLoader();
        }
    }

    protected Class resolveClass(ObjectStreamClass classDesc) throws ClassNotFoundException {
        ClassLoader contextClassLoader;
        String cname = classDesc.getName();
        if (this.loader != null) {
            contextClassLoader = this.loader;
        } else {
            contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader == null) {
                contextClassLoader = RMIDeserializer.class.getClassLoader();
            }
        }
        if (cname.startsWith("[")) {
            Class component;
            int dcount = 1;
            while (cname.charAt(dcount) == '[') {
                ++dcount;
            }
            if (cname.charAt(dcount) == 'L') {
                String className = cname.substring(dcount + 1, cname.length() - 1);
                try {
                    component = contextClassLoader.loadClass(className);
                }
                catch (Throwable e) {
                    try {
                        component = RMIDeserializer.class.getClassLoader().loadClass(className);
                    }
                    catch (Throwable t) {
                        component = RMIDeserializer.loadRemoteClass(this, className, contextClassLoader, e);
                    }
                }
            } else {
                if (cname.length() != dcount + 1) {
                    throw new ClassNotFoundException(cname);
                }
                component = ObjectInputStreamWithLoader.primitiveType((char)cname.charAt(dcount));
            }
            int[] dim = new int[dcount];
            for (int i = 0; i < dcount; ++i) {
                dim[i] = 0;
            }
            return Array.newInstance(component, dim).getClass();
        }
        try {
            return contextClassLoader.loadClass(cname);
        }
        catch (Throwable e) {
            try {
                return RMIDeserializer.class.getClassLoader().loadClass(cname);
            }
            catch (Throwable t) {
                return RMIDeserializer.loadRemoteClass(this, cname, contextClassLoader, e);
            }
        }
    }

    private static Class loadRemoteClass(ObjectInputStream ois, String className, ClassLoader parentClassLoader, Throwable e) throws ClassNotFoundException {
        String classdir = "";
        try {
            classdir = ois.readUTF();
            if (classdir.equals("")) {
                throw new ClassNotFoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Util._13, (Object)className) + e);
            }
        }
        catch (EOFException ex) {
            ClassNotFoundException e1 = new ClassNotFoundException("EOF detected for the name of remote class, maybe the class is not for EJB, please add the library for the class " + className + ": context classloader=" + parentClassLoader + ", RMIDeserializer classloader=" + RMIDeserializer.class.getClassLoader());
            throw e1;
        }
        catch (IOException ex) {
            ClassNotFoundException e1 = new ClassNotFoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Util._14, (Object[])new String[]{classdir, className, parentClassLoader.toString()}), ex);
            throw e1;
        }
        try {
            RemoteClassLoaderRepository remoteClassLoaderRepository = RemoteClassLoaderRepository.getRemoteClassLoaderRepository(parentClassLoader);
            ClassFTPClassLoader loader = remoteClassLoaderRepository.getRemoteLoader(classdir, parentClassLoader);
            return loader.loadClass(className);
        }
        catch (Throwable ex) {
            ClassNotFoundException e1 = new ClassNotFoundException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Util._14, (Object[])new String[]{classdir, className, parentClassLoader.toString()}), ex);
            throw e1;
        }
    }

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }
}

