/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import jeus.util.RemoteEJBLoader;
import jeus.util.cnet.classftp.ClassFTPClassLoader;
import jeus.util.cnet.classftp.Handler;

public class RemoteClassLoaderRepository {
    private Hashtable remoteLoaderTable = new Hashtable();
    private static HashMap jeusRootClassLoaderMap = new HashMap();

    public ClassFTPClassLoader getRemoteLoader(String codebase, ClassLoader parentClassLoader) throws MalformedURLException {
        if (codebase.lastIndexOf("___") == -1) {
            throw new IllegalArgumentException("Invalid codebase format");
        }
        String key = codebase.substring(0, codebase.lastIndexOf("___"));
        RemoteEJBLoader remoteLoader = (RemoteEJBLoader)this.remoteLoaderTable.get(key);
        if (remoteLoader != null && remoteLoader.isSameCodebase(codebase)) {
            return remoteLoader.getRemoteLoader();
        }
        URL[] codebaseURL = new URL[]{new URL(null, codebase, new Handler())};
        ClassFTPClassLoader loader = new ClassFTPClassLoader(codebaseURL[0], parentClassLoader, codebase);
        RemoteEJBLoader newRemoteLoader = new RemoteEJBLoader(codebase, loader);
        this.remoteLoaderTable.put(key, newRemoteLoader);
        return loader;
    }

    public static synchronized RemoteClassLoaderRepository getRemoteClassLoaderRepository(ClassLoader contextLoader) {
        RemoteClassLoaderRepository loader = (RemoteClassLoaderRepository)jeusRootClassLoaderMap.get(contextLoader);
        if (loader == null) {
            loader = new RemoteClassLoaderRepository();
            jeusRootClassLoaderMap.put(contextLoader, loader);
        }
        return loader;
    }

    public static synchronized void removeRemoteClassLoaderRepository(ClassLoader contextLoader) {
        if (contextLoader != null) {
            jeusRootClassLoaderMap.remove(contextLoader);
        }
    }
}

