/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.File;

public class Runner {
    public static int LIC_EDITION_BASE = 1;
    public static int LIC_EDITION_BASEPLUS = 2;
    public static int LIC_EDITION_STANDARD = 3;
    public static int LIC_EDITION_ENTERPRISE = 5;
    public static int LIC_TYPE_DEMO = 0;
    public static int LIC_TYPE_REAL = 1;
    public static int LIC_TYPE_BUNDLE = 2;
    public static int LIC_TYPE_DEVSERVER = 3;
    public static int LIC_TYPE_DEVELOPER = 4;
    public static int LIC_TYPE_ACADEMIC = 5;
    private static String LICENSE_FILE = System.getProperty("jeus.home") + File.separator + "license" + File.separator + "license";

    public static native int getNumCPU();

    private static native int getLicenseDueSec0(String var0);

    private static native int printLicenseInfo0(String var0);

    private static native int checkBoot0(String var0);

    private static native int checkLicenseEdition0(String var0, int var1);

    private static native int getLicenseEdition0(String var0);

    private static native int getLicenseType0(String var0);

    private static native int getLicenseNumOfClient0(String var0);

    public static long getLicenseDue() {
        try {
            long due = Runner.getLicenseDueSec0(LICENSE_FILE);
            if (due < 0L) {
                return due;
            }
            return due * 1000L;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -1L;
        }
    }

    public static void getLicenseInfo() {
        try {
            Runner.printLicenseInfo0(LICENSE_FILE);
        }
        catch (Throwable t) {
            System.out.println(">>>>>>>>>>>> fail to get license infomation");
        }
    }

    public static synchronized boolean checkBoot() {
        try {
            int n = Runner.checkBoot0(LICENSE_FILE);
            return n == 1;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public static boolean checkLicenseEdition(int edition) {
        try {
            int n = Runner.checkLicenseEdition0(LICENSE_FILE, edition);
            return n == 1;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public static int getLicenseEdition() {
        try {
            return Runner.getLicenseEdition0(LICENSE_FILE);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public static int getLicenseType() {
        try {
            return Runner.getLicenseType0(LICENSE_FILE);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public static int getNumOfLicensedClient() {
        try {
            return Runner.getLicenseNumOfClient0(LICENSE_FILE);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -1;
        }
    }

    static {
        System.loadLibrary("Runner");
    }
}

