/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.j2ee.statistics.Statistic;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.statistics.RangeStatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;
import jeus.management.j2ee.thread.ThreadInfo;
import jeus.management.j2ee.thread.ThreadPool;
import jeus.management.j2ee.thread.ThreadPoolStatsImpl;
import jeus.util.RefinedThreadPoolExecutor;
import jeus.util.StatisticThreadFactory;
import jeus.util.concurrent50.concurrent.BlockingQueue;
import jeus.util.concurrent50.concurrent.ThreadPoolExecutor;

public class StatisticRefinedThreadPoolExecutor
extends RefinedThreadPoolExecutor {
    private TimeStatisticImpl runningTime = new TimeStatisticImpl("ThreadExecutionTime", "millisecond", "thread execution time");
    private TimeStatisticImpl waitingTime = new TimeStatisticImpl("QueueWaitingTime", "millisecond", "queue waiting time");
    private RangeStatisticImpl waitingQueueSizeSampled = new RangeStatisticImpl("WaitingQueueSize", "EA", "sampled queue size");
    private static List mbeanCreationList = new Vector();
    private J2EEManagedObject mbean;

    public StatisticRefinedThreadPoolExecutor(String threadNamePrefix, int corePoolSize, int maximumPoolSize, long keepAliveTime, boolean isDaemon) {
        super(threadNamePrefix, corePoolSize, maximumPoolSize, keepAliveTime, isDaemon);
        if (JMXUtility.nodeObjectName == null) {
            mbeanCreationList.add(this);
        } else {
            this.createThreadPoolMBean();
        }
    }

    private void createThreadPoolMBean() {
        try {
            this.mbean = ThreadPool.createMBean(this.poolName, JMXUtility.nodeObjectName, (Object)this);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
    }

    public List shutdownNow() {
        if (this.mbean != null) {
            this.mbean.destroyMBean();
        }
        return super.shutdownNow();
    }

    public static void addThreadPoolMBeans() {
        for (int i = 0; i < mbeanCreationList.size(); ++i) {
            StatisticRefinedThreadPoolExecutor refinedThreadPoolExecutor = (StatisticRefinedThreadPoolExecutor)((Object)mbeanCreationList.get(i));
            refinedThreadPoolExecutor.createThreadPoolMBean();
        }
        mbeanCreationList = null;
    }

    protected void beforeExecute(Thread t, Runnable r) {
        long currentTime = System.currentTimeMillis();
        if (r instanceof StatisticRunnable) {
            ((StatisticRunnable)r).beginExecute(currentTime);
        }
        if (t instanceof StatisticThreadFactory.StatisticThread) {
            ((StatisticThreadFactory.StatisticThread)t).setBeginTime(currentTime);
        }
    }

    protected void afterExecute(Runnable r, Throwable t) {
        Thread thread = Thread.currentThread();
        if (thread instanceof StatisticThreadFactory.StatisticThread) {
            this.runningTime.addData(System.currentTimeMillis() - ((StatisticThreadFactory.StatisticThread)thread).getBeginTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getThreadInfo() {
        ArrayList<ThreadInfo> map;
        long currentTime = System.currentTimeMillis();
        Object object = this.mainLock;
        synchronized (object) {
            map = new ArrayList<ThreadInfo>(this.workers.size());
            for (ThreadPoolExecutor.Worker w : this.workers) {
                if (!w.isActive()) continue;
                Thread t = w.thread;
                if (t instanceof StatisticThreadFactory.StatisticThread) {
                    map.add(new ThreadInfo(t.getName(), ((StatisticThreadFactory.StatisticThread)t).getBeginTime(), currentTime));
                    continue;
                }
                map.add(new ThreadInfo(t.getName(), -1L, -1L));
            }
        }
        return map;
    }

    protected Runnable getQueueingCommand(Runnable command) {
        StatisticRunnable runnable = new StatisticRunnable(command);
        runnable.beforeQueue(this.workQueue);
        return runnable;
    }

    public void setStatistic(ThreadPoolStatsImpl stat) {
        stat.setStatistic((Statistic)this.runningTime);
        stat.setStatistic((Statistic)this.waitingTime);
        stat.setStatistic((Statistic)this.waitingQueueSizeSampled);
    }

    private class StatisticRunnable
    implements Runnable {
        private Runnable runnable;
        private long queueInsertionTime;

        StatisticRunnable(Runnable r) {
            this.runnable = r;
        }

        public void run() {
            this.runnable.run();
        }

        public void beginExecute(long currentTime) {
            StatisticRefinedThreadPoolExecutor.this.waitingTime.addData(currentTime - this.queueInsertionTime);
        }

        public void beforeQueue(BlockingQueue queue) {
            StatisticRefinedThreadPoolExecutor.this.waitingQueueSizeSampled.set((long)queue.size());
            this.queueInsertionTime = System.currentTimeMillis();
        }
    }
}

