/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.ant;

import java.util.Vector;
import jeus.security.base.Subject;
import jeus.security.util.LoginUtil;
import jeus.server.BootFailureException;
import jeus.server.NodeControllerStub;
import jeus.util.SecurityUtil;
import jeus.util.VirtualDNS;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AntJeusBoot
extends Task {
    private String node;
    private String real_node;
    private String username;
    private String password;
    private NodeControllerStub stub;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            SecurityUtil.installClientSecurity(this.node);
            LoginUtil.loginWithRuntimeException(Subject.makeSubject("SYSTEM_DOMAIN", this.username, this.password));
            this.stub = new NodeControllerStub();
            try {
                if (!this.openConnection()) {
                    return;
                }
                Vector v = this.stub.boot();
                System.out.println(this.node + " boot done");
                for (int i = 0; i < v.size(); ++i) {
                    System.out.println((String)v.get(i));
                }
            }
            catch (BootFailureException ex) {
                System.out.println(this.node + " boot failed");
            }
            finally {
                LoginUtil.logoutWithRuntimeException();
            }
            this.closeConnection();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setNode(String node) {
        System.setProperty("jeus.home", this.getProject().getProperty("jeus.home"));
        this.node = node;
        this.real_node = VirtualDNS.getRealNodeName(node);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void closeConnection() {
        try {
            this.stub.disconnect();
            this.stub.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean openConnection() {
        try {
            this.stub.connectTo(this.real_node);
            return true;
        }
        catch (Throwable t) {
            System.out.println("fail to connect to " + this.node);
            t.printStackTrace();
            return false;
        }
    }
}

