/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class AntJeusDDInit
extends Task {
    protected String taskClassName;
    private File targetFile;
    private File propertyFile;
    private String level;
    private File jeusHome;
    private Path userClassPath;

    public void execute() {
        if (this.jeusHome == null) {
            String jeusHome = System.getProperty("jeus.home");
            if (jeusHome == null) {
                throw new BuildException("Jeushome : " + jeusHome + " is not valid directory.");
            }
            this.jeusHome = new File(jeusHome);
        }
        if (!this.jeusHome.isDirectory()) {
            throw new BuildException("Jeushome : " + this.jeusHome.getPath() + " is not valid directory.");
        }
        String jvmArgs = "-Djeus.home=" + this.jeusHome.getAbsolutePath();
        Java task = (Java)this.getProject().createTask("java");
        Commandline.Argument jvmArg = task.createJvmarg();
        jvmArg.setLine(jvmArgs);
        task.setTaskName(this.getTaskName());
        task.setFork(true);
        task.setClassname(this.taskClassName);
        if (this.propertyFile != null) {
            task.createArg().setValue("-property");
            task.createArg().setValue(this.propertyFile.getAbsolutePath());
        }
        if (this.level != null) {
            task.createArg().setValue("-level");
            task.createArg().setValue(this.level);
        }
        Path classPath = new Path(this.getProject());
        classPath.setLocation(new File(this.jeusHome, "classes"));
        File libHome = new File(this.jeusHome, "lib" + File.separator + "system");
        classPath.setLocation(new File(libHome, "jext.jar"));
        classPath.setLocation(new File(libHome, "jeus.jar"));
        classPath.setLocation(new File(libHome, "xercesImpl.jar"));
        classPath.setLocation(new File(libHome, "xml-apis.jar"));
        classPath.setLocation(new File(libHome, "jaxb-impl.jar"));
        classPath.setLocation(new File(libHome, "jaxb-api.jar"));
        classPath.setLocation(new File(libHome, "jaxb-libs.jar"));
        classPath.setLocation(new File(libHome, "relaxngDatatype.jar"));
        classPath.setLocation(new File(libHome, "xsdlib.jar"));
        classPath.add(this.userClassPath);
        task.setClasspath(classPath);
        task.createArg().setValue(this.targetFile.getAbsolutePath());
        if (task.executeJava() != 0) {
            throw new BuildException("Error Occured");
        }
    }

    public void setJeusHome(File jeusHome) {
        this.jeusHome = jeusHome;
    }

    public void setProperty(File propertyFile) {
        this.propertyFile = propertyFile;
    }

    public void setLoggingLevel(String level) {
        this.level = level;
    }

    public void setTarget(File target) {
        this.targetFile = target;
    }

    public void addClasspath(Path path) {
        this.userClassPath = path;
    }
}

