/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.ant;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.TargetModuleIDImpl;
import jeus.deploy.status.ProgressHandler;
import jeus.management.JMXUtility;
import jeus.util.ant.JeusTaskBase;
import org.apache.tools.ant.BuildException;

public class AntJeusStatus
extends JeusTaskBase {
    private String command;
    private String moduleName;
    private String targetName;
    private String serverUri;
    private String userName;
    private String passwd;
    private String moduleType;
    JeusDeploymentManager jdm = null;

    public void setDeployURI(String su) {
        this.serverUri = su;
    }

    public void setUser(String user) {
        this.userName = user;
    }

    public void setPassword(String pass) {
        this.passwd = pass;
    }

    public void setTargetNames(String tn) {
        this.targetName = tn;
    }

    public void setModuleName(String mn) {
        this.moduleName = mn;
    }

    public void setCommand(String cmd) {
        this.command = cmd;
    }

    public void setModuleType(String mt) {
        this.moduleType = mt;
    }

    protected void doExecute() throws BuildException {
        TargetModuleID[] resultModuleIDs;
        try {
            System.setProperty("jeus.home", this.getProject().getProperty("jeus.home"));
            System.setProperty("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
            System.setProperty("java.naming.factory.url.pkgs", "jeus.jndi.jns.url");
            String[] decomposedUri = JeusDeploymentManager.decomposeUri(this.serverUri);
            System.setProperty("java.naming.provider.url", decomposedUri[0]);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        try {
            this.jdm = new JeusDeploymentManager(this.serverUri, this.userName, this.passwd);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        if (this.jdm.getJMXUtility() == null) {
            throw new BuildException("JMXUtility is not available..");
        }
        try {
            if (!(this.moduleType == null || this.moduleType.equals("J2EEApplication") || this.moduleType.equals("EJBModule") || this.moduleType.equals("WebModule") || this.moduleType.equals("AppClientModule") || this.moduleType.equalsIgnoreCase("ResourceAdapterModule"))) {
                throw new BuildException("module type : " + this.moduleType + " is not correct!");
            }
            Vector tmpStore = this.fillTargetModule(this.targetName, this.moduleName);
            resultModuleIDs = tmpStore.toArray(new TargetModuleID[0]);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
        ProgressHandler progressHandler = new ProgressHandler();
        ProgressObject progress = null;
        if (this.command.equalsIgnoreCase("start")) {
            progress = this.jdm.start(resultModuleIDs);
        } else if (this.command.equalsIgnoreCase("stop")) {
            progress = this.jdm.stop(resultModuleIDs);
        } else if (this.command.equalsIgnoreCase("undeploy")) {
            progress = this.jdm.undeploy(resultModuleIDs);
        }
        progress.addProgressListener((ProgressListener)progressHandler);
        try {
            progressHandler.join();
        }
        catch (Exception e) {
            // empty catch block
        }
        StateType completionState = progressHandler.getCompletionState();
        if (completionState.getValue() != StateType.COMPLETED.getValue()) {
            throw new BuildException("[ERROR] Module " + this.command + " not completed.");
        }
    }

    private List getParsedTargets(String targetString) {
        String[] targets = targetString.split(",");
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = targets[i].trim();
        }
        return Arrays.asList(targets);
    }

    private void fillTargetModuleQuery(ObjectName queryName, Vector tmpStore) throws Exception {
        Set targetModuleList = this.jdm.getJMXUtility().queryNames(queryName, null);
        if (targetModuleList == null || targetModuleList.size() == 0) {
            throw new BuildException("There is no module corresponding to " + this.moduleName + "in " + this.targetName);
        }
        for (ObjectName itemName : targetModuleList) {
            System.out.println("queried list :" + itemName);
            tmpStore.add(new TargetModuleIDImpl(itemName, null));
        }
    }

    private Vector fillTargetModule(String targetName, String moduleName) throws Exception {
        Vector<TargetModuleIDImpl> tmpStore = new Vector<TargetModuleIDImpl>();
        if (targetName == null || targetName.trim().equals("")) {
            ObjectName queryName = new ObjectName("JEUS:name=" + moduleName + "," + "j2eeType" + "=" + this.moduleType + ",*");
            this.fillTargetModuleQuery(queryName, tmpStore);
        } else {
            List targetList = this.getParsedTargets(targetName);
            for (int i = 0; i < targetList.size(); ++i) {
                String tgName = (String)targetList.get(i);
                ObjectName[] names = JMXUtility.queryJ2EEDeployedObjects((MBeanServerConnection)this.jdm.getJMXUtility(), null, tgName, this.moduleType, moduleName);
                if (names == null || names.length == 0) {
                    throw new BuildException("There is no module corresponding to " + moduleName + "in " + targetName);
                }
                tmpStore.add(new TargetModuleIDImpl(names[0], null));
            }
        }
        return tmpStore;
    }
}

