/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.codegen;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeUtil {
    public static String getPackageName(String className) {
        if (className == null) {
            throw new NullPointerException();
        }
        int index = className.lastIndexOf(46);
        if (index != -1) {
            return className.substring(0, index);
        }
        return "";
    }

    public static String getSimpleClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return className;
        }
        return className.substring(index + 1);
    }

    public static String getFullClassName(String packageName, String simpleClassName) {
        if (packageName != null && !packageName.equals("")) {
            return packageName + "." + simpleClassName;
        }
        return simpleClassName;
    }

    public static String[] getClassNames(Class<?>[] types) {
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = CodeUtil.getClassName(types[i]);
        }
        return names;
    }

    public static String[] nameParameters(Class<?>[] types) {
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "$param_" + i;
        }
        return names;
    }

    public static String getFullSignature(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        String sig = CodeUtil.getClassName(method.getReturnType()) + " " + method.getName() + "(";
        for (int i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                sig = sig + ", ";
            }
            sig = sig + CodeUtil.getClassName(parameters[i]);
        }
        sig = sig + ")";
        return sig;
    }

    public static String getSignature(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        String sig = method.getName() + "(";
        for (int i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                sig = sig + ", ";
            }
            sig = sig + CodeUtil.getClassName(parameters[i]);
        }
        sig = sig + ")";
        return sig;
    }

    public static String getClassName(Class cls) {
        String array = "";
        while (cls.isArray()) {
            cls = cls.getComponentType();
            array = array + "[]";
        }
        return cls.getName().replace('$', '.') + array;
    }

    public static String getModifierDecl(int modifiers) {
        StringBuffer buf = new StringBuffer();
        Vector<String> v = new Vector<String>();
        if (Modifier.isPublic(modifiers)) {
            v.add("public");
        } else if (Modifier.isPrivate(modifiers)) {
            v.add("private");
        } else if (Modifier.isProtected(modifiers)) {
            v.add("protected");
        }
        if (Modifier.isStatic(modifiers)) {
            v.add("static");
        }
        if (Modifier.isAbstract(modifiers)) {
            v.add("abstract");
        } else if (Modifier.isFinal(modifiers)) {
            v.add("final");
        }
        if (Modifier.isSynchronized(modifiers)) {
            v.add("synchronized");
        }
        if (Modifier.isTransient(modifiers)) {
            v.add("transient");
        }
        if (Modifier.isVolatile(modifiers)) {
            v.add("volatile");
        }
        for (int i = 0; i < v.size(); ++i) {
            if (i != 0) {
                buf.append(" ");
            }
            buf.append((String)v.get(i));
        }
        return buf.toString();
    }

    public static String getWrapperClassName(Class type) {
        if (type == Boolean.TYPE) {
            return "java.lang.Boolean";
        }
        if (type == Byte.TYPE) {
            return "java.lang.Byte";
        }
        if (type == Character.TYPE) {
            return "java.lang.Character";
        }
        if (type == Double.TYPE) {
            return "java.lang.Double";
        }
        if (type == Float.TYPE) {
            return "java.lang.Float";
        }
        if (type == Integer.TYPE) {
            return "java.lang.Integer";
        }
        if (type == Long.TYPE) {
            return "java.lang.Long";
        }
        if (type == Short.TYPE) {
            return "java.lang.Short";
        }
        if (type == Void.TYPE) {
            return "java.lang.Void";
        }
        return null;
    }

    public static String makeCommaList(String[] elements) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(elements[i]);
        }
        return buf.toString();
    }
}

