/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.ArrayList;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.EJBMBean;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;

public class EJBBeanListCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container where ejb module is deployed", "use container.name property or list EJB Beans of one EJB Module deployed in any container with a given module name or list EJB Beans of each EJB Module deployed in all container with a given regular expression");
    private Option regularExpressionOption;
    private Argument moduleNameArg;
    private OptionalArgument beanNameArg;

    public EJBBeanListCommand() {
        super("beanlist", "list EJB Beans");
        this.registerArgument((Argument)this.conOption);
        this.regularExpressionOption = new Option("r", "regard module_name and bean_name as regular expression");
        this.registerArgument((Argument)this.regularExpressionOption);
        this.moduleNameArg = new Argument("module_name", "module name");
        this.registerArgument(this.moduleNameArg);
        this.beanNameArg = new OptionalArgument("bean_name", "bean name, allows regular expression");
        this.registerArgument((Argument)this.beanNameArg);
    }

    public void run(PrintStream out) throws Exception {
        ObjectName[] ejbModuleObjectNames;
        String containerName = null;
        if (this.conOption.isSet()) {
            containerName = this.conOption.getValue();
            ejbModuleObjectNames = JMXUtility.queryJ2EEDeployedApplications(this.utility, this.nodeName, containerName, "EJBModule", null);
        } else {
            String[] containerNames = EJBBeanListCommand.getListProperty((String)"container.name");
            if (containerNames != null) {
                int containerCount = containerNames.length;
                ArrayList<ObjectName> deployedEJBModulesInAllCountainer = new ArrayList<ObjectName>();
                for (int i = 0; i < containerCount; ++i) {
                    ArrayList<ObjectName> deployedEJBModulesInACountainer = JMXUtility.queryJ2EEDeployedApplicationList(this.utility, this.nodeName, containerNames[i], "EJBModule", null);
                    deployedEJBModulesInAllCountainer.addAll(deployedEJBModulesInACountainer);
                }
                ejbModuleObjectNames = deployedEJBModulesInAllCountainer.toArray(new ObjectName[deployedEJBModulesInAllCountainer.size()]);
            } else {
                ejbModuleObjectNames = JMXUtility.queryJ2EEDeployedApplications(this.utility, this.nodeName, null, "EJBModule", null);
            }
        }
        String[] ejbModuleNames = null;
        boolean isRegEx = this.regularExpressionOption.isSet();
        if (!isRegEx) {
            ejbModuleNames = JMXUtility.getNameStringArray(ejbModuleObjectNames);
            ejbModuleNames = EJBBeanListCommand.getMatchedString((String)this.moduleNameArg.getValue(), (String[])ejbModuleNames, (boolean)isRegEx);
        }
        if (ejbModuleNames.length == 0) {
            out.println("there is no module corresponding to the request");
        }
        for (int i = 0; i < ejbModuleNames.length; ++i) {
            String name;
            out.println("module-name : " + ejbModuleNames[i]);
            if (containerName == null) {
                containerName = ejbModuleObjectNames[i].getKeyProperty("J2EEServer");
            }
            String[] beanNames = JMXUtility.getNameStringArray(JMXUtility.queryEJBNames(this.utility, containerName, ejbModuleNames[i], null));
            if (this.beanNameArg.isSet() && (name = this.beanNameArg.getValue()) != null && !name.equals("") && (beanNames = EJBBeanListCommand.getMatchedString((String)name, (String[])beanNames, (boolean)isRegEx)).length == 0) {
                out.println("there is no module corresponding to the request");
                break;
            }
            for (int j = 0; j < beanNames.length; ++j) {
                String beanName = beanNames[j];
                ObjectName[] beans = JMXUtility.queryEJBs(this.utility, containerName, ejbModuleNames[i], beanName);
                for (int k = 0; k < beans.length; ++k) {
                    String beanType = beans[k].getKeyProperty("j2eeType");
                    EJBMBean bean = JMXUtility.getProxy(this.utility, beans[k], EJBMBean.class, false);
                    String localExportName = bean.getLocalJndiName();
                    String remoteExportName = bean.getRemoteJndiName();
                    out.println("\tbean-name : " + beanName);
                    out.println("\t\ttype : " + beanType);
                    if (localExportName != null) {
                        out.println("\t\tlocal-export-name : " + localExportName);
                    }
                    if (remoteExportName == null) continue;
                    out.println("\t\tremote-export-name : " + remoteExportName);
                }
            }
        }
    }
}

