/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.BufferedReader;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import jeus.jdbc.console.ConnectionPoolControllerException;
import jeus.management.j2ee.JDBCResourceMBean;
import jeus.util.console.AbstractConsole;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.JDBCGroup;
import jeus.util.message.JeusMessage_JDBC;

public class JDBCReconfigCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container in which JDBC Datasource is located ", "use container.name");
    private Argument exportNameArg;
    private OptionalArgument userArg;
    private BufferedReader input;

    public JDBCReconfigCommand(BufferedReader input) {
        super("reconfigds", "reconfig JDBC DataSource");
        this.registerArgument((Argument)this.conOption);
        this.exportNameArg = new Argument("export_name", "export name of DataSource");
        this.registerArgument(this.exportNameArg);
        this.userArg = new OptionalArgument("username/password", "username and password if you want to change the username and password of DataSource configuration");
        this.registerArgument((Argument)this.userArg);
        this.input = input;
    }

    public void run(PrintStream out) throws Exception {
        JDBCResourceMBean[] resourceMBeans = null;
        resourceMBeans = this.conOption.isSet() ? new JDBCResourceMBean[]{this.getJDBCResource(this.conOption.getValue())} : JDBCGroup.getCachedJDBCResourceMBeans();
        if (resourceMBeans == null || resourceMBeans.length == 0) {
            throw new JeusImproperCommanderException("set container name by using -con option or setProperty command");
        }
        String cpname = this.exportNameArg.getValue();
        Hashtable<String, String> properties = null;
        String userPass = null;
        if (this.userArg.isSet()) {
            userPass = this.userArg.getValue();
        }
        block4: for (int i = 0; i < resourceMBeans.length; ++i) {
            if (userPass == null) {
                out.println("type properties for " + resourceMBeans[i].getContainerName());
                properties = new Hashtable();
                while (true) {
                    String[] cmds;
                    if ((cmds = AbstractConsole.getCommandStrings((BufferedReader)this.input, (String)"reconfig")).length == 0) {
                        continue;
                    }
                    if (cmds[0].toLowerCase().equals(".")) {
                        try {
                            resourceMBeans[i].updateCP(cpname, properties);
                            continue block4;
                        }
                        catch (Exception e) {
                            throw new ConnectionPoolControllerException(JeusMessage_JDBC._81, (Throwable)e);
                        }
                    }
                    if (cmds.length != 2) {
                        throw new JeusImproperCommanderException(JeusMessage_JDBC._209);
                    }
                    if (cmds[0].toLowerCase().equals("user")) {
                        properties.put("User", cmds[1]);
                        continue;
                    }
                    if (cmds[0].toLowerCase().equals("password")) {
                        properties.put("Password", cmds[1]);
                        continue;
                    }
                    if (cmds[0].toLowerCase().equals("poolmin")) {
                        properties.put("PoolMin", cmds[1]);
                        continue;
                    }
                    if (cmds[0].toLowerCase().equals("poolmax")) {
                        properties.put("PoolMax", cmds[1]);
                        continue;
                    }
                    if (!cmds[0].toLowerCase().equals("poolstep")) break;
                    properties.put("PoolStep", cmds[1]);
                }
                throw new JeusImproperCommanderException(JeusMessage_JDBC._210);
            }
            properties = new Hashtable<String, String>();
            int slash = userPass.indexOf(47);
            if (slash < 0) {
                throw new ConnectionPoolControllerException(JeusMessage_JDBC._80);
            }
            properties.put("User", userPass.substring(0, slash));
            properties.put("Password", userPass.substring(slash + 1));
            try {
                resourceMBeans[i].updateCP(cpname, properties);
                continue;
            }
            catch (RemoteException e) {
                throw new ConnectionPoolControllerException(JeusMessage_JDBC._81, (Throwable)e);
            }
        }
    }
}

