/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import jeus.jdbc.console.ConnectionPoolControllerException;
import jeus.management.j2ee.JDBCResourceMBean;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.JDBCGroup;
import jeus.util.message.JeusMessage_JDBC;

public class JDBCResyncCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container in which JDBC Datasource is located ", "use container.name");
    private Argument exportNameArg;

    public JDBCResyncCommand() {
        super("resyncds", "recover JDBC datasource transactions. The target pool should exist.");
        this.registerArgument((Argument)this.conOption);
        this.exportNameArg = new Argument("export_name", "export name of DataSource");
        this.registerArgument(this.exportNameArg);
    }

    public void run(PrintStream out) throws Exception {
        JDBCResourceMBean[] resourceMBeans = null;
        resourceMBeans = this.conOption.isSet() ? new JDBCResourceMBean[]{this.getJDBCResource(this.conOption.getValue())} : JDBCGroup.getCachedJDBCResourceMBeans();
        if (resourceMBeans == null || resourceMBeans.length == 0) {
            throw new JeusImproperCommanderException("set container name by using -con option or setProperty command");
        }
        ConnectionPoolControllerException exceptionOccurred = null;
        for (int i = 0; i < resourceMBeans.length; ++i) {
            try {
                resourceMBeans[i].resyncCP(this.exportNameArg.getValue());
                out.println("resyncds is successfully done. container = " + resourceMBeans[i].getContainerName());
                continue;
            }
            catch (Exception e) {
                out.println(e.getCause() + " container name = " + resourceMBeans[i].getContainerName());
                exceptionOccurred = new ConnectionPoolControllerException(JeusMessage_JDBC._81, (Throwable)e);
            }
        }
        if (exceptionOccurred != null) {
            throw exceptionOccurred;
        }
    }
}

