/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.IOException;
import java.io.PrintStream;
import jeus.jdbc.datasource.DBDataSourceException;
import jeus.server.service.JDBCResourceServiceMBean;
import jeus.util.console.Argument;
import jeus.util.console.command.JeusMBeanCommand;

public class JDBCTestConfigCommand
extends JeusMBeanCommand {
    private Argument exportNameArg = new Argument("export_name", "export name of DataSource");

    public JDBCTestConfigCommand() {
        super("testdsconfig", "Test configuration of JDBC DataSource and connnection");
        this.registerArgument(this.exportNameArg);
    }

    public void run(PrintStream out) throws Exception {
        this.testDBConfig(out);
    }

    private boolean testDBConfig(PrintStream out) {
        try {
            JDBCResourceServiceMBean jdbcResourceService = this.getJDBCResourceService();
            jdbcResourceService.testDBConfiguration(this.exportNameArg.getValue(), this.nodeName);
        }
        catch (DBDataSourceException e) {
            out.println("Configuration is NOT valid : " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            out.println("Configuration test failed due to MBean problem : " + e.getMessage());
            return false;
        }
        out.println("Configuration is valid. You can use it.");
        return true;
    }
}

