/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.EJBMBean;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.management.j2ee.JDBCResourceMBean;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.management.j2ee.JTAResourceMBean;
import jeus.management.j2ee.JVMMBean;
import jeus.management.j2ee.ejb.EJBEngineMoMBean;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.server.service.ContainerManagerServiceMBean;
import jeus.server.service.JDBCResourceServiceMBean;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JeusRuntimeException;
import jeus.util.console.command.MBeanCommand;
import jeus.util.regex.CharSequence;
import jeus.util.regex.Matcher;
import jeus.util.regex.Pattern;
import jeus.util.regex.StringCharSequence;

public abstract class JeusMBeanCommand
extends MBeanCommand {
    protected String nodeName;

    public JeusMBeanCommand(String commandName, String simpleHelp) {
        super(commandName, simpleHelp, null);
    }

    public void initialize() {
        this.utility = this.getGroup().getUtility();
        this.nodeName = this.getGroup().getNodeName();
    }

    public JeusMBeanCommand(String commandName, String simpleHelp, MBeanServerConnection utility, String nodeName) {
        super(commandName, simpleHelp, utility);
        this.nodeName = nodeName;
    }

    protected ContainerManagerServiceMBean getContainerManagerService(String nodeName) throws IOException {
        Set objectNames = JMXUtility.queryContainerManager(this.utility, nodeName);
        if (objectNames.size() != 1) {
            throw new JeusRuntimeException("failed to get the ContainerManagerService(node=" + nodeName + ", names=" + objectNames + ")");
        }
        return JMXUtility.getProxy(this.utility, (ObjectName)objectNames.iterator().next(), ContainerManagerServiceMBean.class, false);
    }

    protected ContainerManagerServiceMBean getContainerManagerService() throws IOException {
        return this.getContainerManagerService(this.nodeName);
    }

    public JEUSManagerMBean getJeusManagerMoMBean(String node) throws IOException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryJeusManager(this.utility, node), JEUSManagerMBean.class, false);
    }

    public JEUSManagerMBean getJeusManagerMoMBean() throws IOException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryJeusManager(this.utility, this.nodeName), JEUSManagerMBean.class, false);
    }

    protected J2EEServerMBean getJ2EEServerMBean(String containerName) throws IOException, IllegalJeusSystemNameException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryJ2EEServer(this.utility, containerName), J2EEServerMBean.class, false);
    }

    protected J2EEServerMBean[] getJ2EEServerMBeans(String nodeName) throws IOException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryJ2EEServers(this.utility, nodeName), J2EEServerMBean.class, false);
    }

    protected JVMMBean getJVM(String containerName) throws IOException, IllegalJeusSystemNameException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryJVM(this.utility, this.nodeName, containerName), JVMMBean.class, false);
    }

    protected JDBCResourceServiceMBean[] getJDBCResourceServices(ObjectName[] names) {
        return JMXUtility.getProxy(this.utility, names, JDBCResourceServiceMBean.class, false);
    }

    protected JDBCResourceServiceMBean getJDBCResourceService() throws IOException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryJDBCResourceService(this.utility, this.nodeName), JDBCResourceServiceMBean.class, false);
    }

    protected EJBEngineMoMBean getEJBEngineMoMBean(String container) throws IOException, IllegalJeusSystemNameException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryEJBEngine(this.utility, container), EJBEngineMoMBean.class, false);
    }

    protected EJBMBean[] getEJBEngineMoMBean(String container, String moduleName, String beanName) throws IOException, IllegalJeusSystemNameException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryEJBs(this.utility, container, moduleName, beanName), EJBMBean.class, false);
    }

    protected JDBCResourceMBean getJDBCResource(String containerName) throws IOException, IllegalJeusSystemNameException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryJDBCResource(this.utility, containerName), JDBCResourceMBean.class, false);
    }

    protected JTAResourceMBean getJTAResource(String containerName) throws IOException, IllegalJeusSystemNameException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryJTAResource(this.utility, containerName), JTAResourceMBean.class, false);
    }

    protected WebEngineMoMBean getWebEngine(String containerName) throws IOException, IllegalJeusSystemNameException {
        return JMXUtility.getProxy(this.utility, JMXUtility.queryWebEngine(this.utility, containerName), WebEngineMoMBean.class, false);
    }

    protected static ObjectName[] getMatchedString(String pattern, ObjectName[] objectNames, boolean isRegEx) {
        if (!isRegEx) {
            pattern = pattern.replaceAll("\\.", "\\\\.");
            pattern = pattern.replaceAll("\\*", ".*");
            pattern = pattern.replace('?', '.');
            pattern = new StringBuffer().append("^").append(pattern).append("$").toString();
        }
        Pattern modulePattern = Pattern.compile((String)pattern);
        Matcher moduleMatcher = modulePattern.matcher((CharSequence)new StringCharSequence(""));
        ArrayList<ObjectName> matchedNames = new ArrayList<ObjectName>();
        for (int i = 0; i < objectNames.length; ++i) {
            String name = objectNames[i].getKeyProperty("name");
            moduleMatcher.reset((CharSequence)new StringCharSequence(name));
            if (!moduleMatcher.matches()) continue;
            matchedNames.add(objectNames[i]);
        }
        objectNames = matchedNames.toArray(new ObjectName[matchedNames.size()]);
        return objectNames;
    }

    protected static void printNameValues(PrintStream out, ObjectName[] engines) {
        String[] engineNames = JMXUtility.getNameStringArray(engines);
        for (int j = 0; j < engineNames.length; ++j) {
            out.println(engineNames[j]);
        }
    }

    protected static void printNameValuesWithCondition(PrintStream out, ObjectName[] engines, String condition) {
        String[] engineNames = JMXUtility.getNameStringArray(engines);
        for (int j = 0; j < engineNames.length; ++j) {
            if (condition != null && !condition.equals("")) {
                if (engineNames[j].indexOf(condition) <= 0) continue;
                out.println(engineNames[j]);
                continue;
            }
            out.println(engineNames[j]);
        }
    }

    protected boolean isContainerInNode(String containerName) throws IOException {
        ContainerManagerServiceMBean manager = this.getContainerManagerService(this.nodeName);
        Vector allConList = manager.getAllContainerList(this.nodeName);
        return allConList.contains(containerName);
    }

    protected boolean isContainerRunning(String containerName) throws IOException {
        ContainerManagerServiceMBean manager = this.getContainerManagerService(this.nodeName);
        Vector runningConList = manager.getContainerList(this.nodeName);
        return runningConList.contains(containerName);
    }
}

