/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.logging.Level;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.server.service.JeusLogServiceMBean;
import jeus.util.StringUtil;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;
import jeus.util.console.ToggleArguments;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.logging.ConsoleHandler;
import jeus.util.logging.JeusLevel;

public class LogLevelCommand
extends JeusMBeanCommand {
    private ArgumentedOption containerArg = new ArgumentedOption("con", "container_name", "the container to set logging level");
    private ArgumentedOption nodeArg = new ArgumentedOption("node", "node_name", "the JEUS Manager to set logging level");
    private Option setHandler;
    private Option force;
    private Argument loggerArg;
    private Argument handlerArg;
    private Argument levelArg;

    public LogLevelCommand() {
        super("loglevel", "set logging level");
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.containerArg, this.nodeArg}));
        this.setHandler = new Option("set-handler", "set handler level along with logger", true);
        this.registerArgument((Argument)this.setHandler);
        this.force = new Option("f", "force to set logging level", true);
        this.registerArgument((Argument)this.force);
        this.loggerArg = new Argument("name", "the logger name to set level");
        this.registerArgument(this.loggerArg);
        this.handlerArg = new OptionalArgument("handler_name", "the handler name to set level", "set handler level automatically");
        this.registerArgument(this.handlerArg);
        this.levelArg = new OptionalArgument("level", "the level to set");
        this.registerArgument(this.levelArg);
    }

    public void run(PrintStream out) throws Exception {
        String node;
        String container = null;
        if (this.nodeArg.isSet()) {
            node = this.nodeArg.getValue();
        } else if (this.containerArg.isSet()) {
            container = this.containerArg.getValue();
            node = StringUtil.getNodeNameFromContainerName((String)container);
        } else {
            node = this.nodeName;
        }
        boolean forced = this.force.isSet();
        String loggerName = this.loggerArg.getValue();
        String handler = null;
        String level = null;
        if (!this.levelArg.isSet()) {
            if (this.handlerArg.isSet()) {
                level = this.handlerArg.getValue();
            }
        } else {
            handler = this.handlerArg.getValue();
            level = this.levelArg.getValue();
        }
        ObjectName logServiceName = JMXUtility.queryLogService(this.utility, node, container);
        JeusLogServiceMBean logService = JMXUtility.getProxy(this.utility, logServiceName, JeusLogServiceMBean.class, false);
        boolean isNodeJeusLogger = logServiceName.getKeyProperty("J2EEServer").equals("null");
        if (level == null) {
            level = logService.getLogLevel(loggerName);
            out.println("logger name : " + loggerName + "\tlevel : " + level);
            while (loggerName != null) {
                String[] handlerNames = logService.getHandlerList(loggerName);
                boolean isConsoleHandlerIncluded = false;
                for (int i = 0; i < handlerNames.length; ++i) {
                    String handlerName = handlerNames[i];
                    String handlerLevel = logService.getHandlerLevel(loggerName, handlerName);
                    String handlerType = logService.getHandlerClassName(loggerName, handlerName);
                    if (handlerType.equals(ConsoleHandler.class.getName())) {
                        isConsoleHandlerIncluded = true;
                    }
                    out.println("\thandler name : " + handlerName + "\tclass : " + handlerType + "\tlevel : " + handlerLevel);
                }
                boolean useParentHandler = logService.isUseParentHandler(loggerName);
                out.println("\tuseParentHandler : " + Boolean.valueOf(useParentHandler));
                if (!isNodeJeusLogger && loggerName.equals("jeus") && isConsoleHandlerIncluded) {
                    loggerName = "jeus";
                    logService = JMXUtility.getProxy(this.utility, JMXUtility.queryLogService(this.utility, node, null), JeusLogServiceMBean.class, false);
                    out.println("node jeus logger");
                    isNodeJeusLogger = true;
                    continue;
                }
                if (useParentHandler) {
                    if ((loggerName = logService.getParentLogger(loggerName)) == null) {
                        out.println("no parent logger");
                        continue;
                    }
                    out.println("parent logger name : " + loggerName);
                    continue;
                }
                break;
            }
        } else if (handler != null) {
            logService.setHandlerLevel(loggerName, handler, level);
        } else {
            logService.setLogLevel(loggerName, level, forced);
            level = logService.getLogLevel(loggerName);
            out.println("logger name : " + loggerName + "\tlevel : " + level);
            Level levelObject = JeusLevel.parse((String)level);
            while (loggerName != null) {
                String[] handlerNames = logService.getHandlerList(loggerName);
                boolean isConsoleHandlerIncluded = false;
                for (int i = 0; i < handlerNames.length; ++i) {
                    String handlerName = handlerNames[i];
                    String handlerLevel = logService.getHandlerLevel(loggerName, handlerName);
                    String handlerType = logService.getHandlerClassName(loggerName, handlerName);
                    if (handlerType.equals(ConsoleHandler.class.getName())) {
                        isConsoleHandlerIncluded = true;
                    }
                    if (levelObject.intValue() < JeusLevel.parse((String)handlerLevel).intValue()) {
                        if (this.setHandler.isSet()) {
                            logService.setHandlerLevel(loggerName, handlerName, levelObject.getName());
                            out.println("\tThe level of handler " + handlerName + " is set from " + handlerLevel + " to " + levelObject + " and it will publish all log messages of the logger");
                            continue;
                        }
                        out.println("\tThe level of handler " + handlerName + " is " + handlerLevel + "  and it will NOT publish finer log messages");
                        continue;
                    }
                    out.println("\tThe level of handler " + handlerName + " is " + handlerLevel + " and it will publish all log messages of the logger");
                }
                boolean useParentHandler = logService.isUseParentHandler(loggerName);
                out.println("\tuseParentHandler : " + Boolean.valueOf(useParentHandler));
                if (!isNodeJeusLogger && loggerName.equals("jeus") && isConsoleHandlerIncluded) {
                    loggerName = "jeus";
                    logService = JMXUtility.getProxy(this.utility, JMXUtility.queryLogService(this.utility, node, null), JeusLogServiceMBean.class, false);
                    out.println("node jeus logger");
                    isNodeJeusLogger = true;
                    continue;
                }
                if (useParentHandler) {
                    if ((loggerName = logService.getParentLogger(loggerName)) == null) {
                        out.println("no parent logger");
                        continue;
                    }
                    out.println("parent logger name : " + loggerName);
                    continue;
                }
                break;
            }
        }
    }
}

