/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import jeus.management.j2ee.JVMMBean;
import jeus.management.j2ee.statistics.JVMStatsImpl;
import jeus.util.console.Argument;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;

public class MemInfoCommand
extends JeusMBeanCommand {
    private Argument container = new OptionalArgument("container_name", "the name of container to get the memory information of the container", "the JEUS Manager admin connected");

    public MemInfoCommand() {
        super("meminfo", "print memory information of JEUS process");
        this.registerArgument(this.container);
    }

    public void run(PrintStream out) throws Exception {
        String containerName = null;
        if (this.container.isSet()) {
            containerName = this.container.getValue();
        }
        JVMMBean jvm = this.getJVM(containerName);
        JVMStatsImpl stat = (JVMStatsImpl)jvm.getstats();
        long total = stat.getTotalSize().getCurrent();
        long current = stat.getHeapSize().getCurrent();
        if (containerName == null) {
            out.println("--JEUS Manager Memory Information--");
        } else {
            out.println("--Engine Container " + containerName + " Memory Information--");
        }
        out.println("TotalMemory : " + total);
        out.println("CurrentMemory : " + current);
    }
}

