/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import jeus.server.NodeControllerStub;
import jeus.util.console.Command;

public abstract class NodeControllerCommand
extends Command {
    protected String nodeName;
    protected NodeControllerStub stub;
    protected String realNodeName;

    public NodeControllerCommand(String commandName, String simpleHelp, String nodeName, String realNodeName) {
        super(commandName, simpleHelp);
        this.nodeName = nodeName;
        this.realNodeName = realNodeName;
    }

    protected boolean openConnection(PrintStream out) {
        this.stub = NodeControllerCommand.openConnection(out, this.realNodeName);
        return this.stub != null;
    }

    public static NodeControllerStub openConnection(PrintStream out, String nodeName) {
        try {
            NodeControllerStub stub = new NodeControllerStub();
            stub.connectTo(nodeName);
            return stub;
        }
        catch (Throwable t) {
            out.println("fail to connect " + nodeName);
            return null;
        }
    }

    protected void closeConnection() {
        try {
            if (this.stub != null) {
                this.stub.disconnect();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

