/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.server.service.ContainerManagerServiceMBean;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.command.JeusMBeanCommand;

public class PidListCommand
extends JeusMBeanCommand {
    private Option all = new Option("a", "all processes including JEUS Manager and Engine Containers", true);

    public PidListCommand() {
        super("pidlist", "print pids of JEUS processes");
        this.registerArgument((Argument)this.all);
    }

    public void run(PrintStream out) throws Exception {
        if (this.all.isSet()) {
            JEUSManagerMBean manager = this.getJeusManagerMoMBean();
            String[] aliveNodeNames = manager.getAliveNodeNames();
            for (int i = 0; i < aliveNodeNames.length; ++i) {
                String nodeName = aliveNodeNames[i];
                out.println("for the node " + nodeName);
                this.printNodePIDList(nodeName, out);
            }
        } else {
            this.printNodePIDList(this.nodeName, out);
        }
    }

    private void printNodePIDList(String nodeName, PrintStream out) throws IOException {
        ContainerManagerServiceMBean containerManager = this.getContainerManagerService();
        Map pidMap = containerManager.getPIDMap();
        for (Map.Entry entrySet : pidMap.entrySet()) {
            String containerName = (String)entrySet.getKey();
            Integer pid = (Integer)entrySet.getValue();
            out.println("node or container : " + containerName + ", pid : " + pid);
        }
    }
}

