/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.bind.JAXBException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.TargetImpl;
import jeus.deploy.status.DeploymentStatusImpl;
import jeus.deploy.status.JeusProgressObject;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.StringUtil;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.command.UndeployCommand;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.jeusDD.ApplicationType;

public class ReloadCommand
extends UndeployCommand {
    private String containerName;

    public ReloadCommand() {
        super("redeploy", "redeploy application");
    }

    public ReloadCommand(String containerConnected) {
        this();
        this.containerName = containerConnected;
    }

    public void run(PrintStream out) throws Exception {
        if (this.containerName != null) {
            this.conOption.setValue(this.containerName);
        }
        List filePaths = this.undeploy(out);
        for (int i = 0; i < filePaths.size(); ++i) {
            Object[] paths = (Object[])filePaths.get(i);
            ObjectName moduleObjectName = (ObjectName)paths[0];
            ApplicationType appType = (ApplicationType)paths[1];
            try {
                this.deployApp(moduleObjectName.getKeyProperty("J2EEServer"), appType, this.utility, this.nodeName, false, out);
                continue;
            }
            catch (JeusImproperCommanderException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    protected void deployApp(String container, ApplicationType appType, MBeanServerConnection utility, String node, boolean onlyDistribute, PrintStream out) throws IOException, JAXBException, IllegalJeusSystemNameException {
        out.println("using the following application info : " + StringUtil.lineSeparator + appType.strip2());
        J2EEServerMBean[] servers = container != null ? new J2EEServerMBean[]{this.getJ2EEServerMBean(container)} : this.getJ2EEServerMBeans(node);
        if (servers.length == 0) {
            throw new JeusImproperCommanderException("There is no container");
        }
        Target[] targets = new Target[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            J2EEServerMBean server = servers[i];
            ObjectName objectName = server.getObjectName();
            targets[i] = new TargetImpl(objectName);
        }
        JeusProgressObject po = new JeusProgressObject();
        commander.distribute(targets, appType, utility, po, true);
        TargetModuleID[] successIDs = po.getResultTargetModuleIDs();
        if (successIDs == null || successIDs.length != targets.length) {
            Exception message = ((DeploymentStatusImpl)po.getDeploymentStatus()).getFailException();
            po = new JeusProgressObject();
            commander.undeploy(successIDs, utility, po);
            throw new JeusImproperCommanderException(JeusMessage_Manager._386, JeusDeploymentManager.getApplicationName(appType), (Throwable)message);
        }
        if (!onlyDistribute) {
            po = new JeusProgressObject(po);
            commander.start(successIDs, utility, po);
            TargetModuleID[] startSuccessIDs = po.getResultTargetModuleIDs();
            if (startSuccessIDs == null || startSuccessIDs.length != successIDs.length) {
                Exception message = ((DeploymentStatusImpl)po.getDeploymentStatus()).getFailException();
                po = new JeusProgressObject();
                commander.undeploy(successIDs, utility, po);
                throw new JeusImproperCommanderException(JeusMessage_Manager._386, JeusDeploymentManager.getApplicationName(appType), (Throwable)message);
            }
        }
    }
}

