/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEDeployedObjectMBean;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.command.ApplicationCommand;

public class StopCommand
extends ApplicationCommand {
    private String containerName;

    public StopCommand() {
        super("stop", "stop running application");
    }

    public StopCommand(String containerConnected) {
        this();
        this.containerName = containerConnected;
    }

    public void run(PrintStream out) throws Exception {
        if (this.isAll()) {
            throw new JeusImproperCommanderException("The module name or application name cannot be empty");
        }
        if (this.containerName != null) {
            this.conOption.setValue(this.containerName);
        }
        ObjectName[] moduleObjectNames = new ObjectName[]{};
        try {
            moduleObjectNames = this.getJ2EEDeployedObjects();
        }
        catch (IllegalArgumentException iae) {
            out.println(iae.getMessage());
        }
        catch (Exception ex) {
            throw new JeusImproperCommanderException((Throwable)ex);
        }
        for (int i = 0; i < moduleObjectNames.length; ++i) {
            ObjectName moduleObjectName = moduleObjectNames[i];
            J2EEDeployedObjectMBean mbean = JMXUtility.getProxy(this.utility, moduleObjectName, J2EEDeployedObjectMBean.class, false);
            try {
                mbean.stop();
                out.println("The " + moduleObjectName.getKeyProperty("j2eeType") + ", " + moduleObjectName.getKeyProperty("name") + ", is stopped on " + moduleObjectName.getKeyProperty("J2EEServer"));
                continue;
            }
            catch (Exception e) {
                out.println("fail to stop the module " + moduleObjectName.getKeyProperty("name"));
            }
        }
    }
}

