/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.WebModuleMBean;
import jeus.management.j2ee.servlet.ContextGroupMoMBean;
import jeus.management.j2ee.servlet.ThreadPoolMoMBean;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.management.j2ee.servlet.WebListenerMoMBean;
import jeus.util.JeusRuntimeException;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Command;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.HelpCommand;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.ServletEngineGroup;
import jeus.util.message.JeusMessage_JMX;

public class WCClearStatCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container where servlet engine is located", "use container.name property or apply to all containers");
    private Argument contextGroup = new Argument("ContextGroup", "context group name");
    private OptionalArgument context = new OptionalArgument("Context", "context name");
    private OptionalArgument servlet = new OptionalArgument("Servlet", "servlet name");

    public WCClearStatCommand() {
        super("clrstat", "reset statistics of request count and processing time");
        this.servlet.setPreArg((Argument)this.context);
        this.context.setPreArg(this.contextGroup);
        this.registerArgument((Argument)this.conOption);
        this.registerArgument(this.contextGroup);
        this.registerArgument((Argument)this.context);
        this.registerArgument((Argument)this.servlet);
    }

    public void run(PrintStream out) throws Exception {
        HashMap<Object, Object> webEngineMbeanMap = new HashMap();
        if (this.conOption.isSet()) {
            WebEngineMoMBean webEngine = null;
            String containerName = null;
            try {
                containerName = this.conOption.getValue();
                webEngine = this.getWebEngine(containerName);
            }
            catch (Exception e) {
                out.println("[" + containerName + "] container is downed or not created.");
                out.println("");
                return;
            }
            webEngineMbeanMap.put(containerName, webEngine);
        } else {
            webEngineMbeanMap = ServletEngineGroup.getCachedWebEngineMoMBeanMap();
        }
        if (webEngineMbeanMap == null || webEngineMbeanMap.size() == 0) {
            throw new JeusImproperCommanderException("There is no running container.");
        }
        String ctxgrpName = null;
        String ctxName = null;
        String servletName = null;
        if (this.contextGroup.isSet()) {
            ctxgrpName = this.contextGroup.getValue();
        }
        if (this.context.isSet()) {
            ctxName = this.context.getValue();
        }
        if (this.servlet.isSet()) {
            servletName = this.servlet.getValue();
        }
        if (!this.contextGroup.isSet()) {
            HelpCommand.printCommandHelp((PrintStream)out, (Command)this);
            return;
        }
        WebEngineMoMBean webMBean = null;
        String containerName = null;
        for (Map.Entry<Object, Object> conNamdAndwebMBean : webEngineMbeanMap.entrySet()) {
            ContextGroupMoMBean mbean;
            ObjectName[] ctxgroups;
            block19: {
                webMBean = (WebEngineMoMBean)conNamdAndwebMBean.getValue();
                containerName = (String)conNamdAndwebMBean.getKey();
                ctxgroups = null;
                try {
                    ctxgroups = JMXUtility.queryMBean(this.utility, containerName, "JeusService", "ContextGroup", ctxgrpName, null, null);
                }
                catch (JeusRuntimeException e) {
                    if (e.getMessageNumber() != JeusMessage_JMX.JMX_59) break block19;
                    out.println("Not acceptable input * = : \" \"<white space>\" ? , ");
                    out.println("");
                    return;
                }
            }
            out.println("");
            out.println("< ContainerName : " + containerName + " >");
            if (ctxgroups == null || ctxgroups.length == 0) {
                out.println("ContextGroup not found : " + ctxgrpName);
                continue;
            }
            if (this.contextGroup.isSet() && !this.context.isSet() && !this.servlet.isSet()) {
                if (!webMBean.clearStatContextGroup(ctxgrpName)) {
                    out.println("clrstat command failed : ContextGroup = " + ctxgrpName);
                    continue;
                }
                mbean = JMXUtility.getProxy(this.utility, ctxgroups[0], ContextGroupMoMBean.class, false);
                this.clearListenerStats(mbean);
                out.println("clrstat sucessful");
                continue;
            }
            if (this.contextGroup.isSet() && this.context.isSet() && !this.servlet.isSet()) {
                mbean = JMXUtility.getProxy(this.utility, ctxgroups[0], ContextGroupMoMBean.class, false);
                if (!mbean.clearStatContext(ctxName)) {
                    out.println("clrstat command failed : ContextGroup = " + ctxgrpName + ", Context = " + ctxName);
                    continue;
                }
                out.println("clrstat sucessful");
                continue;
            }
            if (!this.contextGroup.isSet() || !this.context.isSet() || !this.servlet.isSet()) continue;
            ObjectName[] ctxs = JMXUtility.queryMBean(this.utility, containerName, "WebModule", null, ctxName, null, null);
            if (ctxs == null || ctxs.length == 0) {
                out.println("Context not found : " + ctxName);
                return;
            }
            WebModuleMBean mbean2 = JMXUtility.getProxy(this.utility, ctxs[0], WebModuleMBean.class, false);
            if (!mbean2.clearStatServlet(servletName)) {
                out.println("clrstat command failed : ContextGroup = " + ctxgrpName + ", Context = " + ctxName + ", Servlet = " + servletName);
                return;
            }
            out.println("clrstat sucessful");
        }
    }

    private void clearListenerStats(ContextGroupMoMBean group) throws Exception {
        String[] listeners = group.getWebListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            ObjectName listener = new ObjectName(listeners[i]);
            WebListenerMoMBean listenerMBean = JMXUtility.getProxy(this.utility, listener, WebListenerMoMBean.class, false);
            String[] tpoolNames = listenerMBean.getThreadPools();
            if (tpoolNames == null) continue;
            for (int j = 0; j < tpoolNames.length; ++j) {
                ObjectName tpool = new ObjectName(tpoolNames[j]);
                ThreadPoolMoMBean tpoolMBean = JMXUtility.getProxy(this.utility, tpool, ThreadPoolMoMBean.class, false);
                tpoolMBean.clearStats();
            }
        }
    }
}

