/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.MBeanServerConnection;
import jeus.management.JMXUtility;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.ToggleArguments;
import jeus.util.console.command.JeusMBeanCommand;

public class WCEngListCommand
extends JeusMBeanCommand {
    private ArrayList containerNameList = new ArrayList();
    private ArrayList currentContainerNameList = new ArrayList();
    private HashMap engineList = new HashMap();
    private HashMap currentEngineList = new HashMap();
    private String nodeName;
    private boolean singleMode;
    private Option allEngines;
    private Option currentEngines;

    public WCEngListCommand(MBeanServerConnection utility, String nodeName, boolean singleMode) {
        super("englist", "list all servlet engine list");
        this.utility = utility;
        this.nodeName = nodeName;
        this.singleMode = singleMode;
        this.allEngines = new Option("all", "all servlet engines", false);
        this.currentEngines = new Option("current", "currently selected servlet engines", false);
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.allEngines, this.currentEngines}));
    }

    public void initialize(ArrayList containerNameList, ArrayList currentContainerNameList, HashMap engineList, HashMap currentEngineList) {
        this.containerNameList = containerNameList;
        this.currentContainerNameList = currentContainerNameList;
        this.engineList = engineList;
        this.currentEngineList = currentEngineList;
    }

    public void run(PrintStream out) throws Exception {
        out.println("");
        out.println(" ** " + this.allEngines.getName() + " servlet engine list ** ");
        if (this.currentEngines.isSet()) {
            out.println("  * total " + this.currentContainerNameList.size() + " servlet engines selected");
            for (String key : this.currentContainerNameList) {
                out.println("  - " + JMXUtility.getNameValue(((WebEngineMoMBean)this.currentEngineList.get(key)).getObjectName()));
            }
        } else {
            out.println("  * total " + this.containerNameList.size() + " servlet engines");
            Iterator it = this.containerNameList.iterator();
            int i = 0;
            while (it.hasNext()) {
                String key = (String)it.next();
                out.println("  - (" + (i + 1) + ") " + JMXUtility.getNameValue(((WebEngineMoMBean)this.engineList.get(key)).getObjectName()));
                ++i;
            }
        }
        out.println("");
    }
}

