/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import jeus.util.console.Argument;
import jeus.util.console.MultipleArgumentedOption;
import jeus.util.console.Option;
import jeus.util.console.ToggleArguments;
import jeus.util.console.command.JeusMBeanCommand;

public class WCEngSelectCommand
extends JeusMBeanCommand {
    private boolean singleMode;
    private String nodeName;
    private ArrayList containerNameList = new ArrayList();
    private ArrayList currentContainerNameList = new ArrayList();
    private HashMap engineList = new HashMap();
    private HashMap currentEngineList = new HashMap();
    private Option allEngines;
    private MultipleArgumentedOption selectedEngines;

    public WCEngSelectCommand(MBeanServerConnection utility, String nodeName, boolean singleMode) {
        super("engselect", "select servlet engines");
        this.utility = utility;
        this.nodeName = nodeName;
        this.singleMode = singleMode;
        this.allEngines = new Option("all", "select all servlet engines", false);
        this.selectedEngines = new MultipleArgumentedOption("-s", "engine-number", "space-seperated list of engines");
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.allEngines, this.selectedEngines}));
    }

    public void initialize(ArrayList containerNameList, ArrayList currentContainerNameList, HashMap engineList, HashMap currentEngineList) {
        this.containerNameList = containerNameList;
        this.currentContainerNameList = currentContainerNameList;
        this.engineList = engineList;
        this.currentEngineList = currentEngineList;
    }

    public void run(PrintStream out) throws Exception {
        if (this.allEngines.isSet()) {
            this.currentEngineList = (HashMap)this.engineList.clone();
        } else {
            this.currentEngineList.clear();
            this.currentContainerNameList.clear();
            StringTokenizer engineNums = new StringTokenizer(this.selectedEngines.getValue());
            while (engineNums.hasMoreTokens()) {
                String num = engineNums.nextToken();
                try {
                    int ind = Integer.parseInt(num);
                    if (ind < 1 || ind > this.engineList.size()) {
                        out.println("   invalid engine numer. ignored : " + ind);
                        return;
                    }
                    String cname = (String)this.containerNameList.get(ind - 1);
                    this.currentContainerNameList.add(cname);
                    this.currentEngineList.put(cname, this.engineList.get(cname));
                }
                catch (Exception e) {
                    out.println("   wrong engine numer. ignored : " + num);
                }
            }
        }
    }
}

