/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.servlet.ContextGroupMoMBean;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Command;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.ToggleArguments;
import jeus.util.console.command.HelpCommand;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.ServletEngineGroup;

public class WCWebToBCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container where servlet engine is located", "use container.name property or apply to all containers");
    private ArgumentedOption suspend = new ArgumentedOption("s", "listener-id", "sustpend a webtob-listener");
    private ArgumentedOption resume = new ArgumentedOption("r", "listener-id", "resume a suspended webtob-listener");

    public WCWebToBCommand() {
        super("webtob", "resume/suspend a webtob-listener");
        this.registerArgument((Argument)this.conOption);
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.suspend, this.resume}));
    }

    public void run(PrintStream out) throws Exception {
        String containerName;
        HashMap<Object, Object> webEngineMbeanMap = new HashMap();
        if (this.conOption.isSet()) {
            WebEngineMoMBean webEngine = null;
            containerName = null;
            try {
                containerName = this.conOption.getValue();
                webEngine = this.getWebEngine(containerName);
            }
            catch (Exception e) {
                out.println("[" + containerName + "] container is downed or not created.");
                out.println("");
                return;
            }
            webEngineMbeanMap.put(containerName, webEngine);
        } else {
            webEngineMbeanMap = ServletEngineGroup.getCachedWebEngineMoMBeanMap();
        }
        if (webEngineMbeanMap == null || webEngineMbeanMap.size() == 0) {
            throw new JeusImproperCommanderException("There is no running container.");
        }
        String targetWebtobName = null;
        if (this.suspend.isSet()) {
            targetWebtobName = this.suspend.getValue();
        } else if (this.resume.isSet()) {
            targetWebtobName = this.resume.getValue();
        } else {
            out.println("The command misses the following required argument : <-r/-s> listener-id");
            HelpCommand.printCommandHelp((PrintStream)out, (Command)this);
            return;
        }
        containerName = null;
        for (Map.Entry<Object, Object> conNamdAndwebMBean : webEngineMbeanMap.entrySet()) {
            containerName = (String)conNamdAndwebMBean.getKey();
            ContextGroupMoMBean mbean = this.findContextGroupMoByWebtobListenerName(containerName, targetWebtobName, out);
            if (mbean == null) {
                out.println("webtob-listener not found. listener-id = " + targetWebtobName);
                continue;
            }
            if (this.suspend.isSet()) {
                if (mbean.suspendWebtobListener(targetWebtobName)) {
                    out.println("Success to suspend [" + this.suspend.getValue() + "] listener.");
                    continue;
                }
                out.println("Fail to suspend [" + this.suspend.getValue() + "] listener.");
                continue;
            }
            if (!this.resume.isSet()) continue;
            if (mbean.resumeWebtobListener(targetWebtobName)) {
                out.println("Sussess to resume [" + this.resume.getValue() + "] listener.");
                continue;
            }
            out.println("Fail to resume [" + this.resume.getValue() + "] listener.");
        }
    }

    private ContextGroupMoMBean findContextGroupMoByWebtobListenerName(String containerName, String targetWebtobName, PrintStream out) throws Exception {
        out.println("");
        out.println("< ContainerName : " + containerName + " >");
        ObjectName[] ctxgroups = JMXUtility.queryMBean(this.utility, containerName, "JeusService", "ContextGroup", null, null, null);
        if (ctxgroups == null || ctxgroups.length == 0) {
            return null;
        }
        for (int i = 0; i < ctxgroups.length; ++i) {
            ContextGroupMoMBean mbean = JMXUtility.getProxy(this.utility, ctxgroups[i], ContextGroupMoMBean.class, false);
            String[] listenerNames = mbean.getWebListeners();
            if (listenerNames == null || listenerNames.length == 0) {
                return null;
            }
            for (int j = 0; j < listenerNames.length; ++j) {
                String listenerId = JMXUtility.getNameValue(new ObjectName(listenerNames[j]));
                if (!targetWebtobName.equals(listenerId)) continue;
                return mbean;
            }
        }
        return null;
    }
}

