/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.group;

import java.io.IOException;
import java.util.Vector;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JeusRuntimeException;
import jeus.util.console.Command;
import jeus.util.console.Group;

public class JeusGroup
extends Group {
    private static J2EEServerMBean[] j2eeServers = null;

    public JeusGroup(String name, String aliaseName) {
        super(name, aliaseName);
    }

    public void notifyToChangeProperty(String propertyKey) {
        if (propertyKey.equals("container.name")) {
            try {
                this.setJ2eeServerMBeans();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setJ2eeServerMBeans() throws IllegalJeusSystemNameException, IOException {
        String[] containerNames = Command.getListProperty((String)"container.name");
        Vector<J2EEServerMBean> j2eeServerVector = new Vector<J2EEServerMBean>();
        for (int i = 0; i < containerNames.length; ++i) {
            try {
                j2eeServerVector.add(JMXUtility.getProxy(utility, JMXUtility.queryJ2EEServer(utility, containerNames[i]), J2EEServerMBean.class, false));
                continue;
            }
            catch (JeusRuntimeException e) {
                // empty catch block
            }
        }
        j2eeServers = j2eeServerVector.toArray(new J2EEServerMBean[j2eeServerVector.size()]);
    }

    public static J2EEServerMBean[] getCachedJ2EEServerMBeans() throws IOException, IllegalJeusSystemNameException {
        String[] containerNames = Command.getListProperty((String)"container.name");
        if (containerNames == null) {
            j2eeServers = JMXUtility.getProxy(utility, JMXUtility.queryJ2EEServers(utility, nodeName), J2EEServerMBean.class, false);
        } else {
            Vector runningConList = JMXUtility.getContainerNames(utility, nodeName);
            Vector<J2EEServerMBean> j2eeServerVector = new Vector<J2EEServerMBean>();
            for (int i = 0; i < containerNames.length; ++i) {
                String containerName = containerNames[i];
                if (!runningConList.contains(containerName)) continue;
                try {
                    ObjectName j2eeServerObjectName = JMXUtility.queryJ2EEServer(utility, containerName);
                    j2eeServerVector.add(JMXUtility.getProxy(utility, j2eeServerObjectName, J2EEServerMBean.class, false));
                    continue;
                }
                catch (JeusRuntimeException e) {
                    // empty catch block
                }
            }
            j2eeServers = j2eeServerVector.toArray(new J2EEServerMBean[j2eeServerVector.size()]);
        }
        return j2eeServers;
    }
}

