/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputValidation;
import java.io.OptionalDataException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import jeus.util.io.Buffer;
import jeus.util.io.ObjectOutputStream;
import jeus.util.io.ObjectStreamClass;
import jeus.util.io.ObjectStreamField;
import jeus.util.io.ValidationCallback;

public class ObjectInputStream
extends java.io.ObjectInputStream {
    private static boolean useSystemClassLoader;
    private static Class cl;
    static boolean inlog;
    private static boolean logTime;
    private static PrintWriter pw;
    private static Buffer out;
    private static int BLOCK;
    private InputStream in;
    private int count;
    private boolean blockDataMode;
    private byte[] buf;
    private int bufpos;
    private int bufsize;
    private DataInputStream dis;
    private IOException abortIOException = null;
    private ClassNotFoundException abortClassNotFoundException = null;
    private Object currentObject;
    private ObjectStreamClass currentClassDesc;
    private Class currentClass;
    private Object currentGetFields;
    private byte[] data = new byte[1024];
    private char[] cdata = new char[50];
    private static final int CDATA_MAX_LEN = 1000;
    private StringBuffer sbuf = new StringBuffer();
    ObjectStreamClass[] classdesc;
    Class[] classes;
    int spClass;
    private ArrayList wireHandle2Object;
    private int nextWireOffset;
    private ArrayList callbacks;
    private int recursionDepth;
    private byte currCode;
    boolean enableResolve;
    private boolean enableSubclassImplementation;
    private Object[] readObjectArglist = new Object[]{this};

    public static synchronized void log(String msg, boolean dump) {
        try {
            if (logTime) {
                pw.print(System.currentTimeMillis());
            }
            pw.print(Thread.currentThread());
            pw.println(msg);
        }
        catch (Throwable e) {
            e.printStackTrace();
            inlog = false;
            return;
        }
        if (dump) {
            System.out.println("------------------------------------------------");
            try {
                System.out.println(out.toString("ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            System.out.println("------------------------------------------------");
        }
        if (out.getPosition() > BLOCK) {
            out.reset();
        }
    }

    public ObjectInputStream(InputStream in) throws IOException, StreamCorruptedException {
        this.in = in;
        this.buf = new byte[8];
        this.dis = new DataInputStream(this);
        this.readStreamHeader();
        this.resetStream();
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.enableSubclassImplementation = true;
    }

    protected Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        Object obj = this.readObject(true);
        if (inlog) {
            if (obj instanceof ObjectStreamClass) {
                ObjectStreamClass clazz = (ObjectStreamClass)obj;
                ObjectInputStream.log("[OIS/readObjectOverride] final return object(OSC) : " + clazz.getName(), false);
            } else {
                ObjectInputStream.log("[OIS/readObjectOverride] final return object(obj) : " + (obj == null ? "null" : obj.getClass().toString()), false);
            }
        }
        return obj;
    }

    /*
     * Exception decompiling
     */
    private final Object readObject(boolean requireLocalClass) throws OptionalDataException, ClassNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultReadObject");
        }
        ObjectStreamField[] fields = this.currentClassDesc.getFieldsNoCopy();
        if (fields.length > 0) {
            boolean prevmode = this.setBlockData(false);
            this.inputClassFields(this.currentObject, this.currentClass, fields);
            this.setBlockData(prevmode);
        }
    }

    public synchronized void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        if (this.recursionDepth == 0) {
            throw new NotActiveException("readObject not Active");
        }
        if (obj == null) {
            throw new InvalidObjectException("Null is not a valid callback object");
        }
        ValidationCallback cb = new ValidationCallback(obj, prio);
        if (this.callbacks == null) {
            this.callbacks = new ArrayList();
        }
        if (this.callbacks.isEmpty() || ((ValidationCallback)this.callbacks.get((int)(this.callbacks.size() - 1))).priority >= prio) {
            this.callbacks.add(cb);
            return;
        }
        int size = this.callbacks.size();
        for (int i = 0; i < size; ++i) {
            ValidationCallback curr = (ValidationCallback)this.callbacks.get(i);
            if (curr.priority > prio) continue;
            this.callbacks.add(i, cb);
            break;
        }
    }

    private void doValidations() throws InvalidObjectException {
        if (this.callbacks == null) {
            return;
        }
        int size = this.callbacks.size();
        for (int i = 0; i < size; ++i) {
            ValidationCallback curr = (ValidationCallback)this.callbacks.get(i);
            curr.callback.validateObject();
        }
        this.callbacks.clear();
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        ClassLoader loader = ObjectInputStream.latestUserDefinedLoader();
        String name = v.getName();
        return Class.forName(name, false, loader);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader loader = ObjectInputStream.latestUserDefinedLoader();
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            classObjs[i] = Class.forName(interfaces[i], false, loader);
        }
        try {
            return Proxy.getProxyClass(loader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    public static native ClassLoader latestUserDefinedLoader0(Class var0);

    private static ClassLoader latestUserDefinedLoader() throws ClassNotFoundException {
        try {
            if (useSystemClassLoader) {
                return ClassLoader.getSystemClassLoader();
            }
            if (cl == null) {
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                cl = loader.loadClass("java.io.ObjectInputStream");
            }
            return ObjectInputStream.latestUserDefinedLoader0(cl);
        }
        catch (Exception e) {
            throw new ClassNotFoundException();
        }
    }

    private Class loadClass0(Class cl, String classname) throws ClassNotFoundException {
        ClassLoader loader = cl != null ? cl.getClassLoader() : ObjectInputStream.latestUserDefinedLoader();
        return Class.forName(classname, false, loader);
    }

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }

    protected boolean enableResolveObject(boolean enable) throws SecurityException {
        boolean previous = this.enableResolve;
        if (enable) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(SUBSTITUTION_PERMISSION);
            }
            this.enableResolve = true;
        } else {
            this.enableResolve = false;
        }
        return previous;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        short incoming_magic = 0;
        short incoming_version = 0;
        try {
            incoming_magic = this.readShort();
            incoming_version = this.readShort();
        }
        catch (EOFException e) {
            throw new StreamCorruptedException("Caught EOFException while reading the stream header");
        }
        if (incoming_magic != -21267) {
            throw new StreamCorruptedException("InputStream does not contain a serialized object");
        }
        if (incoming_version != 5) {
            throw new StreamCorruptedException("Version Mismatch, Expected 5 and got " + incoming_version);
        }
    }

    protected ObjectStreamClass readClassDescriptor2() throws IOException, ClassNotFoundException {
        String classname = this.readUTF();
        if (inlog) {
            ObjectInputStream.log("[OIS/readClassDescriptor2] classname : " + classname, false);
        }
        long hash = this.readLong();
        ObjectStreamClass v = new ObjectStreamClass(classname, hash);
        v.read(this);
        return v;
    }

    private ObjectStreamClass inputClassDescriptor() throws IOException, InvalidClassException, ClassNotFoundException {
        Class aclass;
        ObjectStreamClass copydesc = new ObjectStreamClass(null, 0L);
        int wireoffset = this.assignWireOffset(copydesc);
        ObjectStreamClass desc = this.readClassDescriptor2();
        copydesc.lightCopy(desc);
        boolean prevMode = this.setBlockData(true);
        try {
            aclass = this.resolveClass(copydesc);
        }
        catch (ClassNotFoundException e) {
            if (inlog) {
                ObjectInputStream.log("------class not found exception occurred for " + copydesc, true);
            }
            aclass = null;
            copydesc.pendingException = e;
        }
        this.skipToEndOfBlockData();
        prevMode = this.setBlockData(prevMode);
        copydesc.setClass(aclass);
        ObjectStreamClass superdesc = (ObjectStreamClass)this.readObject();
        copydesc.setSuperclass(superdesc);
        return copydesc;
    }

    private ObjectStreamClass inputProxyClassDescriptor() throws IOException, InvalidClassException, ClassNotFoundException {
        Class cl;
        ObjectStreamClass v = new ObjectStreamClass("", 0L);
        int wireoffset = this.assignWireOffset(v);
        int numInterfaces = this.readInt();
        String[] interfaces = new String[numInterfaces];
        for (int i = 0; i < numInterfaces; ++i) {
            interfaces[i] = this.readUTF();
        }
        boolean prevMode = this.setBlockData(true);
        try {
            cl = this.resolveProxyClass(interfaces);
        }
        catch (ClassNotFoundException e) {
            cl = null;
            v.pendingException = e;
        }
        this.skipToEndOfBlockData();
        prevMode = this.setBlockData(prevMode);
        v.initProxyClassDesc(cl);
        v.setClass(cl);
        ObjectStreamClass superdesc = (ObjectStreamClass)this.readObject();
        v.setSuperclass(superdesc);
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int inputArray(boolean requireLocalClass) throws IOException, ClassNotFoundException {
        ObjectStreamClass v = (ObjectStreamClass)this.readObject();
        Class arrayclass = v.forClass();
        if (arrayclass == null && requireLocalClass) {
            throw v.pendingException;
        }
        if (cl == null) {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            cl = loader.loadClass("java.io.ObjectInputStream");
        }
        int length = this.readInt();
        this.currentObject = arrayclass == null ? null : this.getArray(v, length);
        int wireoffset = this.assignWireOffset(this.currentObject);
        if (arrayclass != null && arrayclass.getComponentType().isPrimitive()) {
            Class<?> type = arrayclass.getComponentType();
            int offset = this.data.length;
            int buflen = this.data.length;
            if (type == Boolean.TYPE) {
                boolean[] array = (boolean[])this.currentObject;
                for (int i = 0; i < length; ++i) {
                    if (offset >= buflen) {
                        int readlen = Math.min(length - i, buflen);
                        this.readFully(this.data, 0, readlen);
                        offset = 0;
                    }
                    array[i] = this.data[offset] != 0;
                    ++offset;
                }
                return wireoffset;
            } else if (type == Byte.TYPE) {
                int readlen;
                byte[] array = (byte[])this.currentObject;
                for (int ai = 0; ai < length; ai += readlen) {
                    readlen = Math.min(length - ai, buflen);
                    this.readFully(this.data, 0, readlen);
                    System.arraycopy(this.data, 0, array, ai, readlen);
                }
                return wireoffset;
            } else if (type == Short.TYPE) {
                short[] array = (short[])this.currentObject;
                for (int i = 0; i < length; ++i) {
                    if (offset > buflen - 2) {
                        int readlen = Math.min((length - i) * 2, buflen);
                        this.readFully(this.data, 0, readlen);
                        offset = 0;
                    }
                    array[i] = (short)(((this.data[offset] & 0xFF) << 8) + ((this.data[offset + 1] & 0xFF) << 0));
                    offset += 2;
                }
                return wireoffset;
            } else if (type == Integer.TYPE) {
                int[] array = (int[])this.currentObject;
                for (int i = 0; i < length; ++i) {
                    if (offset > buflen - 4) {
                        int readlen = Math.min(length - i << 2, buflen);
                        this.readFully(this.data, 0, readlen);
                        offset = 0;
                    }
                    array[i] = ((this.data[offset] & 0xFF) << 24) + ((this.data[offset + 1] & 0xFF) << 16) + ((this.data[offset + 2] & 0xFF) << 8) + ((this.data[offset + 3] & 0xFF) << 0);
                    offset += 4;
                }
                return wireoffset;
            } else if (type == Long.TYPE) {
                long[] array = (long[])this.currentObject;
                for (int i = 0; i < length; ++i) {
                    if (offset > buflen - 8) {
                        int readlen = Math.min(length - i << 3, buflen);
                        this.readFully(this.data, 0, readlen);
                        offset = 0;
                    }
                    int upper = ((this.data[offset] & 0xFF) << 24) + ((this.data[offset + 1] & 0xFF) << 16) + ((this.data[offset + 2] & 0xFF) << 8) + ((this.data[offset + 3] & 0xFF) << 0);
                    int lower = ((this.data[offset + 4] & 0xFF) << 24) + ((this.data[offset + 5] & 0xFF) << 16) + ((this.data[offset + 6] & 0xFF) << 8) + ((this.data[offset + 7] & 0xFF) << 0);
                    array[i] = ((long)upper << 32) + ((long)lower & 0xFFFFFFFFL);
                    offset += 8;
                }
                return wireoffset;
            } else if (type == Float.TYPE) {
                int n;
                float[] array = (float[])this.currentObject;
                for (int i = 0; i < length; i += n) {
                    n = Math.min(length - i, buflen >> 2);
                    this.readFully(this.data, 0, n << 2);
                    ObjectInputStream.bytesToFloats(this.data, 0, array, i, n);
                }
                return wireoffset;
            } else if (type == Double.TYPE) {
                int n;
                double[] array = (double[])this.currentObject;
                for (int i = 0; i < length; i += n) {
                    n = Math.min(length - i, buflen >> 3);
                    this.readFully(this.data, 0, n << 3);
                    ObjectInputStream.bytesToDoubles(this.data, 0, array, i, n);
                }
                return wireoffset;
            } else {
                if (type != Character.TYPE) throw new InvalidClassException(arrayclass.getName());
                char[] array = (char[])this.currentObject;
                for (int i = 0; i < length; ++i) {
                    if (offset > buflen - 2) {
                        int readlen = Math.min((length - i) * 2, buflen);
                        this.readFully(this.data, 0, readlen);
                        offset = 0;
                    }
                    array[i] = (char)(((this.data[offset] & 0xFF) << 8) + ((this.data[offset + 1] & 0xFF) << 0));
                    offset += 2;
                }
            }
            return wireoffset;
        } else {
            Object[] array = (Object[])this.currentObject;
            boolean requiresLocalClass = arrayclass != null;
            for (int i = 0; i < length; ++i) {
                Object obj = this.readObject(requiresLocalClass);
                if (array == null) continue;
                array[i] = obj;
            }
        }
        return wireoffset;
    }

    private Object getArray(ObjectStreamClass desc, int len) {
        Object array = null;
        Class<?> ccl = null;
        Class cl = desc.forClass();
        if (cl != null) {
            ccl = cl.getComponentType();
            array = Array.newInstance(ccl, len);
        }
        return array;
    }

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int inputObject(boolean requireLocalClass) throws IOException, ClassNotFoundException {
        int numAncestors;
        int spBase;
        Class currclass;
        ObjectStreamClass currdesc;
        int handle = -1;
        this.currentClassDesc = (ObjectStreamClass)this.readObject();
        this.currentClass = this.currentClassDesc.forClass();
        if (this.currentClass == null && requireLocalClass) {
            throw this.currentClassDesc.pendingException;
        }
        if (requireLocalClass) {
            this.currentClassDesc.verifyInstanceDeserialization();
        }
        if (this.currentClassDesc.isExternalizable()) {
            try {
                this.currentObject = this.currentClass == null ? null : ObjectInputStream.allocateNewObject(this.currentClass, this.currentClass);
                handle = this.assignWireOffset(this.currentObject);
                boolean prevmode = this.blockDataMode;
                try {
                    if (this.currentClassDesc.hasExternalizableBlockDataMode()) {
                        prevmode = this.setBlockData(true);
                    }
                    if (this.currentObject == null) return handle;
                    Externalizable ext = (Externalizable)this.currentObject;
                    ext.readExternal(this);
                    return handle;
                }
                finally {
                    if (this.currentClassDesc.hasExternalizableBlockDataMode()) {
                        this.skipToEndOfBlockData();
                        this.setBlockData(prevmode);
                    }
                }
            }
            catch (NoSuchMethodError e) {
                throw new InvalidClassException(this.currentClass.getName() + "Missing no-arg constructor for class");
            }
            catch (IllegalAccessException e) {
                throw new InvalidClassException(this.currentClass.getName(), "IllegalAccessException");
            }
            catch (InstantiationException e) {
                throw new InvalidClassException(this.currentClass.getName(), "InstantiationException");
            }
        }
        if (this.currentClassDesc.ancestors == null) {
            currdesc = this.currentClassDesc;
            currclass = this.currentClass;
            spBase = this.spClass;
            currdesc = this.currentClassDesc;
            currclass = this.currentClass;
            while (currdesc != null) {
                Class cl;
                Class cc = currdesc.forClass();
                for (cl = currclass; cl != null && cc != cl; cl = cl.getSuperclass()) {
                }
                if (this.spClass >= this.classes.length) {
                    this.growClassStacks();
                }
                if (cl == null) {
                    this.classdesc[this.spClass] = currdesc;
                    this.classes[this.spClass] = null;
                } else {
                    this.classdesc[this.spClass] = currdesc;
                    this.classes[this.spClass] = cl;
                    currclass = cl.getSuperclass();
                }
                ++this.spClass;
                currdesc = currdesc.superclass;
            }
            if (currclass != null) {
                while (Serializable.class.isAssignableFrom(currclass)) {
                    currclass = currclass.getSuperclass();
                }
            }
            numAncestors = this.spClass - spBase;
            this.currentClassDesc.ancestors = new Class[numAncestors + 1];
            for (int i = 0; i < numAncestors; ++i) {
                this.currentClassDesc.ancestors[i] = this.classes[spBase + i];
            }
            this.currentClassDesc.ancestors[numAncestors] = currclass;
            this.spClass = spBase;
        }
        numAncestors = this.currentClassDesc.ancestors.length - 1;
        currclass = this.currentClassDesc.ancestors[numAncestors];
        try {
            this.currentObject = this.currentClass == null ? null : ObjectInputStream.allocateNewObject(this.currentClass, currclass);
        }
        catch (NoSuchMethodError e) {
            throw new InvalidClassException(currclass.getName() + "Missing no-arg constructor for class");
        }
        catch (IllegalAccessException e) {
            throw new InvalidClassException(currclass.getName(), "IllegalAccessException");
        }
        catch (InstantiationException e) {
            throw new InvalidClassException(currclass.getName(), "InstantiationException");
        }
        handle = this.assignWireOffset(this.currentObject);
        spBase = this.spClass;
        currdesc = this.currentClassDesc;
        while (currdesc != null) {
            if (this.spClass >= this.classes.length) {
                this.growClassStacks();
            }
            this.classdesc[this.spClass] = currdesc;
            this.classes[this.spClass] = this.currentClassDesc.ancestors[this.spClass - spBase];
            ++this.spClass;
            currdesc = currdesc.superclass;
        }
        try {
            --this.spClass;
            while (this.spClass >= spBase) {
                this.currentClassDesc = this.classdesc[this.spClass];
                this.currentClass = this.classes[this.spClass];
                this.setBlockData(true);
                if (this.classes[this.spClass] != null) {
                    ObjectStreamClass localDesc = this.currentClassDesc.localClassDescriptor();
                    if (!this.invokeObjectReader(this.currentObject)) {
                        this.defaultReadObject();
                    }
                } else {
                    ObjectStreamField[] fields = this.currentClassDesc.getFieldsNoCopy();
                    if (fields.length > 0) {
                        boolean prevmode = this.setBlockData(false);
                        this.inputClassFields(null, this.currentClass, fields);
                        this.setBlockData(prevmode);
                    }
                }
                if (this.currentClassDesc.hasWriteObject()) {
                    this.skipToEndOfBlockData();
                }
                this.setBlockData(false);
                --this.spClass;
            }
            return handle;
        }
        finally {
            this.spClass = spBase;
        }
    }

    private void growClassStacks() {
        int newlen = this.classes.length * 2;
        Class[] newclasses = new Class[newlen];
        ObjectStreamClass[] newclassdesc = new ObjectStreamClass[newlen];
        System.arraycopy(this.classes, 0, newclasses, 0, this.classes.length);
        System.arraycopy(this.classdesc, 0, newclassdesc, 0, this.classes.length);
        this.classes = newclasses;
        this.classdesc = newclassdesc;
    }

    private void skipToEndOfBlockData() throws IOException, ClassNotFoundException {
        if (!this.blockDataMode) {
            return;
        }
        block5: while (true) {
            if (this.count > 0) {
                this.skip(this.count);
                continue;
            }
            switch (this.peekCode()) {
                case -1: {
                    return;
                }
                case 119: 
                case 122: {
                    this.refill();
                    continue block5;
                }
                case 120: {
                    this.readCode();
                    return;
                }
            }
            this.readObject(false);
        }
    }

    private void resetStream() throws IOException {
        int i;
        if (this.wireHandle2Object == null) {
            this.wireHandle2Object = new ArrayList();
        } else {
            this.wireHandle2Object.clear();
        }
        this.nextWireOffset = 0;
        if (this.classes == null) {
            this.classes = new Class[20];
        } else {
            for (i = 0; i < this.classes.length; ++i) {
                this.classes[i] = null;
            }
        }
        if (this.classdesc == null) {
            this.classdesc = new ObjectStreamClass[20];
        } else {
            for (i = 0; i < this.classdesc.length; ++i) {
                this.classdesc[i] = null;
            }
        }
        this.spClass = 0;
        this.setBlockData(true);
        if (this.callbacks != null) {
            this.callbacks.clear();
        }
    }

    private int assignWireOffset(Object obj) throws IOException {
        this.wireHandle2Object.add(obj);
        if (++this.nextWireOffset != this.wireHandle2Object.size()) {
            throw new StreamCorruptedException("Elements not assigned in order");
        }
        return this.nextWireOffset - 1;
    }

    private byte peekCode() throws IOException, StreamCorruptedException {
        while (this.currCode == 0) {
            int newcode = this.in.read();
            if (newcode < 0) {
                throw new EOFException("Expecting code");
            }
            this.currCode = (byte)newcode;
            if (this.currCode < 112 || this.currCode > 126) {
                throw new StreamCorruptedException("Type code out of range, is " + this.currCode);
            }
            if (this.currCode != 121) continue;
            if (this.recursionDepth != 0 || this.currentObject != null || this.currentClassDesc != null) {
                throw new StreamCorruptedException("Illegal stream state for reset");
            }
            this.resetStream();
            this.currCode = 0;
        }
        return this.currCode;
    }

    private byte readCode() throws IOException, StreamCorruptedException {
        byte tc = this.peekCode();
        this.currCode = 0;
        return tc;
    }

    private void pushbackCode(byte code) {
        this.currCode = code;
    }

    private boolean setBlockData(boolean mode) throws IOException {
        if (this.blockDataMode == mode) {
            return mode;
        }
        if (this.blockDataMode && this.count > 0) {
            throw new StreamCorruptedException("Unread data");
        }
        this.count = mode ? 0 : -1;
        this.bufpos = 0;
        this.bufsize = 0;
        this.blockDataMode = mode;
        return !mode;
    }

    public int read() throws IOException {
        if (this.blockDataMode) {
            while (this.count == 0) {
                this.refill();
            }
            if (this.count < 0) {
                return -1;
            }
            try {
                int pos = this.bufferData(1);
                return this.buf[pos] & 0xFF;
            }
            catch (EOFException e) {
                return -1;
            }
        }
        return this.in.read();
    }

    private void refill() throws IOException {
        byte code;
        this.count = -1;
        try {
            code = this.peekCode();
        }
        catch (EOFException e) {
            return;
        }
        if (code == 119) {
            code = this.readCode();
            int c = this.in.read();
            if (c < 0) {
                throw new StreamCorruptedException("EOF expecting count");
            }
            this.count = c & 0xFF;
        } else if (code == 122) {
            int b0;
            int b1;
            int b2;
            code = this.readCode();
            int b3 = this.in.read();
            if ((b3 | (b2 = this.in.read()) | (b1 = this.in.read()) | (b0 = this.in.read())) < 0) {
                throw new StreamCorruptedException("EOF expecting count");
            }
            int c = b3 << 24 | b2 << 16 | b1 << 8 | b0;
            if (c < 0) {
                throw new StreamCorruptedException("Negative block data size");
            }
            this.count = c;
        }
    }

    int bufferData(int len) throws IOException {
        this.ensureBufferCapacity(len);
        if (this.blockDataMode) {
            if (len > this.count) {
                throw new InternalError("attempt to read past block end");
            }
            int bufavail = this.bufsize - this.bufpos;
            if (len > bufavail) {
                if (this.bufpos > 0) {
                    System.arraycopy(this.buf, this.bufpos, this.buf, 0, bufavail);
                    this.bufpos = 0;
                    this.bufsize = bufavail;
                }
                this.ensureBufferCapacity(this.count);
                this.readFullyInternal(this.buf, this.bufsize, this.count - this.bufsize);
                this.bufsize = this.count;
            }
            int pos = this.bufpos;
            this.bufpos += len;
            this.count -= len;
            return pos;
        }
        this.readFullyInternal(this.buf, 0, len);
        return 0;
    }

    private void ensureBufferCapacity(int size) {
        if (this.buf.length < size) {
            byte[] newbuf = new byte[size];
            if (this.bufsize > 0) {
                System.arraycopy(this.buf, 0, newbuf, 0, this.bufsize);
            }
            this.buf = newbuf;
        }
    }

    private void readFullyInternal(byte[] b, int off, int len) throws IOException {
        int c;
        for (int n = 0; n < len; n += c) {
            c = this.in.read(b, off + n, len - n);
            if (c >= 0) continue;
            throw new EOFException();
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.blockDataMode) {
            while (this.count == 0) {
                this.refill();
            }
            if (this.count < 0) {
                return -1;
            }
            len = Math.min(len, this.count);
            int nread = 0;
            int bufavail = this.bufsize - this.bufpos;
            if (bufavail > 0) {
                nread = Math.min(len, bufavail);
                System.arraycopy(this.buf, this.bufpos, b, off, nread);
                this.bufpos += nread;
            }
            if (len > nread) {
                nread += this.in.read(b, off + nread, len - nread);
            }
            this.count -= nread;
            return nread;
        }
        return this.in.read(b, off, len);
    }

    public int available() throws IOException {
        if (this.blockDataMode) {
            if (this.count == 0 && this.in.available() > 0) {
                this.refill();
            }
            if (this.count >= 0) {
                return this.count;
            }
            return 0;
        }
        return 0;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean readBoolean() throws IOException {
        int c = this.read();
        if (c < 0) {
            throw new EOFException();
        }
        return c != 0;
    }

    public byte readByte() throws IOException {
        int c = this.read();
        if (c < 0) {
            throw new EOFException();
        }
        return (byte)c;
    }

    public int readUnsignedByte() throws IOException {
        int c = this.read();
        if (c < 0) {
            throw new EOFException();
        }
        return c;
    }

    public short readShort() throws IOException {
        if (this.blockDataMode && this.count < 2) {
            return this.dis.readShort();
        }
        int pos = this.bufferData(2);
        return (short)(((this.buf[pos + 0] & 0xFF) << 8) + ((this.buf[pos + 1] & 0xFF) << 0));
    }

    public int readUnsignedShort() throws IOException {
        if (this.blockDataMode && this.count < 2) {
            return this.dis.readUnsignedShort();
        }
        int pos = this.bufferData(2);
        return ((this.buf[pos + 0] & 0xFF) << 8) + ((this.buf[pos + 1] & 0xFF) << 0);
    }

    public char readChar() throws IOException {
        if (this.blockDataMode && this.count < 2) {
            return this.dis.readChar();
        }
        int pos = this.bufferData(2);
        return (char)(((this.buf[pos + 0] & 0xFF) << 8) + ((this.buf[pos + 1] & 0xFF) << 0));
    }

    public int readInt() throws IOException {
        if (this.blockDataMode && this.count < 4) {
            return this.dis.readInt();
        }
        int pos = this.bufferData(4);
        return ((this.buf[pos + 0] & 0xFF) << 24) + ((this.buf[pos + 1] & 0xFF) << 16) + ((this.buf[pos + 2] & 0xFF) << 8) + ((this.buf[pos + 3] & 0xFF) << 0);
    }

    public long readLong() throws IOException {
        if (this.blockDataMode && this.count < 8) {
            return this.dis.readLong();
        }
        int pos = this.bufferData(8);
        return (((long)this.buf[pos + 0] & 0xFFL) << 56) + (((long)this.buf[pos + 1] & 0xFFL) << 48) + (((long)this.buf[pos + 2] & 0xFFL) << 40) + (((long)this.buf[pos + 3] & 0xFFL) << 32) + (((long)this.buf[pos + 4] & 0xFFL) << 24) + (((long)this.buf[pos + 5] & 0xFFL) << 16) + (((long)this.buf[pos + 6] & 0xFFL) << 8) + (((long)this.buf[pos + 7] & 0xFFL) << 0);
    }

    public float readFloat() throws IOException {
        if (this.blockDataMode && this.count < 4) {
            return this.dis.readFloat();
        }
        int pos = this.bufferData(4);
        return Float.intBitsToFloat(((this.buf[pos + 0] & 0xFF) << 24) + ((this.buf[pos + 1] & 0xFF) << 16) + ((this.buf[pos + 2] & 0xFF) << 8) + ((this.buf[pos + 3] & 0xFF) << 0));
    }

    public double readDouble() throws IOException {
        if (this.blockDataMode && this.count < 8) {
            return this.dis.readDouble();
        }
        int pos = this.bufferData(8);
        return Double.longBitsToDouble((((long)this.buf[pos + 0] & 0xFFL) << 56) + (((long)this.buf[pos + 1] & 0xFFL) << 48) + (((long)this.buf[pos + 2] & 0xFFL) << 40) + (((long)this.buf[pos + 3] & 0xFFL) << 32) + (((long)this.buf[pos + 4] & 0xFFL) << 24) + (((long)this.buf[pos + 5] & 0xFFL) << 16) + (((long)this.buf[pos + 6] & 0xFFL) << 8) + (((long)this.buf[pos + 7] & 0xFFL) << 0));
    }

    public void readFully(byte[] data) throws IOException {
        this.dis.readFully(data);
    }

    public void readFully(byte[] data, int offset, int size) throws IOException {
        if (size < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.dis.readFully(data, offset, size);
    }

    public int skipBytes(int len) throws IOException {
        return this.dis.skipBytes(len);
    }

    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    public String readUTF() throws IOException {
        return this.readUTFBody(this.readUnsignedShort());
    }

    private String readUTFBody(long utflen) throws IOException {
        int PADLEN = 2;
        long remaining = utflen;
        int didx = 0;
        int dlen = 0;
        int cidx = 0;
        int clen = this.cdata.length;
        if (utflen > (long)clen && clen < 1000) {
            this.cdata = new char[(int)Math.min(utflen, 1000L)];
            clen = this.cdata.length;
        }
        while (remaining > 0L) {
            int gap = dlen - didx;
            if (gap > 0) {
                System.arraycopy(this.data, didx, this.data, 0, gap);
            }
            int nread = (int)Math.min(remaining, (long)(this.data.length - gap));
            this.dis.readFully(this.data, gap, nread);
            dlen = gap + nread;
            remaining -= (long)nread;
            didx = 0;
            try {
                int dlimit;
                int n = dlimit = remaining > 0L ? dlen - 2 : dlen;
                block8: while (didx < dlimit) {
                    if (cidx >= clen) {
                        this.sbuf.append(this.cdata);
                        cidx = 0;
                    }
                    int c = this.data[didx++] & 0xFF;
                    switch (c >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            this.cdata[cidx++] = (char)c;
                            continue block8;
                        }
                        case 12: 
                        case 13: {
                            byte c2 = this.data[didx++];
                            if ((c2 & 0xC0) != 128) {
                                throw new UTFDataFormatException();
                            }
                            this.cdata[cidx++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            continue block8;
                        }
                        case 14: {
                            byte c2 = this.data[didx++];
                            byte c3 = this.data[didx++];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new UTFDataFormatException();
                            }
                            this.cdata[cidx++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            continue block8;
                        }
                    }
                    throw new UTFDataFormatException();
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new UTFDataFormatException();
            }
        }
        if (cidx > 0) {
            this.sbuf.append(this.cdata, 0, cidx);
        }
        String s = this.sbuf.toString();
        this.sbuf.setLength(0);
        return s;
    }

    private boolean invokeObjectReader(Object obj) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        if (this.currentClassDesc.readObjectMethod == null) {
            return false;
        }
        try {
            this.currentClassDesc.readObjectMethod.invoke(obj, this.readObjectArglist);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error("interal error");
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    private void inputClassFields(Object o, Class cl, ObjectStreamField[] fields) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        if (this.currentClassDesc.numPrimBytes > 0) {
            if (this.data.length < this.currentClassDesc.numPrimBytes) {
                this.data = new byte[this.currentClassDesc.numPrimBytes];
            }
            this.readFully(this.data, 0, this.currentClassDesc.numPrimBytes);
            if (o != null) {
                ObjectInputStream.setPrimitiveFieldValues(o, this.currentClassDesc.primFieldIDs, this.currentClassDesc.primFieldTypecodes, this.data);
            }
        }
        int numPrimFields = fields.length - this.currentClassDesc.numObjFields;
        for (int i = 0; i < this.currentClassDesc.numObjFields; ++i) {
            Field field = fields[numPrimFields + i].getField();
            boolean requireLocalClass = field != null;
            Object val = this.readObject(requireLocalClass);
            if (o == null || field == null) continue;
            try {
                ObjectInputStream.setObjectFieldValue(o, this.currentClassDesc.objFieldIDs[i], this.currentClassDesc.objFieldTypes[i], val);
                continue;
            }
            catch (ClassCastException e) {
                throw new ClassCastException("Assigning instance of class " + val.getClass().getName() + " to field " + cl.getName() + '#' + field.getName());
            }
            catch (Exception e) {
                throw new InvalidClassException(cl.getName(), "Invalid field " + field.getName());
            }
        }
    }

    private static native void setPrimitiveFieldValues(Object var0, long[] var1, char[] var2, byte[] var3);

    private static native void setObjectFieldValue(Object var0, long var1, Class var3, Object var4);

    private static native Object allocateNewObject(Class var0, Class var1) throws InstantiationException, IllegalAccessException;

    private static native Object allocateNewArray(Class var0, int var1);

    static {
        String l;
        useSystemClassLoader = false;
        inlog = false;
        logTime = false;
        BLOCK = 0x100000;
        System.loadLibrary("NSStream");
        String tpParm = System.getProperty("jeus.io.ObjectInputStream.useSystemClassLoader");
        if (tpParm != null && tpParm.equalsIgnoreCase("false")) {
            useSystemClassLoader = false;
        }
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            cl = loader.loadClass("java.io.ObjectInputStream");
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            l = System.getProperty("jeus.util.io.log");
            if ("true".equalsIgnoreCase(l)) {
                inlog = true;
                ObjectOutputStream.outlog = true;
                ObjectStreamClass.log = true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            l = System.getProperty("jeus.util.io.inlog");
            if ("true".equalsIgnoreCase(l)) {
                inlog = true;
                ObjectStreamClass.log = true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            l = System.getProperty("jeus.util.io.outlog");
            if ("true".equalsIgnoreCase(l)) {
                ObjectOutputStream.outlog = true;
                ObjectStreamClass.log = true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            l = System.getProperty("jeus.util.io.compatible");
            if ("true".equalsIgnoreCase(l)) {
                ObjectStreamClass.preventJeus = false;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            l = System.getProperty("jeus.util.io.logtime");
            if ("true".equalsIgnoreCase(l)) {
                logTime = true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            int size;
            String buf = System.getProperty("jeus.util.io.size");
            if (buf != null && (size = buf.endsWith("M") || buf.endsWith("m") ? Integer.parseInt(buf.substring(0, buf.length() - 1)) << 20 : (buf.endsWith("K") || buf.endsWith("k") ? Integer.parseInt(buf.substring(0, buf.length() - 1)) << 10 : Integer.parseInt(buf))) > 131072 && size < 0x2000000) {
                BLOCK = size;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        out = new Buffer(BLOCK);
        pw = new PrintWriter(out, true);
    }

    static final class GetFieldImpl {
        private byte[] data;
        private Object[] objects;
        private ObjectStreamClass desc;

        public boolean defaulted(String name) throws IOException, IllegalArgumentException {
            ObjectStreamField field = this.checkField(name, null);
            return field == null;
        }

        public boolean get(String name, boolean defvalue) throws IOException, IllegalArgumentException {
            ObjectStreamField field = this.checkField(name, Boolean.TYPE);
            if (field == null) {
                return defvalue;
            }
            return this.data[field.getOffset()] != 0;
        }

        public char get(String name, char defvalue) throws IOException, IllegalArgumentException {
            ObjectStreamField field = this.checkField(name, Character.TYPE);
            if (field == null) {
                return defvalue;
            }
            int loffset = field.getOffset();
            return (char)(((this.data[loffset] & 0xFF) << 8) + (this.data[loffset + 1] & 0xFF));
        }

        public byte get(String name, byte defvalue) throws IOException, IllegalArgumentException {
            ObjectStreamField field = this.checkField(name, Byte.TYPE);
            if (field == null) {
                return defvalue;
            }
            return this.data[field.getOffset()];
        }

        public short get(String name, short defvalue) throws IOException, IllegalArgumentException {
            ObjectStreamField field = this.checkField(name, Short.TYPE);
            if (field == null) {
                return defvalue;
            }
            int loffset = field.getOffset();
            return (short)(((this.data[loffset] & 0xFF) << 8) + (this.data[loffset + 1] & 0xFF));
        }

        public int get(String name, int defvalue) throws IOException, IllegalArgumentException {
            ObjectStreamField field = this.checkField(name, Integer.TYPE);
            if (field == null) {
                return defvalue;
            }
            int loffset = field.getOffset();
            return ((this.data[loffset] & 0xFF) << 24) + ((this.data[loffset + 1] & 0xFF) << 16) + ((this.data[loffset + 2] & 0xFF) << 8) + (this.data[loffset + 3] & 0xFF);
        }

        public long get(String name, long defvalue) throws IOException, IllegalArgumentException {
            ObjectStreamField field = this.checkField(name, Long.TYPE);
            if (field == null) {
                return defvalue;
            }
            int loffset = field.getOffset();
            int upper = ((this.data[loffset] & 0xFF) << 24) + ((this.data[loffset + 1] & 0xFF) << 16) + ((this.data[loffset + 2] & 0xFF) << 8) + (this.data[loffset + 3] & 0xFF);
            int lower = ((this.data[loffset + 4] & 0xFF) << 24) + ((this.data[loffset + 5] & 0xFF) << 16) + ((this.data[loffset + 6] & 0xFF) << 8) + (this.data[loffset + 7] & 0xFF);
            long v = ((long)upper << 32) + ((long)lower & 0xFFFFFFFFL);
            return v;
        }

        public float get(String name, float defvalue) throws IOException, IllegalArgumentException {
            ObjectStreamField field = this.checkField(name, Float.TYPE);
            if (field == null) {
                return defvalue;
            }
            int loffset = field.getOffset();
            int v = ((this.data[loffset] & 0xFF) << 24) + ((this.data[loffset + 1] & 0xFF) << 16) + ((this.data[loffset + 2] & 0xFF) << 8) + (this.data[loffset + 3] & 0xFF);
            return Float.intBitsToFloat(v);
        }

        public double get(String name, double defvalue) throws IOException, IllegalArgumentException {
            ObjectStreamField field = this.checkField(name, Double.TYPE);
            if (field == null) {
                return defvalue;
            }
            int loffset = field.getOffset();
            int upper = ((this.data[loffset] & 0xFF) << 24) + ((this.data[loffset + 1] & 0xFF) << 16) + ((this.data[loffset + 2] & 0xFF) << 8) + (this.data[loffset + 3] & 0xFF);
            int lower = ((this.data[loffset + 4] & 0xFF) << 24) + ((this.data[loffset + 5] & 0xFF) << 16) + ((this.data[loffset + 6] & 0xFF) << 8) + (this.data[loffset + 7] & 0xFF);
            long v = ((long)upper << 32) + ((long)lower & 0xFFFFFFFFL);
            return Double.longBitsToDouble(v);
        }

        public Object get(String name, Object defvalue) throws IOException, IllegalArgumentException {
            ObjectStreamField field = this.checkField(name, Object.class);
            if (field == null) {
                return defvalue;
            }
            return this.objects[field.getOffset()];
        }

        private ObjectStreamField checkField(String name, Class type) throws IllegalArgumentException {
            ObjectStreamField localfield;
            ObjectStreamField field;
            ObjectStreamField objectStreamField = field = type == null ? this.desc.getField(name) : this.desc.getField(name, type);
            if (field != null) {
                if (type != null && type != field.getType()) {
                    throw new IllegalArgumentException("field type incorrect");
                }
                return field;
            }
            ObjectStreamClass localdesc = this.desc.localClassDescriptor();
            if (localdesc == null) {
                throw new IllegalArgumentException("No local class descriptor");
            }
            ObjectStreamField objectStreamField2 = localfield = type == null ? localdesc.getField(name) : localdesc.getField(name, type);
            if (localfield == null) {
                throw new IllegalArgumentException("no such field");
            }
            if (type != null && type != localfield.getType() && (type.isPrimitive() || localfield.getType().isPrimitive())) {
                throw new IllegalArgumentException("field type incorrect");
            }
            return null;
        }

        void read(ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (this.data != null) {
                in.readFully(this.data, 0, this.data.length);
            }
            if (this.objects != null) {
                for (int i = 0; i < this.objects.length; ++i) {
                    this.objects[i] = in.readObject(false);
                }
            }
        }

        GetFieldImpl(ObjectStreamClass descriptor) {
            this.desc = descriptor;
            if (this.desc.numPrimBytes > 0) {
                this.data = new byte[this.desc.numPrimBytes];
            }
            if (this.desc.numObjFields > 0) {
                this.objects = new Object[this.desc.numObjFields];
            }
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }
}

