/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import jeus.util.io.ObjectInputStream;
import jeus.util.io.ObjectOutputStream;
import jeus.util.io.ObjectStreamField;

public class ObjectStreamClass {
    static boolean log = false;
    static boolean preventJeus = true;
    private static ObjectStreamClassEntry[] descriptorFor;
    private String name;
    ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class ofClass;
    boolean forProxyClass;
    private long suid;
    int numPrimBytes;
    int numObjFields;
    private boolean hasWriteObjectMethod;
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    Method readResolveMethod;
    Method writeReplaceMethod;
    private ObjectStreamClass localClassDesc;
    private boolean disableInstanceDeserialization = false;
    ClassNotFoundException pendingException;
    Class[] ancestors;
    long[] primFieldIDs;
    char[] primFieldTypecodes;
    long[] objFieldIDs;
    Class[] objFieldTypes;
    private Object lock = new Object();
    private static final long serialVersionUID = -6120832682080437368L;
    public static final ObjectStreamField[] NO_FIELDS;
    private static final ObjectStreamField[] serialPersistentFields;
    private static Comparator compareClassByName;
    private static Comparator compareMemberByName;
    private static final Class[] NULL_ARGS;
    private static Class[] OIS_ARGS;
    private static Class[] OOS_ARGS;

    public static ObjectStreamClass lookup(Class cl) {
        ObjectStreamClass desc = ObjectStreamClass.lookupInternal(cl);
        if (desc.isSerializable() || desc.isExternalizable()) {
            if (log) {
                ObjectInputStream.log("[OSC/lookup] " + cl.getName() + " will be written", false);
            }
            return desc;
        }
        if (log) {
            ObjectInputStream.log("[OSC/lookup] " + cl.getName() + " is defied", false);
        }
        return null;
    }

    static boolean checkSerializable(Class cl) {
        if (cl == null) {
            return false;
        }
        if ((Modifier.isAbstract(cl.getModifiers()) || preventJeus) && cl.getName().startsWith("jeus")) {
            return Serializable.class.isAssignableFrom(cl);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectStreamClass lookupInternal(Class cl) {
        ObjectStreamClass desc = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (descriptorFor) {
            desc = ObjectStreamClass.findDescriptorFor(cl);
            if (desc == null) {
                Class superclass;
                boolean serializable = ObjectStreamClass.checkSerializable(cl);
                if (log) {
                    ObjectInputStream.log("[OSC/lookupInternal] " + cl.getName() + " is Serial ? " + serializable, false);
                }
                ObjectStreamClass superdesc = null;
                if (serializable && (superclass = cl.getSuperclass()) != null) {
                    superdesc = ObjectStreamClass.lookup(superclass);
                }
                boolean externalizable = false;
                if (serializable) {
                    boolean bl = externalizable = superdesc != null && superdesc.isExternalizable() || Externalizable.class.isAssignableFrom(cl);
                    if (externalizable) {
                        serializable = false;
                    }
                }
                desc = new ObjectStreamClass(cl, superdesc, serializable, externalizable);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            desc.init();
            return desc;
        }
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        return this.suid;
    }

    public Class forClass() {
        return this.ofClass;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] dup = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, dup, 0, this.fields.length);
            return dup;
        }
        return this.fields;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public ObjectStreamField getField(String name) {
        ObjectStreamField searchKey = ObjectStreamField.constructSearchKey(name, Byte.TYPE);
        int index = -1;
        if (this.numObjFields != this.fields.length) {
            index = Arrays.binarySearch(this.fields, searchKey);
        }
        if (index < 0 && this.numObjFields > 0) {
            searchKey.setSearchKeyTypeString(false);
            index = Arrays.binarySearch(this.fields, searchKey);
        }
        return index < 0 ? null : this.fields[index];
    }

    ObjectStreamField getField(String name, Class fieldType) {
        ObjectStreamField searchKey = ObjectStreamField.constructSearchKey(name, fieldType);
        int index = Arrays.binarySearch(this.fields, searchKey);
        return index < 0 ? null : this.fields[index];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(": static final long serialVersionUID = ");
        sb.append(Long.toString(this.suid));
        sb.append("L;");
        return sb.toString();
    }

    private ObjectStreamClass(Class cl, ObjectStreamClass superdesc, boolean serial, boolean extern) {
        this.ofClass = cl;
        if (Proxy.isProxyClass(cl)) {
            this.forProxyClass = true;
        }
        this.name = cl.getName();
        this.superclass = superdesc;
        this.serializable = serial;
        if (!this.forProxyClass) {
            this.externalizable = extern;
        }
        if (log) {
            ObjectInputStream.log("[OSC/new] cl : " + cl.getName() + " superdesc : " + (superdesc == null ? "NULL" : superdesc.getName()) + " serial : " + this.serializable + " extern : " + this.externalizable, false);
        }
        this.hasExternalizableBlockData = true;
        ObjectStreamClass.insertDescriptorFor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (log) {
            ObjectInputStream.log("[OSC/init] ofClass : " + this.ofClass.getName(), false);
        }
        Object object = this.lock;
        synchronized (object) {
            final Class cl = this.ofClass;
            if (this.fields != null) {
                return;
            }
            if (!this.serializable || this.externalizable || this.forProxyClass) {
                this.fields = NO_FIELDS;
            } else if (this.serializable) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Field pf = cl.getDeclaredField("serialPersistentFields");
                            pf.setAccessible(true);
                            ObjectStreamField[] f = (ObjectStreamField[])pf.get(cl);
                            int mods = pf.getModifiers();
                            if (Modifier.isPrivate(mods) && Modifier.isFinal(mods) && Modifier.isStatic(mods)) {
                                ObjectStreamClass.access$002(ObjectStreamClass.this, f);
                            }
                        }
                        catch (NoSuchFieldException e) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        catch (IllegalAccessException e) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        catch (IllegalArgumentException e) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        catch (ClassCastException e) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        if (ObjectStreamClass.this.fields == null) {
                            Field[] actualfields = cl.getDeclaredFields();
                            int numFields = 0;
                            ObjectStreamField[] tempFields = new ObjectStreamField[actualfields.length];
                            for (int i = 0; i < actualfields.length; ++i) {
                                int modifiers = actualfields[i].getModifiers();
                                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                                tempFields[numFields++] = new ObjectStreamField(actualfields[i]);
                            }
                            ObjectStreamClass.access$002(ObjectStreamClass.this, new ObjectStreamField[numFields]);
                            System.arraycopy(tempFields, 0, ObjectStreamClass.this.fields, 0, numFields);
                        } else {
                            for (int j = ObjectStreamClass.this.fields.length - 1; j >= 0; --j) {
                                try {
                                    Field reflField = cl.getDeclaredField(ObjectStreamClass.this.fields[j].getName());
                                    if (ObjectStreamClass.this.fields[j].getType() != reflField.getType()) continue;
                                    ObjectStreamClass.this.fields[j].setField(reflField);
                                    continue;
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    // empty catch block
                                }
                            }
                        }
                        return null;
                    }
                });
                if (this.fields.length > 1) {
                    Arrays.sort(this.fields);
                }
                this.computeFieldInfo();
            }
            if (this.isNonSerializable()) {
                this.suid = 0L;
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (ObjectStreamClass.this.forProxyClass) {
                            ObjectStreamClass.this.suid = 0L;
                        } else {
                            try {
                                Field f = cl.getDeclaredField("serialVersionUID");
                                int mods = f.getModifiers();
                                if (Modifier.isStatic(mods) && Modifier.isFinal(mods)) {
                                    f.setAccessible(true);
                                    ObjectStreamClass.this.suid = f.getLong(cl);
                                } else {
                                    ObjectStreamClass.this.suid = ObjectStreamClass.computeSerialVersionUID(cl);
                                }
                            }
                            catch (NoSuchFieldException ex) {
                                ObjectStreamClass.this.suid = ObjectStreamClass.computeSerialVersionUID(cl);
                            }
                            catch (IllegalAccessException ex) {
                                ObjectStreamClass.this.suid = ObjectStreamClass.computeSerialVersionUID(cl);
                            }
                        }
                        ObjectStreamClass.this.writeReplaceMethod = ObjectStreamClass.this.getDeclaredMethod("writeReplace", NULL_ARGS, 0, 8);
                        if (ObjectStreamClass.this.writeReplaceMethod == null && ObjectStreamClass.this.superclass != null && ObjectStreamClass.this.checkSuperMethodAccess(ObjectStreamClass.this.superclass.writeReplaceMethod)) {
                            ObjectStreamClass.this.writeReplaceMethod = ObjectStreamClass.this.superclass.writeReplaceMethod;
                        }
                        ObjectStreamClass.this.readResolveMethod = ObjectStreamClass.this.getDeclaredMethod("readResolve", NULL_ARGS, 0, 8);
                        if (ObjectStreamClass.this.readResolveMethod == null && ObjectStreamClass.this.superclass != null && ObjectStreamClass.this.checkSuperMethodAccess(ObjectStreamClass.this.superclass.readResolveMethod)) {
                            ObjectStreamClass.this.readResolveMethod = ObjectStreamClass.this.superclass.readResolveMethod;
                        }
                        if (ObjectStreamClass.this.serializable && !ObjectStreamClass.this.forProxyClass) {
                            if (OOS_ARGS == null || OIS_ARGS == null) {
                                ObjectStreamClass.initStaticMethodArgs();
                            }
                            ObjectStreamClass.this.writeObjectMethod = ObjectStreamClass.this.getDeclaredMethod("writeObject", OOS_ARGS, 2, 8);
                            if (ObjectStreamClass.this.writeObjectMethod != null) {
                                ObjectStreamClass.this.hasWriteObjectMethod = true;
                            }
                            ObjectStreamClass.this.readObjectMethod = ObjectStreamClass.this.getDeclaredMethod("readObject", OIS_ARGS, 2, 8);
                        }
                        return null;
                    }
                });
            }
        }
    }

    ObjectStreamClass(String n, long s) {
        this.name = n;
        this.suid = s;
        this.superclass = null;
    }

    private void validateLocalClass(Class localCl) throws InvalidClassException {
        if (this.localClassDesc == null) {
            throw new InvalidClassException(localCl.getName(), "Local class not compatible");
        }
        if (this.suid != this.localClassDesc.suid) {
            boolean arraySUID;
            boolean addedSerialOrExtern = this.isNonSerializable() || this.localClassDesc.isNonSerializable();
            boolean bl = arraySUID = localCl.isArray() && !localCl.getName().equals(this.name);
            if (!arraySUID && !addedSerialOrExtern) {
                throw new InvalidClassException(localCl.getName(), "Local class not compatible: stream classdesc serialVersionUID=" + this.suid + " local class serialVersionUID=" + this.localClassDesc.suid);
            }
        }
        if (!ObjectStreamClass.compareClassNames(this.name, localCl.getName(), '.')) {
            throw new InvalidClassException(localCl.getName(), "Incompatible local class name. Expected class name compatible with " + this.name);
        }
        if (this.serializable && this.localClassDesc.externalizable || this.externalizable && this.localClassDesc.serializable) {
            throw new InvalidClassException(localCl.getName(), "Serializable is incompatible with Externalizable");
        }
    }

    void setClass(Class cl) throws InvalidClassException {
        if (cl == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            this.computeFieldInfo();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookupInternal(cl);
        this.validateLocalClass(cl);
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable || !this.serializable && !this.externalizable) {
            this.disableInstanceDeserialization = true;
            this.ofClass = cl;
            return;
        }
        ObjectStreamField[] destfield = this.localClassDesc.fields;
        ObjectStreamField[] srcfield = this.fields;
        int j = 0;
        block0: for (int i = 0; i < srcfield.length; ++i) {
            for (int k = j; k < destfield.length; ++k) {
                if (!srcfield[i].getName().equals(destfield[k].getName())) continue;
                if (srcfield[i].isPrimitive() && !srcfield[i].typeEquals(destfield[k])) {
                    throw new InvalidClassException(cl.getName(), "The type of field " + destfield[i].getName() + " of class " + this.name + " is incompatible.");
                }
                j = k;
                srcfield[i].setField(destfield[j].getField());
                continue block0;
            }
        }
        this.ofClass = cl;
        this.computeFieldInfo();
        this.readObjectMethod = this.localClassDesc.readObjectMethod;
        this.readResolveMethod = this.localClassDesc.readResolveMethod;
    }

    static boolean compareClassNames(String streamName, String localName, char pkgSeparator) {
        int localNameIndex;
        int streamNameIndex = streamName.lastIndexOf(pkgSeparator);
        if (streamNameIndex < 0) {
            streamNameIndex = 0;
        }
        if ((localNameIndex = localName.lastIndexOf(pkgSeparator)) < 0) {
            localNameIndex = 0;
        }
        return streamName.regionMatches(false, streamNameIndex, localName, localNameIndex, streamName.length() - streamNameIndex);
    }

    boolean typeEquals(ObjectStreamClass other) {
        return this.suid == other.suid && ObjectStreamClass.compareClassNames(this.name, other.name, '.');
    }

    void setSuperclass(ObjectStreamClass s) {
        this.superclass = s;
    }

    ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isNonSerializable() {
        return !this.externalizable && !this.serializable;
    }

    private void computeFieldInfo() {
        this.numPrimBytes = 0;
        this.numObjFields = 0;
        block12: for (int i = 0; i < this.fields.length; ++i) {
            switch (this.fields[i].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    this.fields[i].setOffset(this.numPrimBytes);
                    ++this.numPrimBytes;
                    continue block12;
                }
                case 'C': 
                case 'S': {
                    this.fields[i].setOffset(this.numPrimBytes);
                    this.numPrimBytes += 2;
                    continue block12;
                }
                case 'F': 
                case 'I': {
                    this.fields[i].setOffset(this.numPrimBytes);
                    this.numPrimBytes += 4;
                    continue block12;
                }
                case 'D': 
                case 'J': {
                    this.fields[i].setOffset(this.numPrimBytes);
                    this.numPrimBytes += 8;
                    continue block12;
                }
                case 'L': 
                case '[': {
                    this.fields[i].setOffset(this.numObjFields);
                    ++this.numObjFields;
                }
            }
        }
        if (this.ofClass != null) {
            int numPrimFields = this.fields.length - this.numObjFields;
            if (numPrimFields > 0) {
                this.primFieldIDs = new long[numPrimFields];
                this.primFieldTypecodes = new char[numPrimFields];
            }
            if (this.numObjFields > 0) {
                this.objFieldIDs = new long[this.numObjFields];
                this.objFieldTypes = new Class[this.numObjFields];
            }
            ObjectStreamClass.getFieldIDs(this.fields, this.primFieldIDs, this.objFieldIDs);
            int oi = 0;
            int pi = 0;
            try {
                block13: for (int i = 0; i < this.fields.length; ++i) {
                    char tc = this.fields[i].getTypeCode();
                    switch (tc) {
                        case 'L': 
                        case '[': {
                            Field f = this.fields[i].getField();
                            this.objFieldTypes[oi++] = f != null ? f.getType() : null;
                            continue block13;
                        }
                        default: {
                            this.primFieldTypecodes[pi++] = tc;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new InternalError("field count mismatch for class " + this.ofClass.getName());
            }
            if (oi != this.numObjFields || pi != numPrimFields) {
                throw new InternalError("field count mismatch for class " + this.ofClass.getName());
            }
        }
    }

    private static long computeSerialVersionUID(Class cl) {
        ByteArrayOutputStream devnull = new ByteArrayOutputStream(512);
        long h = 0L;
        try {
            String desc;
            int i;
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream mdo = new DigestOutputStream(devnull, md);
            DataOutputStream data = new DataOutputStream(mdo);
            data.writeUTF(cl.getName());
            int classaccess = cl.getModifiers();
            Member[] method = cl.getDeclaredMethods();
            if (((classaccess &= 0x611) & 0x200) != 0) {
                classaccess &= 0xFFFFFBFF;
                if (method.length > 0) {
                    classaccess |= 0x400;
                }
            }
            data.writeInt(classaccess);
            if (!cl.isArray()) {
                Class<?>[] interfaces = cl.getInterfaces();
                Arrays.sort(interfaces, compareClassByName);
                for (i = 0; i < interfaces.length; ++i) {
                    data.writeUTF(interfaces[i].getName());
                }
            }
            Field[] field = cl.getDeclaredFields();
            Arrays.sort(field, compareMemberByName);
            for (i = 0; i < field.length; ++i) {
                Field f = field[i];
                int m = f.getModifiers();
                if (Modifier.isPrivate(m) && (Modifier.isTransient(m) || Modifier.isStatic(m))) continue;
                data.writeUTF(f.getName());
                data.writeInt(m);
                data.writeUTF(ObjectStreamClass.getSignature(f.getType()));
            }
            if (ObjectStreamClass.hasStaticInitializer(cl)) {
                data.writeUTF("<clinit>");
                data.writeInt(8);
                data.writeUTF("()V");
            }
            MethodSignature[] constructors = MethodSignature.removePrivateAndSort(cl.getDeclaredConstructors());
            for (int i2 = 0; i2 < constructors.length; ++i2) {
                MethodSignature c = constructors[i2];
                String mname = "<init>";
                desc = c.signature;
                desc = desc.replace('/', '.');
                data.writeUTF(mname);
                data.writeInt(c.member.getModifiers());
                data.writeUTF(desc);
            }
            MethodSignature[] methods = MethodSignature.removePrivateAndSort(method);
            for (int i3 = 0; i3 < methods.length; ++i3) {
                MethodSignature m = methods[i3];
                desc = m.signature;
                desc = desc.replace('/', '.');
                data.writeUTF(m.member.getName());
                data.writeInt(m.member.getModifiers());
                data.writeUTF(desc);
            }
            data.flush();
            byte[] hasharray = md.digest();
            for (int i4 = 0; i4 < Math.min(8, hasharray.length); ++i4) {
                h += (long)(hasharray[i4] & 0xFF) << i4 * 8;
            }
        }
        catch (IOException ignore) {
            h = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return h;
    }

    static String getSignature(Class clazz) {
        String type = null;
        if (clazz.isArray()) {
            Class<?> cl = clazz;
            int dimensions = 0;
            while (cl.isArray()) {
                ++dimensions;
                cl = cl.getComponentType();
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dimensions; ++i) {
                sb.append("[");
            }
            sb.append(ObjectStreamClass.getSignature(cl));
            type = sb.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                type = "I";
            } else if (clazz == Byte.TYPE) {
                type = "B";
            } else if (clazz == Long.TYPE) {
                type = "J";
            } else if (clazz == Float.TYPE) {
                type = "F";
            } else if (clazz == Double.TYPE) {
                type = "D";
            } else if (clazz == Short.TYPE) {
                type = "S";
            } else if (clazz == Character.TYPE) {
                type = "C";
            } else if (clazz == Boolean.TYPE) {
                type = "Z";
            } else if (clazz == Void.TYPE) {
                type = "V";
            }
        } else {
            type = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return type;
    }

    static String getSignature(Method meth) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Class<?>[] params = meth.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(ObjectStreamClass.getSignature(params[j]));
        }
        sb.append(")");
        sb.append(ObjectStreamClass.getSignature(meth.getReturnType()));
        return sb.toString();
    }

    static String getSignature(Constructor cons) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Class<?>[] params = cons.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(ObjectStreamClass.getSignature(params[j]));
        }
        sb.append(")V");
        return sb.toString();
    }

    void write(ObjectOutputStream s) throws IOException {
        int flags = 0;
        if (this.hasWriteObjectMethod) {
            flags |= 1;
        }
        if (this.serializable) {
            flags |= 2;
        }
        if (this.externalizable) {
            flags |= 4;
            if (!s.useDeprecatedExternalizableFormat) {
                flags |= 8;
            }
        }
        s.writeByte(flags);
        if (this.fields == null) {
            s.writeShort(0);
            return;
        }
        s.writeShort(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField f = this.fields[i];
            s.writeByte(f.getTypeCode());
            s.writeUTF(f.getName());
            if (!f.isPrimitive()) {
                s.writeTypeString(f.getTypeString());
                if (!log) continue;
                ObjectInputStream.log("[OSC/write] field name : " + f.getName() + ",  type : " + f.getTypeString(), false);
                continue;
            }
            if (!log) continue;
            ObjectInputStream.log("[OSC/write] field name : " + f.getName() + ",  type : " + f.getTypeCode(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(ObjectInputStream s) throws IOException, ClassNotFoundException {
        byte flags = s.readByte();
        this.serializable = (flags & 2) != 0;
        boolean bl = this.externalizable = (flags & 4) != 0;
        boolean bl2 = this.serializable ? (flags & 1) != 0 : (this.hasWriteObjectMethod = false);
        this.hasExternalizableBlockData = this.externalizable ? (flags & 8) != 0 : false;
        int count = s.readShort();
        this.fields = new ObjectStreamField[count];
        boolean prevEnableResolve = s.enableResolve;
        s.enableResolve = false;
        try {
            for (int i = 0; i < count; ++i) {
                char type = (char)s.readByte();
                String name = s.readUTF();
                String ftype = null;
                switch (type) {
                    case 'L': 
                    case '[': {
                        ftype = (String)s.readObject();
                        if (!log) break;
                        ObjectInputStream.log("[OSC/read] field name : " + name + ",  type : " + ftype, false);
                        break;
                    }
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        if (!log) break;
                        ObjectInputStream.log("[OSC/read] field name : " + name + ",  type : " + type, false);
                        break;
                    }
                    default: {
                        throw new StreamCorruptedException("illegal field descriptor typecode: " + type);
                    }
                }
                this.fields[i] = new ObjectStreamField(name, type, null, ftype);
            }
        }
        finally {
            s.enableResolve = prevEnableResolve;
        }
    }

    void lightCopy(ObjectStreamClass desc) {
        this.name = desc.name;
        this.serializable = desc.serializable;
        this.externalizable = desc.externalizable;
        this.fields = new ObjectStreamField[desc.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField cf = desc.fields[i];
            this.fields[i] = new ObjectStreamField(cf.getName(), cf.getTypeCode(), null, cf.getTypeString());
        }
        this.suid = desc.suid;
        this.hasWriteObjectMethod = desc.hasWriteObjectMethod;
        this.hasExternalizableBlockData = desc.hasExternalizableBlockData;
    }

    void initProxyClassDesc(Class cl) {
        this.forProxyClass = true;
        if (cl != null) {
            this.name = cl.getName();
        }
        this.serializable = true;
        this.externalizable = false;
        this.fields = NO_FIELDS;
        this.hasWriteObjectMethod = false;
        this.hasExternalizableBlockData = true;
    }

    void verifyInstanceDeserialization() throws InvalidClassException {
        if (this.disableInstanceDeserialization) {
            String name;
            String string = name = this.serializable || this.externalizable ? this.localClassDesc.getName() : this.getName();
            String stype = this.serializable || this.localClassDesc.serializable ? "Serializable" : (this.externalizable || this.localClassDesc.externalizable ? "Externalizable" : "Serializable or Externalizable");
            throw new InvalidClassException(name, "is not " + stype);
        }
    }

    private static ObjectStreamClass findDescriptorFor(Class cl) {
        ObjectStreamClassEntry e;
        int hash = cl.hashCode();
        int index = (hash & Integer.MAX_VALUE) % descriptorFor.length;
        while ((e = descriptorFor[index]) != null && e.get() == null) {
            ObjectStreamClass.descriptorFor[index] = e.next;
        }
        ObjectStreamClassEntry prev = e;
        while (e != null) {
            ObjectStreamClass desc = (ObjectStreamClass)e.get();
            if (desc == null) {
                prev.next = e.next;
            } else {
                if (desc.ofClass == cl) {
                    return desc;
                }
                prev = e;
            }
            e = e.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ObjectStreamClass desc) {
        if (ObjectStreamClass.findDescriptorFor(desc.ofClass) != null) {
            return;
        }
        int hash = desc.ofClass.hashCode();
        int index = (hash & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry e = new ObjectStreamClassEntry(desc);
        e.next = descriptorFor[index];
        ObjectStreamClass.descriptorFor[index] = e;
    }

    private static native void initNative();

    private static native void getFieldIDs(ObjectStreamField[] var0, long[] var1, long[] var2);

    private static native boolean hasStaticInitializer(Class var0);

    boolean isResolvable() {
        return this.readResolveMethod != null;
    }

    boolean isReplaceable() {
        return this.writeReplaceMethod != null;
    }

    static Object invokeMethod(Method method, Object obj, Object[] args) throws IOException {
        if (log) {
            ObjectInputStream.log("[OSC/invokeMethod] method : " + method.getName() + " obj : " + obj, false);
        }
        Object returnValue = null;
        try {
            returnValue = method.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error("interal error");
        }
        catch (IllegalAccessException e) {
            throw new Error("interal error");
        }
        return returnValue;
    }

    private Method getDeclaredMethod(String methodName, Class[] args, int requiredModifierMask, int disallowedModifierMask) {
        Method method = null;
        try {
            method = this.ofClass.getDeclaredMethod(methodName, args);
            if (method != null) {
                int mods = method.getModifiers();
                if ((mods & disallowedModifierMask) != 0 || (mods & requiredModifierMask) != requiredModifierMask) {
                    method = null;
                } else {
                    method.setAccessible(true);
                }
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method;
    }

    private boolean checkSuperMethodAccess(Method scMethod) {
        if (scMethod == null) {
            return false;
        }
        int supermods = scMethod.getModifiers();
        if (Modifier.isPublic(supermods) || Modifier.isProtected(supermods)) {
            return true;
        }
        if (Modifier.isPrivate(supermods)) {
            return false;
        }
        return ObjectStreamClass.isSameClassPackage(scMethod.getDeclaringClass(), this.ofClass);
    }

    private static boolean isSameClassPackage(Class cl1, Class cl2) {
        if (cl1.getClassLoader() != cl2.getClassLoader()) {
            return false;
        }
        String clName1 = cl1.getName();
        String clName2 = cl2.getName();
        int idx1 = clName1.lastIndexOf(46);
        int idx2 = clName2.lastIndexOf(46);
        if (idx1 == -1 || idx2 == -1) {
            return idx1 == idx2;
        }
        return clName1.regionMatches(false, 0, clName2, 0, idx1 - 1);
    }

    private static void initStaticMethodArgs() {
        OOS_ARGS = new Class[1];
        ObjectStreamClass.OOS_ARGS[0] = java.io.ObjectOutputStream.class;
        OIS_ARGS = new Class[1];
        ObjectStreamClass.OIS_ARGS[0] = java.io.ObjectInputStream.class;
    }

    static /* synthetic */ ObjectStreamField[] access$002(ObjectStreamClass x0, ObjectStreamField[] x1) {
        x0.fields = x1;
        return x1;
    }

    static {
        System.loadLibrary("NSStream");
        descriptorFor = new ObjectStreamClassEntry[61];
        ObjectStreamClass.initNative();
        NO_FIELDS = new ObjectStreamField[0];
        serialPersistentFields = NO_FIELDS;
        compareClassByName = new CompareClassByName();
        compareMemberByName = new CompareMemberByName();
        NULL_ARGS = new Class[0];
        OIS_ARGS = null;
        OOS_ARGS = null;
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] m) {
            int numNonPrivate = 0;
            for (int i = 0; i < m.length; ++i) {
                if (Modifier.isPrivate(m[i].getModifiers())) continue;
                ++numNonPrivate;
            }
            MethodSignature[] cm = new MethodSignature[numNonPrivate];
            int cmi = 0;
            for (int i = 0; i < m.length; ++i) {
                if (Modifier.isPrivate(m[i].getModifiers())) continue;
                cm[cmi] = new MethodSignature(m[i]);
                ++cmi;
            }
            if (cmi > 0) {
                Arrays.sort(cm, cm[0]);
            }
            return cm;
        }

        public int compare(Object o1, Object o2) {
            int result;
            if (o1 == o2) {
                return 0;
            }
            MethodSignature c1 = (MethodSignature)o1;
            MethodSignature c2 = (MethodSignature)o2;
            if (this.isConstructor()) {
                result = c1.signature.compareTo(c2.signature);
            } else {
                result = c1.member.getName().compareTo(c2.member.getName());
                if (result == 0) {
                    result = c1.signature.compareTo(c2.signature);
                }
            }
            return result;
        }

        private boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member m) {
            this.member = m;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)m) : ObjectStreamClass.getSignature((Method)m);
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((Member)o1).getName();
            String s2 = ((Member)o2).getName();
            if (o1 instanceof Method) {
                s1 = s1 + ObjectStreamClass.getSignature((Method)o1);
                s2 = s2 + ObjectStreamClass.getSignature((Method)o2);
            } else if (o1 instanceof Constructor) {
                s1 = s1 + ObjectStreamClass.getSignature((Constructor)o1);
                s2 = s2 + ObjectStreamClass.getSignature((Constructor)o2);
            }
            return s1.compareTo(s2);
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object o1, Object o2) {
            Class c1 = (Class)o1;
            Class c2 = (Class)o2;
            return c1.getName().compareTo(c2.getName());
        }
    }

    private static class ObjectStreamClassEntry
    extends SoftReference {
        ObjectStreamClassEntry next;

        ObjectStreamClassEntry(ObjectStreamClass c) {
            super(c);
        }
    }
}

