/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import jeus.util.logging.AccessFormatter;
import jeus.util.logging.FileHandler;

public class AccessFileHandler
extends FileHandler {
    private String formatString;
    private FileOutputStream out;
    private boolean enableAnalysis = false;

    public AccessFileHandler(AccessFormatter formatter) {
        Map props = formatter.getProperty();
        this.formatString = (String)props.get("web.accesslog.format");
        this.enableAnalysis = formatter.isEnableLogAnalysis();
        try {
            this.setEncoding("ISO-8859-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void open() throws FileNotFoundException {
        super.open();
        String filename = this.getFileName();
        String metainfo = filename + "_metainfo";
        this.out = new FileOutputStream(metainfo, this.isAppend());
        File file = new File(filename);
        if (!this.isAppend() || !file.exists() || file.length() == 0L) {
            String info = "0:" + this.formatString + "\n";
            try {
                this.out.write(info.getBytes());
                this.out.flush();
                this.out.close();
                this.out = null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return;
        }
        if (this.enableAnalysis) {
            int pos;
            int lineCount = this.countLine(filename);
            ++lineCount;
            File metaFile = new File(metainfo);
            if (!metaFile.exists() || metaFile.length() == 0L) {
                String info = lineCount + ":" + this.formatString + "\n";
                try {
                    this.out.write(info.getBytes());
                    this.out.flush();
                    this.out.close();
                    this.out = null;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                return;
            }
            FileReader reader = new FileReader(metainfo);
            StringBuffer f = new StringBuffer();
            String oldFormat = null;
            try {
                int ch;
                while ((ch = reader.read()) != -1) {
                    if (ch == 10) {
                        oldFormat = f.toString();
                        f = new StringBuffer();
                        continue;
                    }
                    f.append((char)ch);
                }
            }
            catch (IOException ioe) {
                oldFormat = null;
            }
            if (oldFormat != null && (pos = oldFormat.indexOf(":")) >= 0) {
                oldFormat = oldFormat.substring(pos + 1);
            }
            if (oldFormat == null || !oldFormat.equals(this.formatString)) {
                String info = lineCount + ":" + this.formatString + "\n";
                try {
                    this.out.write(info.getBytes());
                    this.out.flush();
                    this.out.close();
                    this.out = null;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                return;
            }
        }
    }

    private int countLine(String filename) {
        int count = 0;
        try {
            int b;
            FileInputStream in = new FileInputStream(filename);
            while ((b = ((InputStream)in).read()) != -1) {
                if (b != 10) continue;
                ++count;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return count;
    }

    public synchronized void close() throws SecurityException {
        this.flushAndClose();
    }
}

