/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;

public class JeusLogManager
extends LogManager {
    private static boolean disableReset = false;

    public JeusLogManager() {
        try {
            Runtime.getRuntime().addShutdownHook(new Cleaner());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void readConfiguration() throws IOException, SecurityException {
        if (disableReset) {
            throw new SecurityException();
        }
        super.readConfiguration();
    }

    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        if (disableReset) {
            throw new SecurityException();
        }
        super.readConfiguration(ins);
    }

    public void reset() throws SecurityException {
    }

    public void jeusReset() {
        super.reset();
    }

    public static void disableReset() {
        if (!JeusLogManager.checkLogManager()) {
            return;
        }
        disableReset = true;
    }

    public static void enableReset() {
        if (!JeusLogManager.checkLogManager()) {
            return;
        }
        disableReset = false;
    }

    private static boolean checkLogManager() {
        LogManager logManager = LogManager.getLogManager();
        return logManager instanceof JeusLogManager;
    }

    private class Cleaner
    extends Thread {
        private Cleaner() {
        }

        public void run() {
            JeusLogManager.enableReset();
            JeusLogManager.this.jeusReset();
        }
    }
}

