/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import jeus.util.JeusProperties;
import jeus.util.JeusRootClassLoader;
import jeus.util.StringUtil;
import jeus.util.VirtualDNS;
import jeus.util.logging.ConsoleHandler;
import jeus.util.logging.ErrorHandlerFactory;
import jeus.util.logging.FileHandler;
import jeus.util.logging.HandlerFactory;
import jeus.util.logging.JeusFormatter;
import jeus.util.logging.JeusHandler;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.SimpleFormatter;
import jeus.util.logging.SmtpHandler;
import jeus.util.logging.SocketHandler;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusPropertyValues;
import jeus.xml.binding.jeusDD.CommonHandlerType;
import jeus.xml.binding.jeusDD.ConsoleHandlerType;
import jeus.xml.binding.jeusDD.FileHandlerType;
import jeus.xml.binding.jeusDD.HandlerPropertySetType;
import jeus.xml.binding.jeusDD.HandlerType;
import jeus.xml.binding.jeusDD.LoggingLevelType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.PropertyType;
import jeus.xml.binding.jeusDD.SmtpHandlerType;
import jeus.xml.binding.jeusDD.SocketHandlerType;
import jeus.xml.binding.jeusDD.SystemLoggingType;
import jeus.xml.binding.jeusDD.UserHandlerType;

public class JeusLoggerConfiguration {
    public static final HashMap defaultLoggerSetting = new HashMap();

    public static void setDefaultFilePath() {
        if (JeusPropertyValues.JEUS_CATEGORY == 1) {
            defaultLoggerSetting.put("jeus", new String[]{"JeusServer", VirtualDNS.LOCAL_VIRTUALNAME});
            defaultLoggerSetting.put("jeus.ejb", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE" + File.separator + "ejb"});
            defaultLoggerSetting.put("jeus.servlet", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE" + File.separator + "servlet" + File.separator + "errorlog"});
            defaultLoggerSetting.put("jeus.jms", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE" + File.separator + "jms"});
            defaultLoggerSetting.put("jeus.jms.access", new String[]{"access", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "jms"});
            defaultLoggerSetting.put("jeus.systemuser", new String[]{"UserLog", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE"});
            defaultLoggerSetting.put("jeus.webaccess", new String[]{"access", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE" + File.separator + "servlet" + File.separator + "accesslog"});
            defaultLoggerSetting.put("jeus.systemuser.webuser", new String[]{"user", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE" + File.separator + "servlet" + File.separator + "userlog"});
        } else if (JeusPropertyValues.JEUS_CATEGORY == 2) {
            defaultLoggerSetting.put("jeus", new String[]{JeusManagerPropertyValues.containerName, VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName});
            defaultLoggerSetting.put("jeus.ejb", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "ejb"});
            defaultLoggerSetting.put("jeus.servlet", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "servlet" + File.separator + "errorlog"});
            defaultLoggerSetting.put("jeus.jms", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "jms"});
            defaultLoggerSetting.put("jeus.jms.access", new String[]{"access", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "jms"});
            defaultLoggerSetting.put("jeus.systemuser", new String[]{"UserLog", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName});
            defaultLoggerSetting.put("jeus.webaccess", new String[]{"access", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "servlet" + File.separator + "accesslog"});
            defaultLoggerSetting.put("jeus.systemuser.webuser", new String[]{"user", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "servlet" + File.separator + "userlog"});
        }
    }

    public static void setDefaultFilePath(String loggerName, String[] path) {
        defaultLoggerSetting.put(loggerName, path);
    }

    public static void setDefaultConsoleHandler(SystemLoggingType logging) throws JAXBException {
        HandlerType handlers = logging.getHandler();
        if (handlers == null) {
            ConsoleHandlerType handler = new ObjectFactory().createConsoleHandlerType();
            handler.setName("ConsoleHandler");
            handler.setLevel(LoggingLevelType.valueOf((String)Level.ALL.getName()));
            handlers = new ObjectFactory().createHandlerType();
            handlers.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(handler);
            logging.setHandler(handlers);
        }
    }

    public static void configLogger(JeusLogger logger, SystemLoggingType logging) throws Throwable, IllegalAccessException, ClassNotFoundException, UnsupportedEncodingException, JAXBException {
        JeusLoggerConfiguration.configLogger(logger, logging, (JeusFormatter)new SimpleFormatter(), ErrorHandlerFactory.handlerFactory);
    }

    public static void configLogger(JeusLogger logger, SystemLoggingType logging1, JeusFormatter formatter, HandlerFactory factory) throws Throwable, ClassNotFoundException, UnsupportedEncodingException, JAXBException {
        try {
            SystemLoggingType logging = (SystemLoggingType)logging1.cloneType();
            boolean useParentHandler = false;
            if (logging.isSetUseParentHandlers()) {
                useParentHandler = logging.isUseParentHandlers();
            }
            logger.setUseParentHandlers(useParentHandler);
            ClassLoader loader = JeusRootClassLoader.loader;
            String defaultFileName = null;
            String defaultDirectory = null;
            String[] settings = (String[])defaultLoggerSetting.get(logger.getName());
            if (settings != null) {
                defaultFileName = settings[0];
                defaultDirectory = settings[1];
            } else {
                defaultFileName = logger.getName();
                defaultDirectory = JeusManagerPropertyValues.containerName != null ? VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName : VirtualDNS.LOCAL_VIRTUALNAME;
            }
            String filter = logging.getFilterClass();
            if (filter != null) {
                logger.setFilter((Filter)loader.loadClass(filter).newInstance());
            }
            Handler[] handlers = logger.getHandlers();
            HandlerType handlerType = logging.getHandler();
            Level defaultLoggerLevel = Level.SEVERE;
            if (handlerType == null) {
                if (!useParentHandler) {
                    ConsoleHandlerType handler = new ObjectFactory().createConsoleHandlerType();
                    handler.setName("ConsoleHandler");
                    handler.setLevel(LoggingLevelType.valueOf((String)Level.ALL.getName()));
                    JeusLoggerConfiguration.addConsoleHandler(logger, handler, formatter);
                }
            } else {
                List loggingHandlers = handlerType.getConsoleHandlerOrFileHandlerOrSmtpHandler();
                for (int i = 0; i < loggingHandlers.size(); ++i) {
                    CommonHandlerType obj = (CommonHandlerType)loggingHandlers.get(i);
                    String name = obj.getName();
                    if (name == null || name.equals("")) {
                        String className = handlerType.getClass().getName();
                        name = className.substring(className.lastIndexOf(46) + 1) + "-" + i;
                        obj.setName(name);
                    }
                    if (obj instanceof ConsoleHandlerType) {
                        JeusLoggerConfiguration.addConsoleHandler(logger, (ConsoleHandlerType)obj, formatter);
                    } else if (obj instanceof FileHandlerType) {
                        JeusLoggerConfiguration.addFileHandler(logger, (FileHandlerType)obj, defaultDirectory, defaultFileName, formatter, factory);
                    } else if (obj instanceof SmtpHandlerType) {
                        JeusLoggerConfiguration.addSmtpHandler(logger, (SmtpHandlerType)obj, formatter);
                    } else if (obj instanceof SocketHandlerType) {
                        JeusLoggerConfiguration.addSocketHandler(logger, (SocketHandlerType)obj, formatter);
                    } else if (obj instanceof UserHandlerType) {
                        JeusLoggerConfiguration.addUserHandler(logger, (UserHandlerType)obj);
                    }
                    Level level = JeusLevel.parse((String)obj.getLevel().value());
                    if (level.intValue() >= defaultLoggerLevel.intValue()) continue;
                    defaultLoggerLevel = level;
                }
            }
            if (!logger.doesUsePredefinedLevel()) {
                String levelString = logging.getLevel().value();
                Level level = levelString == null || "".equals(levelString) ? defaultLoggerLevel : JeusLevel.parse((String)levelString);
                logger.setLevel(level);
            }
            for (int i = 0; i < handlers.length; ++i) {
                Handler handler = handlers[i];
                logger.removeHandler(handler);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    private static void addSmtpHandler(JeusLogger logger, SmtpHandlerType smtpHandler, JeusFormatter formatter) throws Exception {
        SmtpHandler handler = new SmtpHandler();
        JeusLoggerConfiguration.setSmtpHandler(smtpHandler, (Handler)handler, formatter);
        if (smtpHandler.isSendForAllMessages().booleanValue()) {
            logger.addHandler((Handler)handler);
        } else {
            logger.setSmtpHandler((Handler)handler);
        }
    }

    public static void setSmtpHandler(SmtpHandlerType handlerType, Handler handler, JeusFormatter formatter) throws Exception, IllegalAccessException, InstantiationException, UnsupportedEncodingException {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("mail.smtp.host", handlerType.getSmtpHostAddress());
        propertyMap.put("mail.from.address", handlerType.getFromAddress());
        propertyMap.put("mail.to.recipients", handlerType.getToAddress());
        propertyMap.put("mail.to.ccrecipients", handlerType.getCcAddress());
        propertyMap.put("mail.to.bccrecipients", handlerType.getBccAddress());
        Map formatterPropertyMap = Collections.EMPTY_MAP;
        JeusLoggerConfiguration.setCommonHandler((CommonHandlerType)handlerType, handler, propertyMap, formatter, formatterPropertyMap);
    }

    public static void addSocketHandler(JeusLogger logger, SocketHandlerType socketHandler, JeusFormatter formatter) throws Exception {
        SocketHandler handler = new SocketHandler();
        JeusLoggerConfiguration.setSocketHandler(socketHandler, (Handler)handler, formatter);
        logger.addHandler((Handler)handler);
    }

    public static void setSocketHandler(SocketHandlerType handlerType, Handler handler, JeusFormatter formatter) throws Exception, IllegalAccessException, InstantiationException, UnsupportedEncodingException {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("socket.host.addr", handlerType.getAddress());
        propertyMap.put("socket.host.port", new Integer(handlerType.getPort()));
        Map formatterPropertyMap = Collections.EMPTY_MAP;
        JeusLoggerConfiguration.setCommonHandler((CommonHandlerType)handlerType, handler, propertyMap, formatter, formatterPropertyMap);
    }

    private static void setHandlerSetting(Handler handler, Map propertyMap, JeusFormatter formatter, Map formatterPropertyMap, String level, String filter, String encoding) throws Exception {
        ((JeusHandler)handler).setProperty(propertyMap);
        formatter.setProperty(formatterPropertyMap);
        handler.setFormatter((Formatter)formatter);
        handler.setLevel(JeusLevel.parse((String)level));
        if (filter != null) {
            handler.setFilter((Filter)JeusRootClassLoader.loader.loadClass(filter).newInstance());
        }
        if (encoding != null) {
            handler.setEncoding(encoding);
        }
    }

    public static void addConsoleHandler(JeusLogger logger, ConsoleHandlerType handlerType, JeusFormatter formatter) throws Exception {
        ConsoleHandler handler = new ConsoleHandler();
        JeusLoggerConfiguration.setConsoleHandler(handlerType, (Handler)handler, formatter);
        logger.addHandler((Handler)handler);
    }

    public static void setConsoleHandler(ConsoleHandlerType handlerType, Handler handler, JeusFormatter formatter) throws Exception {
        Map propertyMap = Collections.EMPTY_MAP;
        Map formatterPropertyMap = Collections.EMPTY_MAP;
        JeusLoggerConfiguration.setCommonHandler((CommonHandlerType)handlerType, handler, propertyMap, formatter, formatterPropertyMap);
    }

    private static void setCommonHandler(CommonHandlerType handlerType, Handler handler, Map propertyMap, JeusFormatter formatter, Map formatterPropertyMap) throws Exception {
        ((JeusHandler)handler).setName(handlerType.getName());
        String level = handlerType.getLevel().value();
        String filter = handlerType.getFilterClass();
        String encoding = handlerType.getEncoding();
        JeusLoggerConfiguration.setHandlerSetting(handler, propertyMap, formatter, formatterPropertyMap, level, filter, encoding);
    }

    public static void addFileHandler(JeusLogger logger, FileHandlerType handlerType, String defaultDirectory, String defaultFileName, JeusFormatter formatter, HandlerFactory factory) throws Exception {
        FileHandler handler = factory.createFileHandler((Formatter)formatter);
        JeusLoggerConfiguration.setFileHandler(handlerType, defaultDirectory, defaultFileName, (Handler)handler, formatter);
        logger.addHandler((Handler)handler);
    }

    public static void setFileHandler(FileHandlerType handlerType, String defaultDirectory, String defaultFileName, Handler handler, JeusFormatter formatter) throws Exception {
        int day = handlerType.getValidDay() == null ? 0 : handlerType.getValidDay();
        int hour = handlerType.getValidHour() == null ? 0 : handlerType.getValidHour();
        String fileName = handlerType.getFileName();
        if (fileName == null) {
            if (defaultDirectory != null && defaultFileName != null) {
                fileName = JeusProperties.JEUS_LOG_HOME + File.separator + defaultDirectory + File.separator + defaultFileName;
                fileName = JeusLoggerConfiguration.attachTimePattern(day, fileName, hour) + ".log";
            }
        } else if (fileName.indexOf("%d") < 0) {
            int index;
            File f = new File(fileName);
            if (!f.isAbsolute()) {
                fileName = JeusProperties.JEUS_LOG_HOME + File.separator + defaultDirectory + File.separator + fileName;
            }
            if ((index = fileName.lastIndexOf(".")) < 0) {
                index = fileName.length();
            }
            fileName = JeusLoggerConfiguration.attachTimePattern(day, fileName.substring(0, index), hour) + fileName.substring(index);
        }
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("pattern", fileName);
        propertyMap.put("bufferSize", new Integer(handlerType.getBufferSize()));
        propertyMap.put("append", new Boolean(handlerType.isAppend()));
        if (day > 0) {
            propertyMap.put("validDay", new Integer(handlerType.getValidDay()));
        } else if (hour > 0) {
            propertyMap.put("validHour", new Integer(handlerType.getValidHour()));
        }
        Map formatterPropertyMap = Collections.EMPTY_MAP;
        JeusLoggerConfiguration.setCommonHandler((CommonHandlerType)handlerType, handler, propertyMap, formatter, formatterPropertyMap);
    }

    private static String attachTimePattern(int day, String fileName, int hour) {
        if (day > 0) {
            fileName = fileName + "_%d{" + day + "}";
        } else if (hour > 0) {
            fileName = fileName + "_%d{1}_%h{" + hour + "}";
        }
        return fileName;
    }

    public static String detachTimePattern(int day, String fileName, int hour) {
        if (day > 0 || hour > 0) {
            int index = fileName.indexOf("_%d");
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public static void addUserHandler(JeusLogger logger, UserHandlerType handlerType) throws Exception {
        String className = handlerType.getHandlerClass();
        Handler handler = (Handler)JeusRootClassLoader.loader.loadClass(className).newInstance();
        JeusLoggerConfiguration.setUserHandler(handlerType, handler);
        logger.addHandler(handler);
    }

    public static void setUserHandler(UserHandlerType handlerType, Handler handler) throws Exception {
        Map propertyMap = JeusLoggerConfiguration.makePropertyMap(handlerType.getHandlerProperty());
        Map formatterPropertyMap = JeusLoggerConfiguration.makePropertyMap(handlerType.getFormatterProperty());
        JeusFormatter formatter = (JeusFormatter)JeusRootClassLoader.loader.loadClass(handlerType.getFormatterClass()).newInstance();
        JeusLoggerConfiguration.setCommonHandler((CommonHandlerType)handlerType, handler, propertyMap, formatter, formatterPropertyMap);
    }

    public static Map makePropertyMap(HandlerPropertySetType propertySet) {
        if (propertySet == null) {
            return Collections.EMPTY_MAP;
        }
        List property = propertySet.getProperty();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < property.size(); ++i) {
            PropertyType propertyType = (PropertyType)property.get(i);
            map.put(propertyType.getKey(), propertyType.getValue());
        }
        return map;
    }

    public static void replaceHandlers(Logger target, Logger source) {
        Handler[] oldHandlers = target.getHandlers();
        for (int i = 0; i < oldHandlers.length; ++i) {
            Handler oldHandler = oldHandlers[i];
            target.removeHandler(oldHandler);
        }
        Handler[] handlers = source.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            target.addHandler(handler);
        }
    }

    public static void printLoggerInformation(Logger logger) {
        StringBuffer buffer = new StringBuffer("***** logger name : ").append(logger.getName()).append(StringUtil.lineSeparator);
        buffer.append("\t logger level : ").append(logger.getLevel()).append(StringUtil.lineSeparator);
        Handler[] handlers = logger.getHandlers();
        buffer.append("\t logger handlers : ").append(handlers.length).append(StringUtil.lineSeparator);
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            buffer.append("\t\t handler toString() : ").append(handler).append(StringUtil.lineSeparator);
            buffer.append("\t\t handler class : ").append(handler.getClass()).append(StringUtil.lineSeparator);
            buffer.append("\t\t handler level : ").append(handler.getLevel()).append(StringUtil.lineSeparator);
        }
        buffer.append("\t use parent handler : ").append(logger.getUseParentHandlers()).append(StringUtil.lineSeparator);
        Logger parent = logger.getParent();
        buffer.append("\t parent logger : ").append(parent == null ? "null" : parent.getName()).append(StringUtil.lineSeparator);
        if (logger.getUseParentHandlers() && parent != null) {
            JeusLoggerConfiguration.printLoggerInformation(parent);
        }
    }
}

