/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.objio;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import jeus.util.JeusProperties;
import jeus.util.objio.Bits;
import jeus.util.objio.ObjectInOutConstants;
import jeus.util.objio.ObjectInputStream;
import jeus.util.objio.ObjectOutputStream;
import jeus.util.objio.ObjectStreamException;
import jeus.util.objio.ObjectStreamField;
import sun.misc.SoftCache;
import sun.reflect.ReflectionFactory;

public final class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields = NO_FIELDS;
    private static final ReflectionFactory reflFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    private static final SoftCache localDescs = new SoftCache(10);
    private static final SoftCache reflectors = new SoftCache(10);
    private Class cl;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData = true;
    private ClassNotFoundException resolveEx;
    private InvalidClassException deserializeEx;
    private InvalidClassException serializeEx;
    private InvalidClassException defaultSerializeEx;
    private ObjectStreamField[] fields;
    int primDataSize;
    int numObjFields;
    long[] primFieldIDs;
    char[] primFieldTypecodes;
    long[] objFieldIDs;
    Class[] objFieldTypes;
    private volatile ClassDataSlot[] dataLayout;
    private Constructor cons;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;
    private static final Class[] NULL_ARGS = new Class[0];
    private static Class[] OIS_ARGS = null;
    private static Class[] OOS_ARGS = null;
    static boolean UseReflect = JeusProperties.getBooleanParamValue("jeus.util.objio.UseReflect", true);
    private static String[] wellKnownPackages = new String[]{"java.", "jeus."};
    private static Object wellKnownPackagesMutex = new Object();
    private static String[] notSerialPackages = new String[]{"jeus.", "java.", "com.tmax."};
    private static Object notSerialPackagesMutex = new Object();
    boolean isWellKnownPackage = false;
    boolean isShouldNotBeSerializable = false;

    private static void initStaticMethodArgs() {
        OOS_ARGS = new Class[1];
        ObjectStreamClass.OOS_ARGS[0] = java.io.ObjectOutputStream.class;
        OIS_ARGS = new Class[1];
        ObjectStreamClass.OIS_ARGS[0] = java.io.ObjectInputStream.class;
    }

    private static native void initNative();

    private static native void getFieldIDs(ObjectStreamField[] var0, long[] var1, long[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWellKnownPackage(String packagePrefix) {
        if (packagePrefix == null || !packagePrefix.endsWith(".")) {
            throw new IllegalArgumentException("packagePrefix:" + packagePrefix + " should not be null and should end with '.'");
        }
        Object object = wellKnownPackagesMutex;
        synchronized (object) {
            String[] old = wellKnownPackages;
            wellKnownPackages = new String[old.length];
            System.arraycopy(old, 0, wellKnownPackages, 0, old.length);
            ObjectStreamClass.wellKnownPackages[old.length] = packagePrefix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNonSerialPackage(String packagePrefix) {
        if (packagePrefix == null || !packagePrefix.endsWith(".")) {
            throw new IllegalArgumentException("packagePrefix:" + packagePrefix + " should not be null and should end with '.'");
        }
        Object object = notSerialPackagesMutex;
        synchronized (object) {
            String[] old = notSerialPackages;
            notSerialPackages = new String[old.length];
            System.arraycopy(old, 0, notSerialPackages, 0, old.length);
            ObjectStreamClass.notSerialPackages[old.length] = packagePrefix;
        }
    }

    public static ObjectStreamClass lookup(Class cl) {
        return ObjectStreamClass.lookup(cl, false);
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        if (this.suid == null) {
            this.suid = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Long(ObjectStreamClass.computeDefaultSUID(ObjectStreamClass.this.cl));
                }
            });
        }
        return this.suid;
    }

    public Class forClass() {
        return this.cl;
    }

    public ObjectStreamField getField(String name) {
        return this.getField(name, null);
    }

    public String toString() {
        return this.name + ": static final long serialVersionUID = " + this.getSerialVersionUID() + "L;";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectStreamClass lookup(Class cl, boolean all) {
        Object entry;
        if (!all && !Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        EntryFuture future = null;
        SoftCache softCache = localDescs;
        synchronized (softCache) {
            entry = localDescs.get((Object)cl);
            if (entry == null) {
                future = new EntryFuture();
                localDescs.put((Object)cl, (Object)future);
            }
        }
        if (entry instanceof ObjectStreamClass) {
            return (ObjectStreamClass)entry;
        }
        if (entry instanceof EntryFuture) {
            future = (EntryFuture)entry;
            entry = future.getOwner() == Thread.currentThread() ? null : future.get();
        }
        if (entry == null) {
            try {
                entry = new ObjectStreamClass(cl);
            }
            catch (Throwable th) {
                entry = th;
            }
            if (future.set(entry)) {
                softCache = localDescs;
                synchronized (softCache) {
                    localDescs.put((Object)cl, entry);
                }
            } else {
                entry = future.get();
            }
        }
        if (entry instanceof ObjectStreamClass) {
            return (ObjectStreamClass)entry;
        }
        if (entry instanceof RuntimeException) {
            throw (RuntimeException)entry;
        }
        if (entry instanceof Error) {
            throw (Error)entry;
        }
        throw new InternalError("unexpected entry: " + entry);
    }

    private ObjectStreamClass(final Class cl) {
        this.cl = cl;
        this.name = cl.getName();
        this.isProxy = Proxy.isProxyClass(cl);
        this.serializable = Serializable.class.isAssignableFrom(cl);
        this.externalizable = Externalizable.class.isAssignableFrom(cl);
        Class superCl = cl.getSuperclass();
        this.superDesc = superCl != null ? ObjectStreamClass.lookup(superCl, false) : null;
        this.localDesc = this;
        if (cl != null && ObjectInOutConstants.IGNORE_SUPERCLASS_DESC_FOR_WELLKNOWN) {
            this.isWellKnownPackage = this.identifyWellKnown();
        }
        if (!this.serializable && cl != null && ObjectInOutConstants.AllowNonserial) {
            this.isShouldNotBeSerializable = ObjectStreamClass.isNotSerializable(cl.getName());
            if (this.isShouldNotBeSerializable) {
                try {
                    this.cons = ObjectStreamClass.getSerializableConstructor(cl);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
        }
        if (ObjectInOutConstants.AllowNonserial || this.serializable) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ObjectStreamClass.this.suid = ObjectStreamClass.getDeclaredSUID(cl);
                    try {
                        ObjectStreamClass.access$502(ObjectStreamClass.this, ObjectStreamClass.getSerialFields(cl));
                        ObjectStreamClass.this.computeFieldOffsets();
                    }
                    catch (InvalidClassException e) {
                        ObjectStreamClass.this.serializeEx = (ObjectStreamClass.this.deserializeEx = e);
                        ObjectStreamClass.access$502(ObjectStreamClass.this, NO_FIELDS);
                    }
                    if (ObjectStreamClass.this.externalizable) {
                        ObjectStreamClass.this.cons = ObjectStreamClass.getExternalizableConstructor(cl);
                    } else {
                        ObjectStreamClass.this.cons = ObjectStreamClass.getSerializableConstructor(cl);
                        ObjectStreamClass.this.writeObjectMethod = ObjectStreamClass.getPrivateMethod(cl, "writeObject", OOS_ARGS, Void.TYPE);
                        ObjectStreamClass.this.readObjectMethod = ObjectStreamClass.getPrivateMethod(cl, "readObject", OIS_ARGS, Void.TYPE);
                        ObjectStreamClass.this.readObjectNoDataMethod = ObjectStreamClass.getPrivateMethod(cl, "readObjectNoData", new Class[0], Void.TYPE);
                        ObjectStreamClass.this.hasWriteObjectData = ObjectStreamClass.this.writeObjectMethod != null;
                    }
                    ObjectStreamClass.this.writeReplaceMethod = ObjectStreamClass.getInheritableMethod(cl, "writeReplace", NULL_ARGS, Object.class);
                    ObjectStreamClass.this.readResolveMethod = ObjectStreamClass.getInheritableMethod(cl, "readResolve", NULL_ARGS, Object.class);
                    return null;
                }
            });
        } else {
            this.suid = new Long(0L);
            this.fields = NO_FIELDS;
        }
        if (this.deserializeEx == null && this.cons == null) {
            this.deserializeEx = new InvalidClassException(this.name, "no valid constructor");
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getField() != null) continue;
            this.defaultSerializeEx = new InvalidClassException(this.name, "unmatched serializable field(s) declared");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNotSerializable(String _className) {
        Object object = notSerialPackagesMutex;
        synchronized (object) {
            for (int i = 0; i < notSerialPackages.length; ++i) {
                String aPackage = notSerialPackages[i];
                if (!_className.startsWith(aPackage)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean identifyWellKnown() {
        Object object = wellKnownPackagesMutex;
        synchronized (object) {
            for (int i = 0; i < wellKnownPackages.length; ++i) {
                String aPackage = wellKnownPackages[i];
                if (!this.name.startsWith(aPackage)) continue;
                return true;
            }
            return false;
        }
    }

    ObjectStreamClass() {
    }

    void initProxy(Class cl, ClassNotFoundException resolveEx, ObjectStreamClass superDesc) throws InvalidClassException {
        this.cl = cl;
        this.resolveEx = resolveEx;
        this.superDesc = superDesc;
        this.isProxy = true;
        this.serializable = true;
        this.suid = new Long(0L);
        this.fields = NO_FIELDS;
        if (cl != null) {
            this.localDesc = ObjectStreamClass.lookup(cl, true);
            if (!this.localDesc.isProxy) {
                throw new InvalidClassException("cannot bind proxy descriptor to a non-proxy class");
            }
            this.name = this.localDesc.name;
            this.externalizable = this.localDesc.externalizable;
            this.cons = this.localDesc.cons;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            this.deserializeEx = this.localDesc.deserializeEx;
        }
    }

    final void initNonProxy(ObjectStreamClass model, Class cl, ClassNotFoundException resolveEx, ObjectStreamClass superDesc, ObjectStreamClass cachedLocalDesc) throws InvalidClassException {
        this.cl = cl;
        this.resolveEx = resolveEx;
        this.superDesc = superDesc;
        this.name = model.name;
        this.suid = new Long(model.getSerialVersionUID());
        this.isProxy = false;
        if (cl != null) {
            this.localDesc = cachedLocalDesc == null ? ObjectStreamClass.lookup(cl, true) : cachedLocalDesc;
            if (this.localDesc.isProxy) {
                throw new InvalidClassException("cannot bind non-proxy descriptor to a proxy class");
            }
            if (!cl.isArray() && this.suid.longValue() != this.localDesc.getSerialVersionUID()) {
                throw new InvalidClassException(this.localDesc.name, "local class incompatible: stream classdesc serialVersionUID = " + this.suid + ", local class serialVersionUID = " + this.localDesc.getSerialVersionUID());
            }
            this.cons = this.localDesc.cons;
            this.writeObjectMethod = this.localDesc.writeObjectMethod;
            this.readObjectMethod = this.localDesc.readObjectMethod;
            this.readObjectNoDataMethod = this.localDesc.readObjectNoDataMethod;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            this.superDesc = this.localDesc.superDesc;
            if (this.deserializeEx == null) {
                this.deserializeEx = this.localDesc.deserializeEx;
            }
            this.serializable = this.localDesc.serializable;
            this.externalizable = this.localDesc.externalizable;
            this.hasBlockExternalData = this.localDesc.hasBlockExternalData;
            this.hasWriteObjectData = this.localDesc.hasWriteObjectData;
            this.isShouldNotBeSerializable = this.localDesc.isShouldNotBeSerializable;
            this.fields = this.localDesc.fields;
            this.primDataSize = this.localDesc.primDataSize;
            this.numObjFields = this.localDesc.numObjFields;
            this.primFieldIDs = this.localDesc.primFieldIDs;
            this.primFieldTypecodes = this.localDesc.primFieldTypecodes;
            this.objFieldIDs = this.localDesc.objFieldIDs;
            this.objFieldTypes = this.localDesc.objFieldTypes;
        }
    }

    void readNonProxy(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.suid = new Long(in.readLong());
    }

    void writeNonProxy(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.getSerialVersionUID());
    }

    ClassNotFoundException getResolveException() {
        return this.resolveEx;
    }

    void checkDeserialize() throws InvalidClassException {
        if (this.deserializeEx != null) {
            throw this.deserializeEx;
        }
    }

    void checkSerialize() throws InvalidClassException {
        if (this.serializeEx != null) {
            throw this.serializeEx;
        }
    }

    void checkDefaultSerialize() throws InvalidClassException {
        if (this.defaultSerializeEx != null) {
            throw this.defaultSerializeEx;
        }
    }

    ObjectStreamClass getSuperDesc() {
        return this.superDesc;
    }

    ObjectStreamClass getLocalDesc() {
        return this.localDesc;
    }

    ObjectStreamField[] getFields(boolean copy) {
        return copy ? (ObjectStreamField[])this.fields.clone() : this.fields;
    }

    ObjectStreamField getField(String name, Class type) {
        for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField f = this.fields[i];
            if (!f.getName().equals(name)) continue;
            if (type == null || type == Object.class && !f.isPrimitive()) {
                return f;
            }
            Class ftype = f.getTypeClass();
            if (ftype == null || !type.isAssignableFrom(ftype)) continue;
            return f;
        }
        return null;
    }

    boolean isProxy() {
        return this.isProxy;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean hasBlockExternalData() {
        return this.hasBlockExternalData;
    }

    boolean hasWriteObjectData() {
        return this.hasWriteObjectData;
    }

    boolean isInstantiable() {
        return this.cons != null;
    }

    boolean hasWriteObjectMethod() {
        return this.writeObjectMethod != null;
    }

    boolean hasReadObjectMethod() {
        return this.readObjectMethod != null;
    }

    boolean hasReadObjectNoDataMethod() {
        return this.readObjectNoDataMethod != null;
    }

    boolean hasWriteReplaceMethod() {
        return this.writeReplaceMethod != null;
    }

    boolean hasReadResolveMethod() {
        return this.readResolveMethod != null;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        if (this.cons != null) {
            try {
                return this.cons.newInstance(null);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    void invokeWriteObject(Object obj, ObjectOutputStream out) throws IOException, UnsupportedOperationException {
        if (this.writeObjectMethod != null) {
            try {
                this.writeObjectMethod.invoke(obj, out);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                ObjectStreamClass.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObject(Object obj, ObjectInputStream in) throws ClassNotFoundException, IOException, UnsupportedOperationException {
        if (this.readObjectMethod != null) {
            try {
                this.readObjectMethod.invoke(obj, in);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)th;
                }
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                ObjectStreamClass.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObjectNoData(Object obj) throws IOException, UnsupportedOperationException {
        if (this.readObjectNoDataMethod != null) {
            try {
                this.readObjectNoDataMethod.invoke(obj, null);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ObjectStreamClass.throwMiscException(th);
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    Object invokeWriteReplace(Object obj) throws IOException, UnsupportedOperationException {
        if (this.writeReplaceMethod != null) {
            try {
                return this.writeReplaceMethod.invoke(obj, null);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ObjectStreamClass.throwMiscException(th);
                throw new InternalError();
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    Object invokeReadResolve(Object obj) throws IOException, UnsupportedOperationException {
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(obj, null);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof ObjectStreamException) {
                    throw (ObjectStreamException)th;
                }
                ObjectStreamClass.throwMiscException(th);
                throw new InternalError();
            }
            catch (IllegalAccessException ex) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    ClassDataSlot[] getClassDataLayout() throws InvalidClassException {
        if (this.dataLayout == null) {
            this.dataLayout = this.getClassDataLayout0();
        }
        return this.dataLayout;
    }

    ClassDataSlot[] getClassDataLayoutNonSerial() throws InvalidClassException {
        if (this.dataLayout == null) {
            this.dataLayout = this.getClassDataLayoutNonSerial0();
        }
        return this.dataLayout;
    }

    private ClassDataSlot[] getClassDataLayout0() throws InvalidClassException {
        Class end;
        ArrayList<ClassDataSlot> slots = new ArrayList<ClassDataSlot>();
        Class start = this.cl;
        for (end = this.cl; end != null && Serializable.class.isAssignableFrom(end); end = end.getSuperclass()) {
        }
        ObjectStreamClass d = this;
        while (d != null) {
            Class c;
            String searchName = d.cl != null ? d.cl.getName() : d.name;
            Class match = null;
            for (c = start; c != end; c = c.getSuperclass()) {
                if (!searchName.equals(c.getName())) continue;
                match = c;
                break;
            }
            if (match != null) {
                for (c = start; c != match; c = c.getSuperclass()) {
                    slots.add(new ClassDataSlot(ObjectStreamClass.lookup(c, true), false));
                }
                start = match.getSuperclass();
            }
            slots.add(new ClassDataSlot(d.getVariantFor(match), true));
            d = d.superDesc;
        }
        for (Class c = start; c != end; c = c.getSuperclass()) {
            slots.add(new ClassDataSlot(ObjectStreamClass.lookup(c, true), false));
        }
        Collections.reverse(slots);
        return slots.toArray(new ClassDataSlot[slots.size()]);
    }

    private ClassDataSlot[] getClassDataLayoutNonSerial0() throws InvalidClassException {
        Class tmpClass;
        ArrayList<ClassDataSlot> slots = new ArrayList<ClassDataSlot>();
        Class start = this.cl;
        Class<Object> end = this.cl;
        boolean isNonSerializable = false;
        for (tmpClass = this.cl; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            if (tmpClass == null || !ObjectStreamClass.isNotSerializable(tmpClass.getName())) continue;
            isNonSerializable = true;
            break;
        }
        end = isNonSerializable ? tmpClass : Object.class;
        ObjectStreamClass d = this;
        while (d != null) {
            Class c;
            String searchName = d.cl != null ? d.cl.getName() : d.name;
            Class match = null;
            for (c = start; c != end; c = c.getSuperclass()) {
                if (!searchName.equals(c.getName())) continue;
                match = c;
                break;
            }
            if (match != null) {
                for (c = start; c != match; c = c.getSuperclass()) {
                    slots.add(new ClassDataSlot(ObjectStreamClass.lookup(c, true), false));
                }
                start = match.getSuperclass();
            }
            slots.add(new ClassDataSlot(d.getVariantFor(match), true));
            d = d.superDesc;
        }
        for (Class c = start; c != end; c = c.getSuperclass()) {
            slots.add(new ClassDataSlot(ObjectStreamClass.lookup(c, true), false));
        }
        Collections.reverse(slots);
        return slots.toArray(new ClassDataSlot[slots.size()]);
    }

    int getPrimDataSize() {
        return this.primDataSize;
    }

    int getNumObjFields() {
        return this.numObjFields;
    }

    private void computeFieldOffsets() throws InvalidClassException {
        this.primDataSize = 0;
        this.numObjFields = 0;
        int firstObjIndex = -1;
        block12: for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField f = this.fields[i];
            switch (f.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    f.setOffset(this.primDataSize++);
                    continue block12;
                }
                case 'C': 
                case 'S': {
                    f.setOffset(this.primDataSize);
                    this.primDataSize += 2;
                    continue block12;
                }
                case 'F': 
                case 'I': {
                    f.setOffset(this.primDataSize);
                    this.primDataSize += 4;
                    continue block12;
                }
                case 'D': 
                case 'J': {
                    f.setOffset(this.primDataSize);
                    this.primDataSize += 8;
                    continue block12;
                }
                case 'L': 
                case '[': {
                    f.setOffset(this.numObjFields++);
                    if (firstObjIndex != -1) continue block12;
                    firstObjIndex = i;
                    continue block12;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        if (this.cl != null) {
            int numPrimFields = this.fields.length - this.numObjFields;
            if (numPrimFields > 0) {
                this.primFieldIDs = new long[numPrimFields];
                this.primFieldTypecodes = new char[numPrimFields];
            }
            if (this.numObjFields > 0) {
                this.objFieldIDs = new long[this.numObjFields];
                this.objFieldTypes = new Class[this.numObjFields];
            }
            if (!UseReflect) {
                ObjectStreamClass.getFieldIDs(this.fields, this.primFieldIDs, this.objFieldIDs);
            }
            int oi = 0;
            int pi = 0;
            try {
                block13: for (int i = 0; i < this.fields.length; ++i) {
                    char tc = this.fields[i].getTypeCode();
                    switch (tc) {
                        case 'L': 
                        case '[': {
                            Field f = this.fields[i].getField();
                            this.objFieldTypes[oi++] = f != null ? f.getType() : null;
                            continue block13;
                        }
                        default: {
                            this.primFieldTypecodes[pi++] = tc;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new InternalError("field count mismatch for class " + this.cl.getName());
            }
            if (oi != this.numObjFields || pi != numPrimFields) {
                throw new InternalError("field count mismatch for class " + this.cl.getName());
            }
        }
        if (firstObjIndex != -1 && firstObjIndex + this.numObjFields != this.fields.length) {
            throw new InvalidClassException(this.name, "illegal field order");
        }
    }

    private ObjectStreamClass getVariantFor(Class cl) throws InvalidClassException {
        if (this.cl == cl) {
            return this;
        }
        ObjectStreamClass desc = new ObjectStreamClass();
        if (this.isProxy) {
            desc.initProxy(cl, null, this.superDesc);
        } else {
            desc.initNonProxy(this, cl, null, this.superDesc, null);
        }
        return desc;
    }

    private static Constructor getExternalizableConstructor(Class cl) {
        try {
            Constructor cons = cl.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            return (cons.getModifiers() & 1) != 0 ? cons : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Constructor getSerializableConstructor(Class cl) {
        Class initCl = cl;
        while (Serializable.class.isAssignableFrom(initCl)) {
            if ((initCl = initCl.getSuperclass()) != null) continue;
            return null;
        }
        try {
            Constructor<Object> cons = initCl.getDeclaredConstructor(new Class[0]);
            int mods = cons.getModifiers();
            if ((mods & 2) != 0 || (mods & 5) == 0 && !ObjectStreamClass.packageEquals(cl, initCl)) {
                return null;
            }
            cons = reflFactory.newConstructorForSerialization(cl, cons);
            cons.setAccessible(true);
            return cons;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Method getInheritableMethod(Class cl, String name, Class[] argTypes, Class returnType) {
        Class defCl;
        Method meth = null;
        for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                meth = defCl.getDeclaredMethod(name, argTypes);
                break;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        if (meth == null || meth.getReturnType() != returnType) {
            return null;
        }
        meth.setAccessible(true);
        int mods = meth.getModifiers();
        if ((mods & 0x408) != 0) {
            return null;
        }
        if ((mods & 5) != 0) {
            return meth;
        }
        if ((mods & 2) != 0) {
            return cl == defCl ? meth : null;
        }
        return ObjectStreamClass.packageEquals(cl, defCl) ? meth : null;
    }

    private static Method getPrivateMethod(Class cl, String name, Class[] argTypes, Class returnType) {
        try {
            Method meth = cl.getDeclaredMethod(name, argTypes);
            meth.setAccessible(true);
            int mods = meth.getModifiers();
            return meth.getReturnType() == returnType && (mods & 8) == 0 && (mods & 2) != 0 ? meth : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static boolean packageEquals(Class cl1, Class cl2) {
        return cl1.getClassLoader() == cl2.getClassLoader() && ObjectStreamClass.getPackageName(cl1).equals(ObjectStreamClass.getPackageName(cl2));
    }

    private static String getPackageName(Class cl) {
        String s = cl.getName();
        int i = s.lastIndexOf(91);
        if (i >= 0) {
            s = s.substring(i + 2);
        }
        return (i = s.lastIndexOf(46)) >= 0 ? s.substring(0, i) : "";
    }

    private static boolean classNamesEqual(String name1, String name2) {
        name1 = name1.substring(name1.lastIndexOf(46) + 1);
        name2 = name2.substring(name2.lastIndexOf(46) + 1);
        return name1.equals(name2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getClassSignature(Class cl) {
        StringBuffer sbuf = new StringBuffer();
        while (cl.isArray()) {
            sbuf.append('[');
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                sbuf.append('I');
                return sbuf.toString();
            } else if (cl == Byte.TYPE) {
                sbuf.append('B');
                return sbuf.toString();
            } else if (cl == Long.TYPE) {
                sbuf.append('J');
                return sbuf.toString();
            } else if (cl == Float.TYPE) {
                sbuf.append('F');
                return sbuf.toString();
            } else if (cl == Double.TYPE) {
                sbuf.append('D');
                return sbuf.toString();
            } else if (cl == Short.TYPE) {
                sbuf.append('S');
                return sbuf.toString();
            } else if (cl == Character.TYPE) {
                sbuf.append('C');
                return sbuf.toString();
            } else if (cl == Boolean.TYPE) {
                sbuf.append('Z');
                return sbuf.toString();
            } else {
                if (cl != Void.TYPE) throw new InternalError();
                sbuf.append('V');
            }
            return sbuf.toString();
        } else {
            sbuf.append('L' + cl.getName().replace('.', '/') + ';');
        }
        return sbuf.toString();
    }

    private static String getMethodSignature(Class[] paramTypes, Class retType) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        for (int i = 0; i < paramTypes.length; ++i) {
            sbuf.append(ObjectStreamClass.getClassSignature(paramTypes[i]));
        }
        sbuf.append(')');
        sbuf.append(ObjectStreamClass.getClassSignature(retType));
        return sbuf.toString();
    }

    private static void throwMiscException(Throwable th) throws IOException {
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof Error) {
            throw (Error)th;
        }
        IOException ex = new IOException("unexpected exception type");
        ex.initCause(th);
        throw ex;
    }

    private static ObjectStreamField[] getSerialFields(Class cl) throws InvalidClassException {
        Object[] fields;
        if (ObjectInOutConstants.AllowNonserial) {
            Object[] fields2;
            if (!(Externalizable.class.isAssignableFrom(cl) || Proxy.isProxyClass(cl) || cl.isInterface())) {
                fields2 = ObjectStreamClass.getDeclaredSerialFields(cl);
                if (fields2 == null) {
                    fields2 = ObjectStreamClass.getDefaultSerialFields(cl);
                }
                Arrays.sort(fields2);
            } else {
                fields2 = NO_FIELDS;
            }
            return fields2;
        }
        if (Serializable.class.isAssignableFrom(cl) && !Externalizable.class.isAssignableFrom(cl) && !Proxy.isProxyClass(cl) && !cl.isInterface()) {
            fields = ObjectStreamClass.getDeclaredSerialFields(cl);
            if (fields == null) {
                fields = ObjectStreamClass.getDefaultSerialFields(cl);
            }
            Arrays.sort(fields);
        } else {
            fields = NO_FIELDS;
        }
        return fields;
    }

    private static ObjectStreamField[] getDeclaredSerialFields(Class cl) throws InvalidClassException {
        ObjectStreamField[] serialPersistentFields = null;
        try {
            Field f = cl.getDeclaredField("serialPersistentFields");
            int mask = 26;
            if ((f.getModifiers() & mask) == mask) {
                f.setAccessible(true);
                serialPersistentFields = (ObjectStreamField[])f.get(null);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (serialPersistentFields == null) {
            return null;
        }
        if (serialPersistentFields.length == 0) {
            return NO_FIELDS;
        }
        ObjectStreamField[] boundFields = new ObjectStreamField[serialPersistentFields.length];
        HashSet<String> fieldNames = new HashSet<String>(serialPersistentFields.length);
        for (int i = 0; i < serialPersistentFields.length; ++i) {
            ObjectStreamField spf = serialPersistentFields[i];
            String fname = spf.getName();
            if (fieldNames.contains(fname)) {
                throw new InvalidClassException("multiple serializable fields named " + fname);
            }
            fieldNames.add(fname);
            try {
                Field f = cl.getDeclaredField(fname);
                if (f.getType() == spf.getTypeClass() && (f.getModifiers() & 8) == 0) {
                    boundFields[i] = new ObjectStreamField(f, spf.isUnshared(), true);
                }
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
            if (boundFields[i] != null) continue;
            boundFields[i] = new ObjectStreamField(fname, spf.getTypeClass(), spf.isUnshared());
        }
        return boundFields;
    }

    static void setObjectValues(Object obj, ObjectStreamField[] fields, Object[] objs) {
        int curPos = 0;
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField field = fields[i];
            Field f = field.getField();
            Class<?> type = f.getType();
            try {
                if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE) continue;
                f.set(obj, objs[curPos++]);
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static void getPrimitiveValues(Object obj, ObjectStreamField[] fields, byte[] data) {
        int curPos = 0;
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField field = fields[i];
            Field f = field.getField();
            Class<?> type = f.getType();
            try {
                if (type == Integer.TYPE) {
                    Bits.putInt(data, curPos, f.getInt(obj));
                    curPos += 4;
                    continue;
                }
                if (type == Boolean.TYPE) {
                    Bits.putBoolean(data, curPos, f.getBoolean(obj));
                    ++curPos;
                    continue;
                }
                if (type == Byte.TYPE) {
                    data[curPos] = f.getByte(obj);
                    ++curPos;
                    continue;
                }
                if (type == Character.TYPE) {
                    Bits.putChar(data, curPos, f.getChar(obj));
                    curPos += 2;
                    continue;
                }
                if (type == Short.TYPE) {
                    Bits.putShort(data, curPos, f.getShort(obj));
                    curPos += 2;
                    continue;
                }
                if (type == Long.TYPE) {
                    Bits.putLong(data, curPos, f.getLong(obj));
                    curPos += 8;
                    continue;
                }
                if (type == Float.TYPE) {
                    Bits.putFloat(data, curPos, f.getFloat(obj));
                    curPos += 4;
                    continue;
                }
                if (type != Double.TYPE) continue;
                Bits.putDouble(data, curPos, f.getDouble(obj));
                curPos += 8;
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static void setPrimitiveValues(Object obj, byte[] data, ObjectStreamField[] fields) {
        int curPos = 0;
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField field = fields[i];
            Field f = field.getField();
            Class<?> type = f.getType();
            try {
                if (type == Integer.TYPE) {
                    f.setInt(obj, Bits.getInt(data, curPos));
                    curPos += 4;
                    continue;
                }
                if (type == Boolean.TYPE) {
                    f.setBoolean(obj, Bits.getBoolean(data, curPos));
                    ++curPos;
                    continue;
                }
                if (type == Byte.TYPE) {
                    f.setByte(obj, data[curPos]);
                    ++curPos;
                    continue;
                }
                if (type == Character.TYPE) {
                    f.setChar(obj, Bits.getChar(data, curPos));
                    curPos += 2;
                    continue;
                }
                if (type == Short.TYPE) {
                    f.setShort(obj, Bits.getShort(data, curPos));
                    curPos += 2;
                    continue;
                }
                if (type == Long.TYPE) {
                    f.setLong(obj, Bits.getLong(data, curPos));
                    curPos += 8;
                    continue;
                }
                if (type == Float.TYPE) {
                    f.setFloat(obj, Bits.getFloat(data, curPos));
                    curPos += 4;
                    continue;
                }
                if (type != Double.TYPE) continue;
                f.setDouble(obj, Bits.getDouble(data, curPos));
                curPos += 8;
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static void getObjectValues(Object obj, ObjectStreamField[] fields, Object[] objs) {
        int curPos = 0;
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField field = fields[i];
            Field f = field.getField();
            Class<?> type = f.getType();
            try {
                if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE) continue;
                objs[curPos++] = f.get(obj);
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    private static ObjectStreamField[] getDefaultSerialFields(Class cl) {
        Field[] clFields = cl.getDeclaredFields();
        ArrayList<ObjectStreamField> list = new ArrayList<ObjectStreamField>();
        int mask = 136;
        for (int i = 0; i < clFields.length; ++i) {
            if ((clFields[i].getModifiers() & mask) != 0) continue;
            if (UseReflect) {
                clFields[i].setAccessible(true);
            }
            list.add(new ObjectStreamField(clFields[i], false, true));
        }
        int size = list.size();
        return size == 0 ? NO_FIELDS : list.toArray(new ObjectStreamField[size]);
    }

    private static Long getDeclaredSUID(Class cl) {
        try {
            Field f = cl.getDeclaredField("serialVersionUID");
            int mask = 24;
            if ((f.getModifiers() & mask) == mask) {
                f.setAccessible(true);
                return new Long(f.getLong(null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static long computeDefaultSUID(Class cl) {
        if (!Serializable.class.isAssignableFrom(cl) || Proxy.isProxyClass(cl)) {
            return 0L;
        }
        try {
            int i;
            int i2;
            int i3;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(cl.getName());
            int classMods = cl.getModifiers() & 0x611;
            Method[] methods = cl.getDeclaredMethods();
            if ((classMods & 0x200) != 0) {
                classMods = methods.length > 0 ? classMods | 0x400 : classMods & 0xFFFFFBFF;
            }
            dout.writeInt(classMods);
            if (!cl.isArray()) {
                Class<?>[] interfaces = cl.getInterfaces();
                Object[] ifaceNames = new String[interfaces.length];
                for (i3 = 0; i3 < interfaces.length; ++i3) {
                    ifaceNames[i3] = interfaces[i3].getName();
                }
                Arrays.sort(ifaceNames);
                for (i3 = 0; i3 < ifaceNames.length; ++i3) {
                    dout.writeUTF((String)ifaceNames[i3]);
                }
            }
            Field[] fields = cl.getDeclaredFields();
            MemberSignature[] fieldSigs = new MemberSignature[fields.length];
            for (i3 = 0; i3 < fields.length; ++i3) {
                fieldSigs[i3] = new MemberSignature(fields[i3]);
            }
            Arrays.sort(fieldSigs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String name1 = ((MemberSignature)o1).name;
                    String name2 = ((MemberSignature)o2).name;
                    return name1.compareTo(name2);
                }
            });
            for (i3 = 0; i3 < fieldSigs.length; ++i3) {
                MemberSignature sig = fieldSigs[i3];
                int mods = sig.member.getModifiers() & 0xDF;
                if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
                dout.writeUTF(sig.name);
                dout.writeInt(mods);
                dout.writeUTF(sig.signature);
            }
            if (ObjectStreamClass.hasStaticInitializer(cl)) {
                dout.writeUTF("<clinit>");
                dout.writeInt(8);
                dout.writeUTF("()V");
            }
            Constructor<?>[] cons = cl.getDeclaredConstructors();
            MemberSignature[] consSigs = new MemberSignature[cons.length];
            for (i2 = 0; i2 < cons.length; ++i2) {
                consSigs[i2] = new MemberSignature(cons[i2]);
            }
            Arrays.sort(consSigs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String sig1 = ((MemberSignature)o1).signature;
                    String sig2 = ((MemberSignature)o2).signature;
                    return sig1.compareTo(sig2);
                }
            });
            for (i2 = 0; i2 < consSigs.length; ++i2) {
                MemberSignature sig = consSigs[i2];
                int mods = sig.member.getModifiers() & 0xD3F;
                if ((mods & 2) != 0) continue;
                dout.writeUTF("<init>");
                dout.writeInt(mods);
                dout.writeUTF(sig.signature.replace('/', '.'));
            }
            MemberSignature[] methSigs = new MemberSignature[methods.length];
            for (i = 0; i < methods.length; ++i) {
                methSigs[i] = new MemberSignature(methods[i]);
            }
            Arrays.sort(methSigs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    MemberSignature ms1 = (MemberSignature)o1;
                    MemberSignature ms2 = (MemberSignature)o2;
                    int comp = ms1.name.compareTo(ms2.name);
                    if (comp == 0) {
                        comp = ms1.signature.compareTo(ms2.signature);
                    }
                    return comp;
                }
            });
            for (i = 0; i < methSigs.length; ++i) {
                MemberSignature sig = methSigs[i];
                int mods = sig.member.getModifiers() & 0xD3F;
                if ((mods & 2) != 0) continue;
                dout.writeUTF(sig.name);
                dout.writeInt(mods);
                dout.writeUTF(sig.signature.replace('/', '.'));
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (int i4 = Math.min(hashBytes.length, 8) - 1; i4 >= 0; --i4) {
                hash = hash << 8 | (long)(hashBytes[i4] & 0xFF);
            }
            return hash;
        }
        catch (IOException ex) {
            throw new InternalError();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex.getMessage());
        }
    }

    private static native boolean hasStaticInitializer(Class var0);

    static ObjectStreamClass getClassDescriptor(Class cl, Map descriptorCache) {
        ObjectStreamClass desc;
        if (ObjectInOutConstants.CLASS_CACHE) {
            desc = (ObjectStreamClass)descriptorCache.get(cl);
            if (desc == null) {
                desc = ObjectStreamClass.lookup(cl, true);
                descriptorCache.put(cl, desc);
            }
        } else {
            desc = ObjectStreamClass.lookup(cl, true);
        }
        return desc;
    }

    static /* synthetic */ ObjectStreamField[] access$502(ObjectStreamClass x0, ObjectStreamField[] x1) {
        x0.fields = x1;
        return x1;
    }

    static {
        ObjectStreamClass.initStaticMethodArgs();
        try {
            System.loadLibrary("JeusObjIO");
        }
        catch (Throwable th) {
            UseReflect = true;
        }
        if (!UseReflect) {
            ObjectStreamClass.initNative();
        }
    }

    private static class MemberSignature {
        public final Member member;
        public final String name;
        public final String signature;

        public MemberSignature(Field field) {
            this.member = field;
            this.name = field.getName();
            this.signature = ObjectStreamClass.getClassSignature(field.getType());
        }

        public MemberSignature(Constructor cons) {
            this.member = cons;
            this.name = cons.getName();
            this.signature = ObjectStreamClass.getMethodSignature(cons.getParameterTypes(), Void.TYPE);
        }

        public MemberSignature(Method meth) {
            this.member = meth;
            this.name = meth.getName();
            this.signature = ObjectStreamClass.getMethodSignature(meth.getParameterTypes(), meth.getReturnType());
        }
    }

    static class ClassDataSlot {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass desc, boolean hasData) {
            this.desc = desc;
            this.hasData = hasData;
        }
    }

    private static class EntryFuture {
        private static final Object unset = new Object();
        private final Thread owner = Thread.currentThread();
        private Object entry = unset;

        private EntryFuture() {
        }

        synchronized boolean set(Object entry) {
            if (this.entry != unset) {
                return false;
            }
            this.entry = entry;
            this.notifyAll();
            return true;
        }

        synchronized Object get() {
            boolean interrupted = false;
            while (this.entry == unset) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                });
            }
            return this.entry;
        }

        Thread getOwner() {
            return this.owner;
        }
    }
}

