/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.reflect.bytecode;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jeus.thirdparty.asm.Attribute;
import jeus.thirdparty.asm.ClassReader;
import jeus.thirdparty.asm.ClassVisitor;
import jeus.thirdparty.asm.CodeVisitor;
import jeus.thirdparty.asm.Type;
import jeus.thirdparty.asm.attrs.Annotation;
import jeus.thirdparty.asm.attrs.Attributes;
import jeus.thirdparty.asm.attrs.RuntimeInvisibleAnnotations;
import jeus.thirdparty.asm.attrs.RuntimeVisibleAnnotations;
import jeus.util.reflect.AnnotationInfo;
import jeus.util.reflect.BytecodeReader;
import jeus.util.reflect.ClassInfo;
import jeus.util.reflect.EnumInfo;
import jeus.util.reflect.TypeInfo;
import jeus.util.reflect.bytecode.BytecodeClassInfo;
import jeus.util.reflect.bytecode.BytecodeConstructorInfo;
import jeus.util.reflect.bytecode.BytecodeFieldInfo;
import jeus.util.reflect.bytecode.BytecodeMethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMClassReader
extends BytecodeReader {
    private ClassInfo readClass(ClassReader cr) throws IOException {
        ClassProcessor processor = new ClassProcessor();
        cr.accept((ClassVisitor)processor, Attributes.getDefaultAttributes(), true);
        return processor.getClassInfo();
    }

    @Override
    public ClassInfo readClass(String className) throws IOException {
        ClassReader cr = new ClassReader(className);
        return this.readClass(cr);
    }

    @Override
    public ClassInfo readClass(InputStream is) throws IOException {
        ClassReader cr = new ClassReader(is);
        return this.readClass(cr);
    }

    static String getNormalClassName(String internalName) {
        if (internalName == null) {
            return null;
        }
        return internalName.replace('/', '.');
    }

    static String[] getNormalClassNames(String[] internalNames) {
        if (internalNames == null) {
            return null;
        }
        String[] names = new String[internalNames.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ASMClassReader.getNormalClassName(internalNames[i]);
        }
        return names;
    }

    public static List<AnnotationInfo> getAnnotationInfos(Attribute attr) {
        Vector<AnnotationInfo> list = new Vector<AnnotationInfo>();
        while (attr != null) {
            List<AnnotationInfo> annotations;
            RuntimeVisibleAnnotations anns;
            if (attr instanceof RuntimeVisibleAnnotations) {
                anns = (RuntimeVisibleAnnotations)attr;
                annotations = ASMClassReader.convertAnnotations(anns.annotations);
                list.addAll(annotations);
            } else if (attr instanceof RuntimeInvisibleAnnotations) {
                anns = (RuntimeInvisibleAnnotations)attr;
                annotations = ASMClassReader.convertAnnotations(anns.annotations);
                list.addAll(annotations);
            }
            attr = attr.next;
        }
        return list;
    }

    private static List<AnnotationInfo> convertAnnotations(List annotations) {
        Vector<AnnotationInfo> result = new Vector<AnnotationInfo>();
        for (Annotation ann : annotations) {
            result.add(ASMClassReader.convertAnnotation(ann));
        }
        return result;
    }

    private static AnnotationInfo convertAnnotation(Annotation a) {
        AnnotationInfo result = null;
        try {
            TypeInfo typeInfo = ASMClassReader.convert2TypeInfo(a.type);
            HashMap<String, Object> elementValues = new HashMap<String, Object>();
            for (Object[] nameValue : a.elementValues) {
                String name = (String)nameValue[0];
                Object value = ASMClassReader.convertValue(nameValue[1]);
                elementValues.put(name, value);
            }
            result = new AnnotationInfo(typeInfo, elementValues);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Object convertValue(Object object) {
        Object[] result = object;
        if (object instanceof Annotation.EnumConstValue) {
            Annotation.EnumConstValue value = (Annotation.EnumConstValue)object;
            TypeInfo type = ASMClassReader.convert2TypeInfo(value.typeName);
            result = new EnumInfo(type, value.constName);
        } else if (object instanceof Type) {
            Type value = (Type)object;
            result = TypeInfo.getType(value.getClassName());
        } else if (object instanceof Annotation) {
            Annotation value = (Annotation)object;
            result = ASMClassReader.convertAnnotation(value);
        } else if (object instanceof Object[]) {
            int length = Array.getLength(object);
            Object[] arr = object;
            if (length == 0) {
                return null;
            }
            Class<?> compType = arr[0].getClass();
            if (compType.equals(String.class)) {
                String[] strs = new String[length];
                for (int i = 0; i < length; ++i) {
                    strs[i] = (String)ASMClassReader.convertValue(arr[i]);
                }
                result = strs;
            } else if (compType.equals(Annotation.EnumConstValue.class)) {
                EnumInfo[] enums = new EnumInfo[length];
                for (int i = 0; i < length; ++i) {
                    enums[i] = (EnumInfo)ASMClassReader.convertValue(arr[i]);
                }
                result = enums;
            } else if (compType.equals(Type.class)) {
                TypeInfo[] types = new TypeInfo[length];
                for (int i = 0; i < length; ++i) {
                    types[i] = (TypeInfo)ASMClassReader.convertValue(arr[i]);
                }
                result = types;
            } else if (compType.equals(Annotation.class)) {
                AnnotationInfo[] anns = new AnnotationInfo[length];
                for (int i = 0; i < length; ++i) {
                    anns[i] = (AnnotationInfo)ASMClassReader.convertValue(arr[i]);
                }
                result = anns;
            }
        }
        return result;
    }

    private static TypeInfo convert2TypeInfo(String typeDescriptor) {
        Type asmType = Type.getType((String)typeDescriptor);
        return TypeInfo.getType(asmType.getClassName());
    }

    private static class ClassProcessor
    implements ClassVisitor {
        protected BytecodeClassInfo classInfo;
        protected boolean finished;

        private ClassProcessor() {
        }

        public BytecodeClassInfo getClassInfo() {
            return this.classInfo;
        }

        public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
            String className = ASMClassReader.getNormalClassName(name);
            String superClassName = ASMClassReader.getNormalClassName(superName);
            String[] ifNames = ASMClassReader.getNormalClassNames(interfaces);
            this.classInfo = new BytecodeClassInfo(access, className, superClassName, ifNames);
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
            List<AnnotationInfo> annotations = ASMClassReader.getAnnotationInfos(attrs);
            BytecodeFieldInfo field = new BytecodeFieldInfo(access, name, null, null);
            field.addAnnotations(annotations);
            this.classInfo.addField(field);
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            List<AnnotationInfo> annotations = ASMClassReader.getAnnotationInfos(attrs);
            Type[] paramTypes = Type.getArgumentTypes((String)desc);
            TypeInfo[] params = new TypeInfo[paramTypes.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = TypeInfo.getType(paramTypes[i].getClassName());
            }
            if (name.equals("<init>")) {
                BytecodeConstructorInfo constr = new BytecodeConstructorInfo(access, params, null);
                constr.addAnnotations(annotations);
                this.classInfo.addConstructor(constr);
            } else {
                BytecodeMethodInfo method = new BytecodeMethodInfo(access, name, params, null);
                method.addAnnotations(annotations);
                this.classInfo.addMethod(method);
            }
            return null;
        }

        public void visitAttribute(Attribute attr) {
            List<AnnotationInfo> annotations = ASMClassReader.getAnnotationInfos(attr);
            this.classInfo.addAnnotations(annotations);
        }

        public void visitEnd() {
            this.finished = true;
        }
    }
}

