/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.reflect.bytecode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jeus.util.reflect.ClassInfo;
import jeus.util.reflect.ConstructorInfo;
import jeus.util.reflect.FieldInfo;
import jeus.util.reflect.MethodInfo;
import jeus.util.reflect.PackageInfo;
import jeus.util.reflect.TypeInfo;
import jeus.util.reflect.bytecode.BasicInfoSupport;
import jeus.util.reflect.bytecode.BytecodeConstructorInfo;
import jeus.util.reflect.bytecode.BytecodeFieldInfo;
import jeus.util.reflect.bytecode.BytecodeMethodInfo;
import jeus.util.reflect.bytecode.BytecodePackageInfo;

class BytecodeClassInfo
extends BasicInfoSupport
implements ClassInfo {
    protected String superClass;
    protected String[] interfaces;
    protected PackageInfo pkgInfo;
    protected Map<String, FieldInfo> declaredFields;
    protected List<BytecodeConstructorInfo> constructors;
    protected List<BytecodeMethodInfo> methods;

    protected BytecodeClassInfo(int access, String name, String superClass, String[] interfaces) {
        this.name = name;
        this.modifiers = access;
        this.superClass = superClass;
        this.interfaces = interfaces;
        int lastdotpos = name.lastIndexOf(46);
        this.pkgInfo = lastdotpos != -1 ? new BytecodePackageInfo(name.substring(0, lastdotpos)) : null;
        this.declaredFields = new HashMap<String, FieldInfo>();
        this.constructors = new Vector<BytecodeConstructorInfo>();
        this.methods = new Vector<BytecodeMethodInfo>();
    }

    public PackageInfo getPackage() {
        return this.pkgInfo;
    }

    public boolean isInterface() {
        return false;
    }

    public FieldInfo[] getDeclaredFields() {
        return null;
    }

    public FieldInfo getDeclaredField(String name) throws NoSuchFieldException {
        FieldInfo f = this.declaredFields.get(name);
        if (f == null) {
            throw new NoSuchFieldException(name);
        }
        return f;
    }

    public FieldInfo[] getFields() {
        return null;
    }

    public FieldInfo getField(String name) throws NoSuchFieldException {
        return null;
    }

    public ConstructorInfo[] getDeclaredConstructors() {
        return this.constructors.toArray(new ConstructorInfo[0]);
    }

    public ConstructorInfo getDeclaredConstructor(TypeInfo ... parameterTypes) throws NoSuchMethodException {
        for (BytecodeConstructorInfo constructor : this.constructors) {
            if (!Arrays.equals(constructor.getParameterTypes(), parameterTypes)) continue;
            return constructor;
        }
        throw new NoSuchMethodException();
    }

    public ConstructorInfo[] getConstructors() {
        return null;
    }

    public ConstructorInfo getConstructor(TypeInfo ... parameterTypes) throws NoSuchMethodException {
        return null;
    }

    public MethodInfo[] getDeclaredMethods() {
        return null;
    }

    public MethodInfo getDeclaredMethod(String name, TypeInfo ... parameterTypes) throws NoSuchMethodException {
        for (BytecodeMethodInfo method : this.methods) {
            if (!method.getName().equals(name) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
            return method;
        }
        throw new NoSuchMethodException();
    }

    public MethodInfo[] getMethods() {
        return null;
    }

    public Class getReflectionObject() {
        return null;
    }

    void addField(BytecodeFieldInfo field) {
        this.declaredFields.put(field.getName(), field);
        field.setDeclaringClass(this);
    }

    void addMethod(BytecodeMethodInfo method) {
        this.methods.add(method);
        method.setDeclaringClass(this);
    }

    void addConstructor(BytecodeConstructorInfo constr) {
        this.constructors.add(constr);
        constr.setDeclaringClass(this);
    }

    public TypeInfo getType() {
        return null;
    }
}

