/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.sysmon;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import jeus.util.OS;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.sysmon.CPUStat;
import jeus.util.sysmon.CPUStats;
import jeus.util.sysmon.LinuxCPUMonitor;
import jeus.util.sysmon.WindowsCPUMonitor;

public abstract class CPUMonitor {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)CPUMonitor.class.getName());
    protected static final ScheduledExecutor executor = ScheduledExecutor.getInstance();
    protected static final int numProcessors = Runtime.getRuntime().availableProcessors();
    protected int interval;
    protected boolean started;
    protected ScheduledFuture future;
    protected long lastCheckTime;
    protected CPUStats lastCheckStats;
    protected volatile double lastCPUUsageRate;

    public static CPUMonitor createInstance() {
        if (OS.isLinux()) {
            return new LinuxCPUMonitor();
        }
        if (OS.isWindows()) {
            return new WindowsCPUMonitor();
        }
        return null;
    }

    public final boolean isStarted() {
        return this.started;
    }

    public final void start(int interval) throws IllegalStateException {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        try {
            this.doStart();
        }
        catch (IllegalStateException ise) {
            this.started = false;
            throw ise;
        }
        Task task = new Task();
        this.future = executor.scheduleWithFixedDelay(task, interval, interval, TimeUnit.MILLISECONDS);
    }

    public final void stop() {
        if (!this.started || this.future == null) {
            return;
        }
        this.future.cancel(true);
        this.doStop();
        this.started = false;
    }

    public final double getHostCPUUsageRate() {
        return this.lastCPUUsageRate;
    }

    protected abstract CPUStats getCurrentCPUStats();

    protected abstract void doStart();

    protected abstract void doStop();

    private class Task
    implements Runnable {
        private Task() {
        }

        public void run() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[CPUMonitor] task is triggered");
            }
            long thisTime = System.currentTimeMillis();
            CPUStats thisStats = CPUMonitor.this.getCurrentCPUStats();
            if (CPUMonitor.this.lastCheckTime != 0L) {
                CPUStat thisTotalStat = thisStats.getTotalStat();
                CPUStat lastTotalStat = CPUMonitor.this.lastCheckStats.getTotalStat();
                CPUMonitor.this.lastCPUUsageRate = (double)(thisTotalStat.getNonIdleTime() - lastTotalStat.getNonIdleTime()) / (double)(thisTotalStat.getTotalTime() - lastTotalStat.getTotalTime());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "[CPUMonitor] last CPU usage rate = " + CPUMonitor.this.lastCPUUsageRate);
                }
            }
            CPUMonitor.this.lastCheckTime = thisTime;
            CPUMonitor.this.lastCheckStats = thisStats;
        }
    }
}

