/*
 * Decompiled with CFR 0.152.
 */
package jeus.webserver;

import java.io.File;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;
import jeus.management.j2ee.webserver.WebServerInfo;
import jeus.security.util.LoginUtil;
import jeus.server.enginecontainer.EngineContainer;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebtoBLight;
import jeus.webserver.Constants;
import jeus.webserver.NodeDescriptor;
import jeus.webserver.Shmc;
import jeus.webserver.SvrDescriptor;
import jeus.webserver.SvrDescriptors;
import jeus.webserver.WebServerProxy;
import jeus.webserver.WebtobControl;

public class WebServerProxyImpl
implements WebServerProxy,
WebtobControl {
    private static final JeusLogger logger = Constants.logger;
    private WebServerInfo wsengine;
    private String wsname;
    private Shmc shmc = new Shmc();
    private NodeDescriptor nodedesc;
    private SvrDescriptors svrdescs;
    private boolean flag = false;
    private boolean isRunning = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean boot(String[] args) throws Exception {
        LoginUtil.loginCodeSubjectWithRuntimeException();
        try {
            this.wscflCompile();
            if (!this.wsboot()) {
                boolean bl = false;
                return bl;
            }
            this.wsname = args[0];
            if (this.initialize()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            LoginUtil.logoutWithRuntimeException();
        }
    }

    private void wscflCompile() {
        block3: {
            String webtobHome = JeusBootstrapProperties.JEUS_HOME + File.separator + "webserver";
            String webtobConfigDir = webtobHome + File.separator + "config";
            File webtobConfigFile = new File(webtobConfigDir + File.separator + "ws_engine.m");
            File webtobConfigBinaryFile = new File(webtobConfigDir + File.separator + "wsconfig");
            if (!webtobConfigBinaryFile.exists() || webtobConfigFile.lastModified() - webtobConfigBinaryFile.lastModified() > 0L) {
                String cmd = webtobHome + File.separator + "bin" + File.separator + "wscfl";
                Vector<String> vector = new Vector<String>();
                vector.add(cmd);
                vector.add("-i");
                vector.add(webtobConfigDir + File.separator + "ws_engine.m");
                vector.add("-o");
                vector.add(webtobConfigDir + File.separator + "wsconfig");
                String[] command = new String[]{};
                command = vector.toArray(command);
                Runtime runtime = Runtime.getRuntime();
                try {
                    Process process = runtime.exec(command);
                    process.waitFor();
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_WebtoBLight._1403_LEVEL)) break block3;
                    logger.log(JeusMessage_WebtoBLight._1403_LEVEL, JeusMessage_WebtoBLight._1403, vector, t);
                }
            }
        }
    }

    public void down() throws JeusException {
        if (!this.isRunning) {
            throw new JeusException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebtoBLight._1303, (Object)this.wsname));
        }
        this.exit();
        if (!this.wsdown()) {
            throw new JeusException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebtoBLight._1304, (Object)this.wsname));
        }
        try {
            this.wsengine.destroyMBean();
        }
        catch (Exception e) {
            throw new JeusException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebtoBLight._1305, (Object)this.wsname));
        }
    }

    public NodeDescriptor getNodeDescriptor() throws RemoteException {
        if (!this.flag) {
            this.initialize();
        }
        return this.nodedesc;
    }

    public int getSvrCount() throws RemoteException {
        if (!this.flag) {
            this.initialize();
        }
        return this.svrdescs.getSvrCount();
    }

    public SvrDescriptor getSvrInfo(int index) throws RemoteException {
        if (!this.flag) {
            this.initialize();
        }
        return this.svrdescs.getSvrInfo(index);
    }

    public SvrDescriptor[] getAllSvr() throws RemoteException {
        if (!this.flag) {
            this.initialize();
        }
        return this.svrdescs.getAllSvr();
    }

    public SvrDescriptor getSvrInfo(String svrname) throws RemoteException {
        if (!this.flag) {
            this.initialize();
        }
        return this.svrdescs.getSvrInfo(svrname);
    }

    public boolean isRunning() throws RemoteException {
        return this.isRunning;
    }

    private boolean initialize() {
        block5: {
            if (this.shmc.register() == -1) {
                return false;
            }
            try {
                TimeStatisticImpl avgTime = new TimeStatisticImpl("AvgTime", "millisecond", "the time spent waiting for a connection to be available");
                CountStatisticImpl svrCount = new CountStatisticImpl("SvrCount", "process", "the number of server process");
                CountStatisticImpl execCount = new CountStatisticImpl("ExecCount", "process", "the number of server process");
                this.wsengine = (WebServerInfo)WebServerInfo.createMBean(this.wsname, EngineContainer.serverMBean.getObjectName(), this);
                this.wsengine.setStatistic((StatisticImpl)avgTime);
                this.wsengine.setStatistic((StatisticImpl)svrCount);
                this.wsengine.setStatistic((StatisticImpl)execCount);
            }
            catch (InstanceAlreadyExistsException e) {
                if (logger.isLoggable(JeusMessage_WebtoBLight._1301_LEVEL)) {
                    logger.log(JeusMessage_WebtoBLight._1301_LEVEL, JeusMessage_WebtoBLight._1301, (Throwable)e);
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_WebtoBLight._1302_LEVEL)) break block5;
                logger.log(JeusMessage_WebtoBLight._1302_LEVEL, JeusMessage_WebtoBLight._1302, t);
            }
        }
        this.nodedesc = new NodeDescriptor();
        this.nodedesc.setNodeName(this.shmc.getNodeName());
        this.nodedesc.setNodePort(this.shmc.getNodePort());
        this.nodedesc.setPort(this.shmc.getPort());
        this.nodedesc.setJsvPort(this.shmc.getJsvPort());
        this.nodedesc.setSslFlag(this.shmc.getSSLFlag());
        this.nodedesc.setSvrCount(this.shmc.getNodeCount());
        this.nodedesc.setHthCount(this.shmc.getNodeHTH());
        this.svrdescs = new SvrDescriptors(this.shmc);
        this.svrdescs.initialize();
        this.flag = true;
        return this.flag;
    }

    private boolean wsboot() {
        if (this.webServerBoot()) {
            this.isRunning = true;
            return true;
        }
        this.isRunning = false;
        return false;
    }

    private boolean wsdown() {
        boolean bRet = this.webServerDown();
        this.isRunning = !bRet;
        int MaxIter = 2;
        int time = 0;
        while (++time < MaxIter && !bRet) {
            bRet = this.webServerDown();
            if (bRet) {
                this.isRunning = false;
                break;
            }
            this.isRunning = true;
        }
        return bRet;
    }

    private void exit() {
        this.shmc.exit();
        this.flag = false;
    }

    private native int jniwsboot();

    private native int jnidown();

    private native int jnisvrboot(String var1);

    private native int jnisvrdown(String var1);

    public boolean webServerBoot() {
        return this.jniwsboot() != 0;
    }

    public boolean webServerDown() {
        return this.jnidown() != 0;
    }

    public boolean svrBoot(String svrName) {
        return this.jnisvrboot(svrName) != 0;
    }

    public boolean svrDown(String svrName) {
        return this.jnisvrdown(svrName) != 0;
    }

    static {
        System.loadLibrary("WebtoBAdmin");
    }
}

