/*
 * Decompiled with CFR 0.152.
 */
package jeus.webserver;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jeus.util.CUtility;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebtoBLight;
import jeus.webserver.Constants;
import jeus.webserver.WebtobControl;

public class WebtobControlInJava
implements WebtobControl {
    private static final JeusLogger logger = Constants.logger;

    public boolean webServerBoot() {
        return this.wsBoot(null);
    }

    public boolean webServerDown() {
        return this.wsDown(null);
    }

    public boolean svrBoot(String svrName) {
        return this.wsBoot(svrName);
    }

    public boolean svrDown(String svrName) {
        return this.wsDown(svrName);
    }

    private boolean wsBoot(String svrName) {
        String webtobdir = this.getWebtobDir();
        if (webtobdir == null) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1500_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1500_LEVEL, JeusMessage_WebtoBLight._1500);
            }
            return false;
        }
        String cmd = webtobdir;
        if (!cmd.endsWith(File.separator)) {
            cmd = cmd + File.separator;
        }
        cmd = cmd + "bin" + File.separator + "wsboot";
        if (Constants.OS_WINDOWS) {
            cmd = cmd + ".exe";
        }
        if (svrName != null) {
            cmd = cmd + " -s " + svrName;
        }
        try {
            this.execProcess(cmd);
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1501_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1501_LEVEL, JeusMessage_WebtoBLight._1501, (Throwable)ioe);
            }
            return false;
        }
        catch (InterruptedException ie) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1501_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1501_LEVEL, JeusMessage_WebtoBLight._1501, (Throwable)ie);
            }
            return false;
        }
        if (logger.isLoggable(JeusMessage_WebtoBLight._1502_LEVEL)) {
            logger.log(JeusMessage_WebtoBLight._1502_LEVEL, JeusMessage_WebtoBLight._1502);
        }
        return true;
    }

    private boolean wsDown(String svrName) {
        String webtobdir = this.getWebtobDir();
        if (webtobdir == null) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1503_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1503_LEVEL, JeusMessage_WebtoBLight._1503);
            }
            return false;
        }
        String cmd = webtobdir;
        if (!cmd.endsWith(File.separator)) {
            cmd = cmd + File.separator;
        }
        cmd = cmd + "bin" + File.separator + "wsdown";
        if (Constants.OS_WINDOWS) {
            cmd = cmd + ".exe";
        }
        cmd = svrName != null ? cmd + " -s " + svrName : cmd + " -i";
        try {
            this.execProcess(cmd);
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1504_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1504_LEVEL, JeusMessage_WebtoBLight._1504, (Throwable)ioe);
            }
            return false;
        }
        catch (InterruptedException ie) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1504_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1504_LEVEL, JeusMessage_WebtoBLight._1504, (Throwable)ie);
            }
            return false;
        }
        if (logger.isLoggable(JeusMessage_WebtoBLight._1505_LEVEL)) {
            logger.log(JeusMessage_WebtoBLight._1505_LEVEL, JeusMessage_WebtoBLight._1505);
        }
        return true;
    }

    private void execProcess(String cmd) throws IOException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        Process webServerProc = null;
        webServerProc = runtime.exec(cmd);
        InputStream inputstream = webServerProc.getInputStream();
        InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        try {
            String line;
            while ((line = bufferedreader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            try {
                if (bufferedreader != null) {
                    bufferedreader.close();
                    bufferedreader = null;
                }
                if (inputstreamreader != null) {
                    inputstreamreader.close();
                    inputstreamreader = null;
                }
                if (inputstream != null) {
                    inputstream.close();
                    inputstream = null;
                }
            }
            catch (IOException e) {}
        }
        if (webServerProc.waitFor() != 0 && logger.isLoggable(JeusMessage_WebtoBLight._1506_LEVEL)) {
            logger.log(JeusMessage_WebtoBLight._1506_LEVEL, JeusMessage_WebtoBLight._1506, (Object)String.valueOf(webServerProc.exitValue()));
        }
    }

    private String getWebtobDir() {
        String webtobdir = null;
        try {
            webtobdir = System.getenv().get("WEBTOBDIR");
        }
        catch (NoSuchMethodError nsme) {
            webtobdir = CUtility.getenv((String)"WEBTOBDIR");
        }
        if (webtobdir == null) {
            return null;
        }
        return StringUtil.normalizeFileSeparator((String)webtobdir);
    }
}

