/*
 * Decompiled with CFR 0.152.
 */
package jeus.workarea;

import java.io.Serializable;
import java.util.ArrayList;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WorkArea;
import jeus.workarea.NoWorkAreaException;
import jeus.workarea.NotOriginatorException;
import jeus.workarea.PropertyModeType;
import jeus.workarea.PropertyReadOnlyException;
import jeus.workarea.UserWorkArea;
import jeus.workarea.UserWorkAreaItem;
import jeus.workarea.UserWorkAreaPartition;
import jeus.workarea.UserWorkAreaValueItem;
import jeus.workarea.WorkAreaLogger;

class UserWorkAreaImpl
implements UserWorkArea {
    private static final ThreadLocal<UserWorkAreaPartition> currentWorkArea = new ThreadLocal();
    private static final JeusLogger logger = WorkAreaLogger.logger;

    UserWorkAreaImpl() {
    }

    public void begin(String name) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null");
        }
        if (UserWorkAreaImpl.getCurrent() == null) {
            UserWorkAreaImpl.setCurrent(new UserWorkAreaPartition());
        }
        UserWorkAreaPartition uwap = UserWorkAreaImpl.getCurrent();
        uwap.push(new UserWorkAreaItem(name));
        if (logger.isLoggable(JeusMessage_WorkArea._1000_LEVEL)) {
            int stackNum = uwap.size();
            logger.log(JeusMessage_WorkArea._1000_LEVEL, JeusMessage_WorkArea._1000, new Object[]{name, stackNum});
        }
    }

    public void complete() throws NoWorkAreaException, NotOriginatorException {
        UserWorkAreaPartition uwap = UserWorkAreaImpl.getCurrent();
        if (uwap == null) {
            throw new NoWorkAreaException("UserWorkArea never begined");
        }
        if (uwap.size() == 0) {
            throw new NoWorkAreaException("All UserWorkAreas complete");
        }
        if (!((UserWorkAreaItem)uwap.peek()).isOriginated()) {
            throw new NotOriginatorException("This WorkArea is propagated. Can't modify");
        }
        UserWorkAreaItem item = (UserWorkAreaItem)uwap.pop();
        if (logger.isLoggable(JeusMessage_WorkArea._1001_LEVEL)) {
            String name = item != null ? item.getName() : null;
            int stackNum = uwap.size() + 1;
            logger.log(JeusMessage_WorkArea._1001_LEVEL, JeusMessage_WorkArea._1001, new Object[]{name, stackNum});
        }
    }

    public String getName() {
        UserWorkAreaPartition area = UserWorkAreaImpl.getCurrent();
        if (area == null) {
            return null;
        }
        if (area.peek() == null) {
            return null;
        }
        return ((UserWorkAreaItem)area.peek()).getName();
    }

    public String[] retrieveAllKeys() {
        UserWorkAreaPartition area = UserWorkAreaImpl.getCurrent();
        if (area == null) {
            return null;
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (int i = 0; i < area.size(); ++i) {
            for (String key : ((UserWorkAreaItem)area.get(i)).keySet()) {
                if (keyList.contains(key)) continue;
                keyList.add(key);
            }
        }
        if (keyList.size() == 0) {
            return null;
        }
        String[] keyArray = new String[keyList.size()];
        for (int i = 0; i < keyList.size(); ++i) {
            keyArray[i] = (String)keyList.get(i);
        }
        return keyArray;
    }

    public void set(String key, Serializable value) throws NoWorkAreaException, NotOriginatorException, PropertyReadOnlyException {
        this.set(key, value, PropertyModeType.NORMAL);
    }

    public void set(String key, Serializable value, PropertyModeType mode) throws NoWorkAreaException, NotOriginatorException, PropertyReadOnlyException {
        if (key == null || mode == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (UserWorkAreaImpl.getCurrent() == null) {
            throw new NoWorkAreaException("UserWorkArea never begined");
        }
        if (UserWorkAreaImpl.getCurrent().empty()) {
            throw new NoWorkAreaException("All UserWorkAreas complete");
        }
        UserWorkAreaItem item = (UserWorkAreaItem)UserWorkAreaImpl.getCurrent().peek();
        if (!item.isOriginated()) {
            throw new NotOriginatorException("This WorkArea is propagated. Can't modify");
        }
        UserWorkAreaValueItem valueItem = this.getValueItem(key);
        if (valueItem != null && valueItem.getMode() == PropertyModeType.READ_ONLY) {
            throw new PropertyReadOnlyException("Property mode is READ_ONLY. Can't modify");
        }
        item.put(key, new UserWorkAreaValueItem(value, mode));
    }

    public Serializable get(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        UserWorkAreaValueItem item = this.getValueItem(key);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public PropertyModeType getMode(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        UserWorkAreaValueItem item = this.getValueItem(key);
        if (item != null) {
            return item.getMode();
        }
        return null;
    }

    public void remove(String key) throws NoWorkAreaException, NotOriginatorException, PropertyReadOnlyException {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        UserWorkAreaPartition userWorkAreaPartition = UserWorkAreaImpl.getCurrent();
        if (userWorkAreaPartition == null) {
            throw new NoWorkAreaException("UserWorkArea never begined");
        }
        if (userWorkAreaPartition.empty()) {
            throw new NoWorkAreaException("All UserWorkAreas complete");
        }
        UserWorkAreaItem areaItem = (UserWorkAreaItem)userWorkAreaPartition.peek();
        if (areaItem.containsKey(key)) {
            if (!areaItem.isOriginated()) {
                throw new NotOriginatorException("This WorkArea is propagated. Can't modify");
            }
            UserWorkAreaValueItem item = (UserWorkAreaValueItem)areaItem.get(key);
            if (item.getMode().equals((Object)PropertyModeType.READ_ONLY)) {
                throw new PropertyReadOnlyException("Property mode is READ_ONLY. Can't modify");
            }
            areaItem.remove(key);
        }
    }

    static UserWorkAreaPartition getCurrent() {
        return currentWorkArea.get();
    }

    static void setCurrent(UserWorkAreaPartition workArea) {
        currentWorkArea.set(workArea);
    }

    static void clear() {
        try {
            if (currentWorkArea.get() != null && currentWorkArea.get().size() > 0) {
                if (logger.isLoggable(JeusMessage_WorkArea._1002_LEVEL)) {
                    logger.log(JeusMessage_WorkArea._1002_LEVEL, JeusMessage_WorkArea._1002, (Object)currentWorkArea.get().size());
                }
                currentWorkArea.remove();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private UserWorkAreaValueItem getValueItem(String key) {
        UserWorkAreaPartition partition = UserWorkAreaImpl.getCurrent();
        if (partition == null) {
            return null;
        }
        for (int i = partition.size() - 1; i > -1; --i) {
            UserWorkAreaValueItem item = (UserWorkAreaValueItem)((UserWorkAreaItem)partition.get(i)).get(key);
            if (item == null) continue;
            return item;
        }
        return null;
    }
}

